/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.model.facets.logic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonTagExtractor {
    private static final Logger LOG = LogManager.getLogger((String)CommonTagExtractor.class.getName());
    public static final BiMap<String, Integer> mimeTypes = HashBiMap.create((int)775);

    public static Integer getMimeTypeCode(String type) {
        if (type == null) {
            return 0;
        }
        if (mimeTypes.containsKey((Object)type.toLowerCase())) {
            return (Integer)mimeTypes.get((Object)type.toLowerCase());
        }
        LOG.error("Not recognized mimetype: " + type);
        return 0;
    }

    static {
        mimeTypes.put((Object)"", (Object)0);
        mimeTypes.put((Object)"application/andrew-inset", (Object)1);
        mimeTypes.put((Object)"application/applixware", (Object)2);
        mimeTypes.put((Object)"application/atom+xml", (Object)3);
        mimeTypes.put((Object)"application/atomcat+xml", (Object)4);
        mimeTypes.put((Object)"application/atomsvc+xml", (Object)5);
        mimeTypes.put((Object)"application/ccxml+xml", (Object)6);
        mimeTypes.put((Object)"application/cdmi-capability", (Object)7);
        mimeTypes.put((Object)"application/cdmi-container", (Object)8);
        mimeTypes.put((Object)"application/cdmi-domain", (Object)9);
        mimeTypes.put((Object)"application/cdmi-object", (Object)10);
        mimeTypes.put((Object)"application/cdmi-queue", (Object)11);
        mimeTypes.put((Object)"application/cu-seeme", (Object)12);
        mimeTypes.put((Object)"application/davmount+xml", (Object)13);
        mimeTypes.put((Object)"application/docbook+xml", (Object)14);
        mimeTypes.put((Object)"application/dssc+der", (Object)15);
        mimeTypes.put((Object)"application/dssc+xml", (Object)16);
        mimeTypes.put((Object)"application/ecmascript", (Object)17);
        mimeTypes.put((Object)"application/emma+xml", (Object)18);
        mimeTypes.put((Object)"application/epub+zip", (Object)19);
        mimeTypes.put((Object)"application/exi", (Object)20);
        mimeTypes.put((Object)"application/font-tdpfr", (Object)21);
        mimeTypes.put((Object)"application/gml+xml", (Object)22);
        mimeTypes.put((Object)"application/gpx+xml", (Object)23);
        mimeTypes.put((Object)"application/gxf", (Object)24);
        mimeTypes.put((Object)"application/hyperstudio", (Object)25);
        mimeTypes.put((Object)"application/inkml+xml", (Object)26);
        mimeTypes.put((Object)"application/ipfix", (Object)27);
        mimeTypes.put((Object)"application/java-archive", (Object)28);
        mimeTypes.put((Object)"application/java-serialized-object", (Object)29);
        mimeTypes.put((Object)"application/java-vm", (Object)30);
        mimeTypes.put((Object)"application/javascript", (Object)31);
        mimeTypes.put((Object)"application/json", (Object)32);
        mimeTypes.put((Object)"application/jsonml+json", (Object)33);
        mimeTypes.put((Object)"application/lost+xml", (Object)34);
        mimeTypes.put((Object)"application/mac-binhex40", (Object)35);
        mimeTypes.put((Object)"application/mac-compactpro", (Object)36);
        mimeTypes.put((Object)"application/mads+xml", (Object)37);
        mimeTypes.put((Object)"application/marc", (Object)38);
        mimeTypes.put((Object)"application/marcxml+xml", (Object)39);
        mimeTypes.put((Object)"application/mathematica", (Object)40);
        mimeTypes.put((Object)"application/mathml+xml", (Object)41);
        mimeTypes.put((Object)"application/mbox", (Object)42);
        mimeTypes.put((Object)"application/mediaservercontrol+xml", (Object)43);
        mimeTypes.put((Object)"application/metalink+xml", (Object)44);
        mimeTypes.put((Object)"application/metalink4+xml", (Object)45);
        mimeTypes.put((Object)"application/mets+xml", (Object)46);
        mimeTypes.put((Object)"application/mods+xml", (Object)47);
        mimeTypes.put((Object)"application/mp21", (Object)48);
        mimeTypes.put((Object)"application/mp4", (Object)49);
        mimeTypes.put((Object)"application/msword", (Object)50);
        mimeTypes.put((Object)"application/mxf", (Object)51);
        mimeTypes.put((Object)"application/octet-stream", (Object)52);
        mimeTypes.put((Object)"application/oda", (Object)53);
        mimeTypes.put((Object)"application/oebps-package+xml", (Object)54);
        mimeTypes.put((Object)"application/ogg", (Object)55);
        mimeTypes.put((Object)"application/omdoc+xml", (Object)56);
        mimeTypes.put((Object)"application/onenote", (Object)57);
        mimeTypes.put((Object)"application/oxps", (Object)58);
        mimeTypes.put((Object)"application/patch-ops-error+xml", (Object)59);
        mimeTypes.put((Object)"application/pdf", (Object)60);
        mimeTypes.put((Object)"application/pgp-encrypted", (Object)61);
        mimeTypes.put((Object)"application/pgp-signature", (Object)62);
        mimeTypes.put((Object)"application/pics-rules", (Object)63);
        mimeTypes.put((Object)"application/pkcs10", (Object)64);
        mimeTypes.put((Object)"application/pkcs7-mime", (Object)65);
        mimeTypes.put((Object)"application/pkcs7-signature", (Object)66);
        mimeTypes.put((Object)"application/pkcs8", (Object)67);
        mimeTypes.put((Object)"application/pkix-attr-cert", (Object)68);
        mimeTypes.put((Object)"application/pkix-cert", (Object)69);
        mimeTypes.put((Object)"application/pkix-crl", (Object)70);
        mimeTypes.put((Object)"application/pkix-pkipath", (Object)71);
        mimeTypes.put((Object)"application/pkixcmp", (Object)72);
        mimeTypes.put((Object)"application/pls+xml", (Object)73);
        mimeTypes.put((Object)"application/postscript", (Object)74);
        mimeTypes.put((Object)"application/prs.cww", (Object)75);
        mimeTypes.put((Object)"application/pskc+xml", (Object)76);
        mimeTypes.put((Object)"application/rdf+xml", (Object)77);
        mimeTypes.put((Object)"application/reginfo+xml", (Object)78);
        mimeTypes.put((Object)"application/relax-ng-compact-syntax", (Object)79);
        mimeTypes.put((Object)"application/resource-lists+xml", (Object)80);
        mimeTypes.put((Object)"application/resource-lists-diff+xml", (Object)81);
        mimeTypes.put((Object)"application/rls-services+xml", (Object)82);
        mimeTypes.put((Object)"application/rpki-ghostbusters", (Object)83);
        mimeTypes.put((Object)"application/rpki-manifest", (Object)84);
        mimeTypes.put((Object)"application/rpki-roa", (Object)85);
        mimeTypes.put((Object)"application/rsd+xml", (Object)86);
        mimeTypes.put((Object)"application/rss+xml", (Object)87);
        mimeTypes.put((Object)"application/rtf", (Object)88);
        mimeTypes.put((Object)"application/sbml+xml", (Object)89);
        mimeTypes.put((Object)"application/scvp-cv-request", (Object)90);
        mimeTypes.put((Object)"application/scvp-cv-response", (Object)91);
        mimeTypes.put((Object)"application/scvp-vp-request", (Object)92);
        mimeTypes.put((Object)"application/scvp-vp-response", (Object)93);
        mimeTypes.put((Object)"application/sdp", (Object)94);
        mimeTypes.put((Object)"application/set-payment-initiation", (Object)95);
        mimeTypes.put((Object)"application/set-registration-initiation", (Object)96);
        mimeTypes.put((Object)"application/shf+xml", (Object)97);
        mimeTypes.put((Object)"application/smil+xml", (Object)98);
        mimeTypes.put((Object)"application/sparql-query", (Object)99);
        mimeTypes.put((Object)"application/sparql-results+xml", (Object)100);
        mimeTypes.put((Object)"application/srgs", (Object)101);
        mimeTypes.put((Object)"application/srgs+xml", (Object)102);
        mimeTypes.put((Object)"application/sru+xml", (Object)103);
        mimeTypes.put((Object)"application/ssdl+xml", (Object)104);
        mimeTypes.put((Object)"application/ssml+xml", (Object)105);
        mimeTypes.put((Object)"application/tei+xml", (Object)106);
        mimeTypes.put((Object)"application/thraud+xml", (Object)107);
        mimeTypes.put((Object)"application/timestamped-data", (Object)108);
        mimeTypes.put((Object)"application/vnd.3gpp.pic-bw-large", (Object)109);
        mimeTypes.put((Object)"application/vnd.3gpp.pic-bw-small", (Object)110);
        mimeTypes.put((Object)"application/vnd.3gpp.pic-bw-var", (Object)111);
        mimeTypes.put((Object)"application/vnd.3gpp2.tcap", (Object)112);
        mimeTypes.put((Object)"application/vnd.3m.post-it-notes", (Object)113);
        mimeTypes.put((Object)"application/vnd.accpac.simply.aso", (Object)114);
        mimeTypes.put((Object)"application/vnd.accpac.simply.imp", (Object)115);
        mimeTypes.put((Object)"application/vnd.acucobol", (Object)116);
        mimeTypes.put((Object)"application/vnd.acucorp", (Object)117);
        mimeTypes.put((Object)"application/vnd.adobe.air-application-installer-package+zip", (Object)118);
        mimeTypes.put((Object)"application/vnd.adobe.formscentral.fcdt", (Object)119);
        mimeTypes.put((Object)"application/vnd.adobe.fxp", (Object)120);
        mimeTypes.put((Object)"application/vnd.adobe.xdp+xml", (Object)121);
        mimeTypes.put((Object)"application/vnd.adobe.xfdf", (Object)122);
        mimeTypes.put((Object)"application/vnd.ahead.space", (Object)123);
        mimeTypes.put((Object)"application/vnd.airzip.filesecure.azf", (Object)124);
        mimeTypes.put((Object)"application/vnd.airzip.filesecure.azs", (Object)125);
        mimeTypes.put((Object)"application/vnd.amazon.ebook", (Object)126);
        mimeTypes.put((Object)"application/vnd.americandynamics.acc", (Object)127);
        mimeTypes.put((Object)"application/vnd.amiga.ami", (Object)128);
        mimeTypes.put((Object)"application/vnd.android.package-archive", (Object)129);
        mimeTypes.put((Object)"application/vnd.anser-web-certificate-issue-initiation", (Object)130);
        mimeTypes.put((Object)"application/vnd.anser-web-funds-transfer-initiation", (Object)131);
        mimeTypes.put((Object)"application/vnd.antix.game-component", (Object)132);
        mimeTypes.put((Object)"application/vnd.apple.installer+xml", (Object)133);
        mimeTypes.put((Object)"application/vnd.apple.mpegurl", (Object)134);
        mimeTypes.put((Object)"application/vnd.aristanetworks.swi", (Object)135);
        mimeTypes.put((Object)"application/vnd.astraea-software.iota", (Object)136);
        mimeTypes.put((Object)"application/vnd.audiograph", (Object)137);
        mimeTypes.put((Object)"application/vnd.blueice.multipass", (Object)138);
        mimeTypes.put((Object)"application/vnd.bmi", (Object)139);
        mimeTypes.put((Object)"application/vnd.businessobjects", (Object)140);
        mimeTypes.put((Object)"application/vnd.chemdraw+xml", (Object)141);
        mimeTypes.put((Object)"application/vnd.chipnuts.karaoke-mmd", (Object)142);
        mimeTypes.put((Object)"application/vnd.cinderella", (Object)143);
        mimeTypes.put((Object)"application/vnd.claymore", (Object)144);
        mimeTypes.put((Object)"application/vnd.cloanto.rp9", (Object)145);
        mimeTypes.put((Object)"application/vnd.clonk.c4group", (Object)146);
        mimeTypes.put((Object)"application/vnd.cluetrust.cartomobile-config", (Object)147);
        mimeTypes.put((Object)"application/vnd.cluetrust.cartomobile-config-pkg", (Object)148);
        mimeTypes.put((Object)"application/vnd.commonspace", (Object)149);
        mimeTypes.put((Object)"application/vnd.contact.cmsg", (Object)150);
        mimeTypes.put((Object)"application/vnd.cosmocaller", (Object)151);
        mimeTypes.put((Object)"application/vnd.crick.clicker", (Object)152);
        mimeTypes.put((Object)"application/vnd.crick.clicker.keyboard", (Object)153);
        mimeTypes.put((Object)"application/vnd.crick.clicker.palette", (Object)154);
        mimeTypes.put((Object)"application/vnd.crick.clicker.template", (Object)155);
        mimeTypes.put((Object)"application/vnd.crick.clicker.wordbank", (Object)156);
        mimeTypes.put((Object)"application/vnd.criticaltools.wbs+xml", (Object)157);
        mimeTypes.put((Object)"application/vnd.ctc-posml", (Object)158);
        mimeTypes.put((Object)"application/vnd.cups-ppd", (Object)159);
        mimeTypes.put((Object)"application/vnd.curl.car", (Object)160);
        mimeTypes.put((Object)"application/vnd.curl.pcurl", (Object)161);
        mimeTypes.put((Object)"application/vnd.dart", (Object)162);
        mimeTypes.put((Object)"application/vnd.data-vision.rdz", (Object)163);
        mimeTypes.put((Object)"application/vnd.dece.data", (Object)164);
        mimeTypes.put((Object)"application/vnd.dece.ttml+xml", (Object)165);
        mimeTypes.put((Object)"application/vnd.dece.unspecified", (Object)166);
        mimeTypes.put((Object)"application/vnd.dece.zip", (Object)167);
        mimeTypes.put((Object)"application/vnd.denovo.fcselayout-link", (Object)168);
        mimeTypes.put((Object)"application/vnd.dna", (Object)169);
        mimeTypes.put((Object)"application/vnd.dolby.mlp", (Object)170);
        mimeTypes.put((Object)"application/vnd.dpgraph", (Object)171);
        mimeTypes.put((Object)"application/vnd.dreamfactory", (Object)172);
        mimeTypes.put((Object)"application/vnd.ds-keypoint", (Object)173);
        mimeTypes.put((Object)"application/vnd.dvb.ait", (Object)174);
        mimeTypes.put((Object)"application/vnd.dvb.service", (Object)175);
        mimeTypes.put((Object)"application/vnd.dynageo", (Object)176);
        mimeTypes.put((Object)"application/vnd.ecowin.chart", (Object)177);
        mimeTypes.put((Object)"application/vnd.enliven", (Object)178);
        mimeTypes.put((Object)"application/vnd.epson.esf", (Object)179);
        mimeTypes.put((Object)"application/vnd.epson.msf", (Object)180);
        mimeTypes.put((Object)"application/vnd.epson.quickanime", (Object)181);
        mimeTypes.put((Object)"application/vnd.epson.salt", (Object)182);
        mimeTypes.put((Object)"application/vnd.epson.ssf", (Object)183);
        mimeTypes.put((Object)"application/vnd.eszigno3+xml", (Object)184);
        mimeTypes.put((Object)"application/vnd.ezpix-album", (Object)185);
        mimeTypes.put((Object)"application/vnd.ezpix-package", (Object)186);
        mimeTypes.put((Object)"application/vnd.fdf", (Object)187);
        mimeTypes.put((Object)"application/vnd.fdsn.mseed", (Object)188);
        mimeTypes.put((Object)"application/vnd.fdsn.seed", (Object)189);
        mimeTypes.put((Object)"application/vnd.flographit", (Object)190);
        mimeTypes.put((Object)"application/vnd.fluxtime.clip", (Object)191);
        mimeTypes.put((Object)"application/vnd.framemaker", (Object)192);
        mimeTypes.put((Object)"application/vnd.frogans.fnc", (Object)193);
        mimeTypes.put((Object)"application/vnd.frogans.ltf", (Object)194);
        mimeTypes.put((Object)"application/vnd.fsc.weblaunch", (Object)195);
        mimeTypes.put((Object)"application/vnd.fujitsu.oasys", (Object)196);
        mimeTypes.put((Object)"application/vnd.fujitsu.oasys2", (Object)197);
        mimeTypes.put((Object)"application/vnd.fujitsu.oasys3", (Object)198);
        mimeTypes.put((Object)"application/vnd.fujitsu.oasysgp", (Object)199);
        mimeTypes.put((Object)"application/vnd.fujitsu.oasysprs", (Object)200);
        mimeTypes.put((Object)"application/vnd.fujixerox.ddd", (Object)201);
        mimeTypes.put((Object)"application/vnd.fujixerox.docuworks", (Object)202);
        mimeTypes.put((Object)"application/vnd.fujixerox.docuworks.binder", (Object)203);
        mimeTypes.put((Object)"application/vnd.fuzzysheet", (Object)204);
        mimeTypes.put((Object)"application/vnd.genomatix.tuxedo", (Object)205);
        mimeTypes.put((Object)"application/vnd.geogebra.file", (Object)206);
        mimeTypes.put((Object)"application/vnd.geogebra.tool", (Object)207);
        mimeTypes.put((Object)"application/vnd.geometry-explorer", (Object)208);
        mimeTypes.put((Object)"application/vnd.geonext", (Object)209);
        mimeTypes.put((Object)"application/vnd.geoplan", (Object)210);
        mimeTypes.put((Object)"application/vnd.geospace", (Object)211);
        mimeTypes.put((Object)"application/vnd.gmx", (Object)212);
        mimeTypes.put((Object)"application/vnd.google-earth.kml+xml", (Object)213);
        mimeTypes.put((Object)"application/vnd.google-earth.kmz", (Object)214);
        mimeTypes.put((Object)"application/vnd.grafeq", (Object)215);
        mimeTypes.put((Object)"application/vnd.groove-account", (Object)216);
        mimeTypes.put((Object)"application/vnd.groove-help", (Object)217);
        mimeTypes.put((Object)"application/vnd.groove-identity-message", (Object)218);
        mimeTypes.put((Object)"application/vnd.groove-injector", (Object)219);
        mimeTypes.put((Object)"application/vnd.groove-tool-message", (Object)220);
        mimeTypes.put((Object)"application/vnd.groove-tool-template", (Object)221);
        mimeTypes.put((Object)"application/vnd.groove-vcard", (Object)222);
        mimeTypes.put((Object)"application/vnd.hal+xml", (Object)223);
        mimeTypes.put((Object)"application/vnd.handheld-entertainment+xml", (Object)224);
        mimeTypes.put((Object)"application/vnd.hbci", (Object)225);
        mimeTypes.put((Object)"application/vnd.hhe.lesson-player", (Object)226);
        mimeTypes.put((Object)"application/vnd.hp-hpgl", (Object)227);
        mimeTypes.put((Object)"application/vnd.hp-hpid", (Object)228);
        mimeTypes.put((Object)"application/vnd.hp-hps", (Object)229);
        mimeTypes.put((Object)"application/vnd.hp-jlyt", (Object)230);
        mimeTypes.put((Object)"application/vnd.hp-pcl", (Object)231);
        mimeTypes.put((Object)"application/vnd.hp-pclxl", (Object)232);
        mimeTypes.put((Object)"application/vnd.hydrostatix.sof-data", (Object)233);
        mimeTypes.put((Object)"application/vnd.ibm.minipay", (Object)234);
        mimeTypes.put((Object)"application/vnd.ibm.modcap", (Object)235);
        mimeTypes.put((Object)"application/vnd.ibm.rights-management", (Object)236);
        mimeTypes.put((Object)"application/vnd.ibm.secure-container", (Object)237);
        mimeTypes.put((Object)"application/vnd.iccprofile", (Object)238);
        mimeTypes.put((Object)"application/vnd.igloader", (Object)239);
        mimeTypes.put((Object)"application/vnd.immervision-ivp", (Object)240);
        mimeTypes.put((Object)"application/vnd.immervision-ivu", (Object)241);
        mimeTypes.put((Object)"application/vnd.insors.igm", (Object)242);
        mimeTypes.put((Object)"application/vnd.intercon.formnet", (Object)243);
        mimeTypes.put((Object)"application/vnd.intergeo", (Object)244);
        mimeTypes.put((Object)"application/vnd.intu.qbo", (Object)245);
        mimeTypes.put((Object)"application/vnd.intu.qfx", (Object)246);
        mimeTypes.put((Object)"application/vnd.ipunplugged.rcprofile", (Object)247);
        mimeTypes.put((Object)"application/vnd.irepository.package+xml", (Object)248);
        mimeTypes.put((Object)"application/vnd.is-xpr", (Object)249);
        mimeTypes.put((Object)"application/vnd.isac.fcs", (Object)250);
        mimeTypes.put((Object)"application/vnd.jam", (Object)251);
        mimeTypes.put((Object)"application/vnd.jcp.javame.midlet-rms", (Object)252);
        mimeTypes.put((Object)"application/vnd.jisp", (Object)253);
        mimeTypes.put((Object)"application/vnd.joost.joda-archive", (Object)254);
        mimeTypes.put((Object)"application/vnd.kahootz", (Object)255);
        mimeTypes.put((Object)"application/vnd.kde.karbon", (Object)256);
        mimeTypes.put((Object)"application/vnd.kde.kchart", (Object)257);
        mimeTypes.put((Object)"application/vnd.kde.kformula", (Object)258);
        mimeTypes.put((Object)"application/vnd.kde.kivio", (Object)259);
        mimeTypes.put((Object)"application/vnd.kde.kontour", (Object)260);
        mimeTypes.put((Object)"application/vnd.kde.kpresenter", (Object)261);
        mimeTypes.put((Object)"application/vnd.kde.kspread", (Object)262);
        mimeTypes.put((Object)"application/vnd.kde.kword", (Object)263);
        mimeTypes.put((Object)"application/vnd.kenameaapp", (Object)264);
        mimeTypes.put((Object)"application/vnd.kidspiration", (Object)265);
        mimeTypes.put((Object)"application/vnd.kinar", (Object)266);
        mimeTypes.put((Object)"application/vnd.koan", (Object)267);
        mimeTypes.put((Object)"application/vnd.kodak-descriptor", (Object)268);
        mimeTypes.put((Object)"application/vnd.las.las+xml", (Object)269);
        mimeTypes.put((Object)"application/vnd.llamagraphics.life-balance.desktop", (Object)270);
        mimeTypes.put((Object)"application/vnd.llamagraphics.life-balance.exchange+xml", (Object)271);
        mimeTypes.put((Object)"application/vnd.lotus-1-2-3", (Object)272);
        mimeTypes.put((Object)"application/vnd.lotus-approach", (Object)273);
        mimeTypes.put((Object)"application/vnd.lotus-freelance", (Object)274);
        mimeTypes.put((Object)"application/vnd.lotus-notes", (Object)275);
        mimeTypes.put((Object)"application/vnd.lotus-organizer", (Object)276);
        mimeTypes.put((Object)"application/vnd.lotus-screencam", (Object)277);
        mimeTypes.put((Object)"application/vnd.lotus-wordpro", (Object)278);
        mimeTypes.put((Object)"application/vnd.macports.portpkg", (Object)279);
        mimeTypes.put((Object)"application/vnd.mcd", (Object)280);
        mimeTypes.put((Object)"application/vnd.medcalcdata", (Object)281);
        mimeTypes.put((Object)"application/vnd.mediastation.cdkey", (Object)282);
        mimeTypes.put((Object)"application/vnd.mfer", (Object)283);
        mimeTypes.put((Object)"application/vnd.mfmp", (Object)284);
        mimeTypes.put((Object)"application/vnd.micrografx.flo", (Object)285);
        mimeTypes.put((Object)"application/vnd.micrografx.igx", (Object)286);
        mimeTypes.put((Object)"application/vnd.mif", (Object)287);
        mimeTypes.put((Object)"application/vnd.mobius.daf", (Object)288);
        mimeTypes.put((Object)"application/vnd.mobius.dis", (Object)289);
        mimeTypes.put((Object)"application/vnd.mobius.mbk", (Object)290);
        mimeTypes.put((Object)"application/vnd.mobius.mqy", (Object)291);
        mimeTypes.put((Object)"application/vnd.mobius.msl", (Object)292);
        mimeTypes.put((Object)"application/vnd.mobius.plc", (Object)293);
        mimeTypes.put((Object)"application/vnd.mobius.txf", (Object)294);
        mimeTypes.put((Object)"application/vnd.mophun.application", (Object)295);
        mimeTypes.put((Object)"application/vnd.mophun.certificate", (Object)296);
        mimeTypes.put((Object)"application/vnd.mozilla.xul+xml", (Object)297);
        mimeTypes.put((Object)"application/vnd.ms-artgalry", (Object)298);
        mimeTypes.put((Object)"application/vnd.ms-cab-compressed", (Object)299);
        mimeTypes.put((Object)"application/vnd.ms-excel", (Object)300);
        mimeTypes.put((Object)"application/vnd.ms-excel.addin.macroenabled.12", (Object)301);
        mimeTypes.put((Object)"application/vnd.ms-excel.sheet.binary.macroenabled.12", (Object)302);
        mimeTypes.put((Object)"application/vnd.ms-excel.sheet.macroenabled.12", (Object)303);
        mimeTypes.put((Object)"application/vnd.ms-excel.template.macroenabled.12", (Object)304);
        mimeTypes.put((Object)"application/vnd.ms-fontobject", (Object)305);
        mimeTypes.put((Object)"application/vnd.ms-htmlhelp", (Object)306);
        mimeTypes.put((Object)"application/vnd.ms-ims", (Object)307);
        mimeTypes.put((Object)"application/vnd.ms-lrm", (Object)308);
        mimeTypes.put((Object)"application/vnd.ms-officetheme", (Object)309);
        mimeTypes.put((Object)"application/vnd.ms-pki.seccat", (Object)310);
        mimeTypes.put((Object)"application/vnd.ms-pki.stl", (Object)311);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint", (Object)312);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint.addin.macroenabled.12", (Object)313);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint.presentation.macroenabled.12", (Object)314);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint.slide.macroenabled.12", (Object)315);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint.slideshow.macroenabled.12", (Object)316);
        mimeTypes.put((Object)"application/vnd.ms-powerpoint.template.macroenabled.12", (Object)317);
        mimeTypes.put((Object)"application/vnd.ms-project", (Object)318);
        mimeTypes.put((Object)"application/vnd.ms-word.document.macroenabled.12", (Object)319);
        mimeTypes.put((Object)"application/vnd.ms-word.template.macroenabled.12", (Object)320);
        mimeTypes.put((Object)"application/vnd.ms-works", (Object)321);
        mimeTypes.put((Object)"application/vnd.ms-wpl", (Object)322);
        mimeTypes.put((Object)"application/vnd.ms-xpsdocument", (Object)323);
        mimeTypes.put((Object)"application/vnd.mseq", (Object)324);
        mimeTypes.put((Object)"application/vnd.musician", (Object)325);
        mimeTypes.put((Object)"application/vnd.muvee.style", (Object)326);
        mimeTypes.put((Object)"application/vnd.mynfc", (Object)327);
        mimeTypes.put((Object)"application/vnd.neurolanguage.nlu", (Object)328);
        mimeTypes.put((Object)"application/vnd.nitf", (Object)329);
        mimeTypes.put((Object)"application/vnd.noblenet-directory", (Object)330);
        mimeTypes.put((Object)"application/vnd.noblenet-sealer", (Object)331);
        mimeTypes.put((Object)"application/vnd.noblenet-web", (Object)332);
        mimeTypes.put((Object)"application/vnd.nokia.n-gage.data", (Object)333);
        mimeTypes.put((Object)"application/vnd.nokia.n-gage.symbian.install", (Object)334);
        mimeTypes.put((Object)"application/vnd.nokia.radio-preset", (Object)335);
        mimeTypes.put((Object)"application/vnd.nokia.radio-presets", (Object)336);
        mimeTypes.put((Object)"application/vnd.novadigm.edm", (Object)337);
        mimeTypes.put((Object)"application/vnd.novadigm.edx", (Object)338);
        mimeTypes.put((Object)"application/vnd.novadigm.ext", (Object)339);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.chart", (Object)340);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.chart-template", (Object)341);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.database", (Object)342);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.formula", (Object)343);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.formula-template", (Object)344);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.graphics", (Object)345);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.graphics-template", (Object)346);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.image", (Object)347);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.image-template", (Object)348);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.presentation", (Object)349);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.presentation-template", (Object)350);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.spreadsheet", (Object)351);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.spreadsheet-template", (Object)352);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.text", (Object)353);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.text-master", (Object)354);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.text-template", (Object)355);
        mimeTypes.put((Object)"application/vnd.oasis.opendocument.text-web", (Object)356);
        mimeTypes.put((Object)"application/vnd.olpc-sugar", (Object)357);
        mimeTypes.put((Object)"application/vnd.oma.dd2+xml", (Object)358);
        mimeTypes.put((Object)"application/vnd.openofficeorg.extension", (Object)359);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)360);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.slide", (Object)361);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.slideshow", (Object)362);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.template", (Object)363);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)364);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.template", (Object)365);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)366);
        mimeTypes.put((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.template", (Object)367);
        mimeTypes.put((Object)"application/vnd.osgeo.mapguide.package", (Object)368);
        mimeTypes.put((Object)"application/vnd.osgi.dp", (Object)369);
        mimeTypes.put((Object)"application/vnd.osgi.subsystem", (Object)370);
        mimeTypes.put((Object)"application/vnd.palm", (Object)371);
        mimeTypes.put((Object)"application/vnd.pawaafile", (Object)372);
        mimeTypes.put((Object)"application/vnd.pg.format", (Object)373);
        mimeTypes.put((Object)"application/vnd.pg.osasli", (Object)374);
        mimeTypes.put((Object)"application/vnd.picsel", (Object)375);
        mimeTypes.put((Object)"application/vnd.pmi.widget", (Object)376);
        mimeTypes.put((Object)"application/vnd.pocketlearn", (Object)377);
        mimeTypes.put((Object)"application/vnd.powerbuilder6", (Object)378);
        mimeTypes.put((Object)"application/vnd.previewsystems.box", (Object)379);
        mimeTypes.put((Object)"application/vnd.proteus.magazine", (Object)380);
        mimeTypes.put((Object)"application/vnd.publishare-delta-tree", (Object)381);
        mimeTypes.put((Object)"application/vnd.pvi.ptid1", (Object)382);
        mimeTypes.put((Object)"application/vnd.quark.quarkxpress", (Object)383);
        mimeTypes.put((Object)"application/vnd.realvnc.bed", (Object)384);
        mimeTypes.put((Object)"application/vnd.recordare.musicxml", (Object)385);
        mimeTypes.put((Object)"application/vnd.recordare.musicxml+xml", (Object)386);
        mimeTypes.put((Object)"application/vnd.rig.cryptonote", (Object)387);
        mimeTypes.put((Object)"application/vnd.rim.cod", (Object)388);
        mimeTypes.put((Object)"application/vnd.rn-realmedia", (Object)389);
        mimeTypes.put((Object)"application/vnd.rn-realmedia-vbr", (Object)390);
        mimeTypes.put((Object)"application/vnd.route66.link66+xml", (Object)391);
        mimeTypes.put((Object)"application/vnd.sailingtracker.track", (Object)392);
        mimeTypes.put((Object)"application/vnd.seemail", (Object)393);
        mimeTypes.put((Object)"application/vnd.sema", (Object)394);
        mimeTypes.put((Object)"application/vnd.semd", (Object)395);
        mimeTypes.put((Object)"application/vnd.semf", (Object)396);
        mimeTypes.put((Object)"application/vnd.shana.informed.formdata", (Object)397);
        mimeTypes.put((Object)"application/vnd.shana.informed.formtemplate", (Object)398);
        mimeTypes.put((Object)"application/vnd.shana.informed.interchange", (Object)399);
        mimeTypes.put((Object)"application/vnd.shana.informed.package", (Object)400);
        mimeTypes.put((Object)"application/vnd.simtech-mindmapper", (Object)401);
        mimeTypes.put((Object)"application/vnd.smaf", (Object)402);
        mimeTypes.put((Object)"application/vnd.smart.teacher", (Object)403);
        mimeTypes.put((Object)"application/vnd.solent.sdkm+xml", (Object)404);
        mimeTypes.put((Object)"application/vnd.spotfire.dxp", (Object)405);
        mimeTypes.put((Object)"application/vnd.spotfire.sfs", (Object)406);
        mimeTypes.put((Object)"application/vnd.stardivision.calc", (Object)407);
        mimeTypes.put((Object)"application/vnd.stardivision.draw", (Object)408);
        mimeTypes.put((Object)"application/vnd.stardivision.impress", (Object)409);
        mimeTypes.put((Object)"application/vnd.stardivision.math", (Object)410);
        mimeTypes.put((Object)"application/vnd.stardivision.writer", (Object)411);
        mimeTypes.put((Object)"application/vnd.stardivision.writer-global", (Object)412);
        mimeTypes.put((Object)"application/vnd.stepmania.package", (Object)413);
        mimeTypes.put((Object)"application/vnd.stepmania.stepchart", (Object)414);
        mimeTypes.put((Object)"application/vnd.sun.xml.calc", (Object)415);
        mimeTypes.put((Object)"application/vnd.sun.xml.calc.template", (Object)416);
        mimeTypes.put((Object)"application/vnd.sun.xml.draw", (Object)417);
        mimeTypes.put((Object)"application/vnd.sun.xml.draw.template", (Object)418);
        mimeTypes.put((Object)"application/vnd.sun.xml.impress", (Object)419);
        mimeTypes.put((Object)"application/vnd.sun.xml.impress.template", (Object)420);
        mimeTypes.put((Object)"application/vnd.sun.xml.math", (Object)421);
        mimeTypes.put((Object)"application/vnd.sun.xml.writer", (Object)422);
        mimeTypes.put((Object)"application/vnd.sun.xml.writer.global", (Object)423);
        mimeTypes.put((Object)"application/vnd.sun.xml.writer.template", (Object)424);
        mimeTypes.put((Object)"application/vnd.sus-calendar", (Object)425);
        mimeTypes.put((Object)"application/vnd.svd", (Object)426);
        mimeTypes.put((Object)"application/vnd.symbian.install", (Object)427);
        mimeTypes.put((Object)"application/vnd.syncml+xml", (Object)428);
        mimeTypes.put((Object)"application/vnd.syncml.dm+wbxml", (Object)429);
        mimeTypes.put((Object)"application/vnd.syncml.dm+xml", (Object)430);
        mimeTypes.put((Object)"application/vnd.tao.intent-module-archive", (Object)431);
        mimeTypes.put((Object)"application/vnd.tcpdump.pcap", (Object)432);
        mimeTypes.put((Object)"application/vnd.tmobile-livetv", (Object)433);
        mimeTypes.put((Object)"application/vnd.trid.tpt", (Object)434);
        mimeTypes.put((Object)"application/vnd.triscape.mxs", (Object)435);
        mimeTypes.put((Object)"application/vnd.trueapp", (Object)436);
        mimeTypes.put((Object)"application/vnd.ufdl", (Object)437);
        mimeTypes.put((Object)"application/vnd.uiq.theme", (Object)438);
        mimeTypes.put((Object)"application/vnd.umajin", (Object)439);
        mimeTypes.put((Object)"application/vnd.unity", (Object)440);
        mimeTypes.put((Object)"application/vnd.uoml+xml", (Object)441);
        mimeTypes.put((Object)"application/vnd.vcx", (Object)442);
        mimeTypes.put((Object)"application/vnd.visio", (Object)443);
        mimeTypes.put((Object)"application/vnd.visionary", (Object)444);
        mimeTypes.put((Object)"application/vnd.vsf", (Object)445);
        mimeTypes.put((Object)"application/vnd.wap.wbxml", (Object)446);
        mimeTypes.put((Object)"application/vnd.wap.wmlc", (Object)447);
        mimeTypes.put((Object)"application/vnd.wap.wmlscriptc", (Object)448);
        mimeTypes.put((Object)"application/vnd.webturbo", (Object)449);
        mimeTypes.put((Object)"application/vnd.wolfram.player", (Object)450);
        mimeTypes.put((Object)"application/vnd.wordperfect", (Object)451);
        mimeTypes.put((Object)"application/vnd.wqd", (Object)452);
        mimeTypes.put((Object)"application/vnd.wt.stf", (Object)453);
        mimeTypes.put((Object)"application/vnd.xara", (Object)454);
        mimeTypes.put((Object)"application/vnd.xfdl", (Object)455);
        mimeTypes.put((Object)"application/vnd.yamaha.hv-dic", (Object)456);
        mimeTypes.put((Object)"application/vnd.yamaha.hv-script", (Object)457);
        mimeTypes.put((Object)"application/vnd.yamaha.hv-voice", (Object)458);
        mimeTypes.put((Object)"application/vnd.yamaha.openscoreformat", (Object)459);
        mimeTypes.put((Object)"application/vnd.yamaha.openscoreformat.osfpvg+xml", (Object)460);
        mimeTypes.put((Object)"application/vnd.yamaha.smaf-audio", (Object)461);
        mimeTypes.put((Object)"application/vnd.yamaha.smaf-phrase", (Object)462);
        mimeTypes.put((Object)"application/vnd.yellowriver-custom-menu", (Object)463);
        mimeTypes.put((Object)"application/vnd.zul", (Object)464);
        mimeTypes.put((Object)"application/vnd.zzazz.deck+xml", (Object)465);
        mimeTypes.put((Object)"application/voicexml+xml", (Object)466);
        mimeTypes.put((Object)"application/widget", (Object)467);
        mimeTypes.put((Object)"application/winhlp", (Object)468);
        mimeTypes.put((Object)"application/wsdl+xml", (Object)469);
        mimeTypes.put((Object)"application/wspolicy+xml", (Object)470);
        mimeTypes.put((Object)"application/x-7z-compressed", (Object)471);
        mimeTypes.put((Object)"application/x-abiword", (Object)472);
        mimeTypes.put((Object)"application/x-ace-compressed", (Object)473);
        mimeTypes.put((Object)"application/x-apple-diskimage", (Object)474);
        mimeTypes.put((Object)"application/x-authorware-bin", (Object)475);
        mimeTypes.put((Object)"application/x-authorware-map", (Object)476);
        mimeTypes.put((Object)"application/x-authorware-seg", (Object)477);
        mimeTypes.put((Object)"application/x-bcpio", (Object)478);
        mimeTypes.put((Object)"application/x-bittorrent", (Object)479);
        mimeTypes.put((Object)"application/x-blorb", (Object)480);
        mimeTypes.put((Object)"application/x-bzip", (Object)481);
        mimeTypes.put((Object)"application/x-bzip2", (Object)482);
        mimeTypes.put((Object)"application/x-cbr", (Object)483);
        mimeTypes.put((Object)"application/x-cdlink", (Object)484);
        mimeTypes.put((Object)"application/x-cfs-compressed", (Object)485);
        mimeTypes.put((Object)"application/x-chat", (Object)486);
        mimeTypes.put((Object)"application/x-chess-pgn", (Object)487);
        mimeTypes.put((Object)"application/x-conference", (Object)488);
        mimeTypes.put((Object)"application/x-cpio", (Object)489);
        mimeTypes.put((Object)"application/x-csh", (Object)490);
        mimeTypes.put((Object)"application/x-debian-package", (Object)491);
        mimeTypes.put((Object)"application/x-dgc-compressed", (Object)492);
        mimeTypes.put((Object)"application/x-director", (Object)493);
        mimeTypes.put((Object)"application/x-doom", (Object)494);
        mimeTypes.put((Object)"application/x-dtbncx+xml", (Object)495);
        mimeTypes.put((Object)"application/x-dtbook+xml", (Object)496);
        mimeTypes.put((Object)"application/x-dtbresource+xml", (Object)497);
        mimeTypes.put((Object)"application/x-dvi", (Object)498);
        mimeTypes.put((Object)"application/x-envoy", (Object)499);
        mimeTypes.put((Object)"application/x-eva", (Object)500);
        mimeTypes.put((Object)"application/x-font-bdf", (Object)501);
        mimeTypes.put((Object)"application/x-font-ghostscript", (Object)502);
        mimeTypes.put((Object)"application/x-font-linux-psf", (Object)503);
        mimeTypes.put((Object)"application/x-font-otf", (Object)504);
        mimeTypes.put((Object)"application/x-font-pcf", (Object)505);
        mimeTypes.put((Object)"application/x-font-snf", (Object)506);
        mimeTypes.put((Object)"application/x-font-ttf", (Object)507);
        mimeTypes.put((Object)"application/x-font-type1", (Object)508);
        mimeTypes.put((Object)"application/x-font-woff", (Object)509);
        mimeTypes.put((Object)"application/x-freearc", (Object)510);
        mimeTypes.put((Object)"application/x-futuresplash", (Object)511);
        mimeTypes.put((Object)"application/x-gca-compressed", (Object)512);
        mimeTypes.put((Object)"application/x-glulx", (Object)513);
        mimeTypes.put((Object)"application/x-gnumeric", (Object)514);
        mimeTypes.put((Object)"application/x-gramps-xml", (Object)515);
        mimeTypes.put((Object)"application/x-gtar", (Object)516);
        mimeTypes.put((Object)"application/x-hdf", (Object)517);
        mimeTypes.put((Object)"application/x-install-instructions", (Object)518);
        mimeTypes.put((Object)"application/x-iso9660-image", (Object)519);
        mimeTypes.put((Object)"application/x-java-jnlp-file", (Object)520);
        mimeTypes.put((Object)"application/x-latex", (Object)521);
        mimeTypes.put((Object)"application/x-lzh-compressed", (Object)522);
        mimeTypes.put((Object)"application/x-mie", (Object)523);
        mimeTypes.put((Object)"application/x-mobipocket-ebook", (Object)524);
        mimeTypes.put((Object)"application/x-ms-application", (Object)525);
        mimeTypes.put((Object)"application/x-ms-shortcut", (Object)526);
        mimeTypes.put((Object)"application/x-ms-wmd", (Object)527);
        mimeTypes.put((Object)"application/x-ms-wmz", (Object)528);
        mimeTypes.put((Object)"application/x-ms-xbap", (Object)529);
        mimeTypes.put((Object)"application/x-msaccess", (Object)530);
        mimeTypes.put((Object)"application/x-msbinder", (Object)531);
        mimeTypes.put((Object)"application/x-mscardfile", (Object)532);
        mimeTypes.put((Object)"application/x-msclip", (Object)533);
        mimeTypes.put((Object)"application/x-msdownload", (Object)534);
        mimeTypes.put((Object)"application/x-msmediaview", (Object)535);
        mimeTypes.put((Object)"application/x-msmetafile", (Object)536);
        mimeTypes.put((Object)"application/x-msmoney", (Object)537);
        mimeTypes.put((Object)"application/x-mspublisher", (Object)538);
        mimeTypes.put((Object)"application/x-msschedule", (Object)539);
        mimeTypes.put((Object)"application/x-msterminal", (Object)540);
        mimeTypes.put((Object)"application/x-mswrite", (Object)541);
        mimeTypes.put((Object)"application/x-netcdf", (Object)542);
        mimeTypes.put((Object)"application/x-nzb", (Object)543);
        mimeTypes.put((Object)"application/x-pkcs12", (Object)544);
        mimeTypes.put((Object)"application/x-pkcs7-certificates", (Object)545);
        mimeTypes.put((Object)"application/x-pkcs7-certreqresp", (Object)546);
        mimeTypes.put((Object)"application/x-rar-compressed", (Object)547);
        mimeTypes.put((Object)"application/x-research-info-systems", (Object)548);
        mimeTypes.put((Object)"application/x-sh", (Object)549);
        mimeTypes.put((Object)"application/x-shar", (Object)550);
        mimeTypes.put((Object)"application/x-shockwave-flash", (Object)551);
        mimeTypes.put((Object)"application/x-silverlight-app", (Object)552);
        mimeTypes.put((Object)"application/x-sql", (Object)553);
        mimeTypes.put((Object)"application/x-stuffit", (Object)554);
        mimeTypes.put((Object)"application/x-stuffitx", (Object)555);
        mimeTypes.put((Object)"application/x-subrip", (Object)556);
        mimeTypes.put((Object)"application/x-sv4cpio", (Object)557);
        mimeTypes.put((Object)"application/x-sv4crc", (Object)558);
        mimeTypes.put((Object)"application/x-t3vm-image", (Object)559);
        mimeTypes.put((Object)"application/x-tads", (Object)560);
        mimeTypes.put((Object)"application/x-tar", (Object)561);
        mimeTypes.put((Object)"application/x-tcl", (Object)562);
        mimeTypes.put((Object)"application/x-tex", (Object)563);
        mimeTypes.put((Object)"application/x-tex-tfm", (Object)564);
        mimeTypes.put((Object)"application/x-texinfo", (Object)565);
        mimeTypes.put((Object)"application/x-tgif", (Object)566);
        mimeTypes.put((Object)"application/x-ustar", (Object)567);
        mimeTypes.put((Object)"application/x-wais-source", (Object)568);
        mimeTypes.put((Object)"application/x-x509-ca-cert", (Object)569);
        mimeTypes.put((Object)"application/x-xfig", (Object)570);
        mimeTypes.put((Object)"application/x-xliff+xml", (Object)571);
        mimeTypes.put((Object)"application/x-xpinstall", (Object)572);
        mimeTypes.put((Object)"application/x-xz", (Object)573);
        mimeTypes.put((Object)"application/x-zmachine", (Object)574);
        mimeTypes.put((Object)"application/xaml+xml", (Object)575);
        mimeTypes.put((Object)"application/xcap-diff+xml", (Object)576);
        mimeTypes.put((Object)"application/xenc+xml", (Object)577);
        mimeTypes.put((Object)"application/xhtml+xml", (Object)578);
        mimeTypes.put((Object)"application/xml", (Object)579);
        mimeTypes.put((Object)"application/xml-dtd", (Object)580);
        mimeTypes.put((Object)"application/xop+xml", (Object)581);
        mimeTypes.put((Object)"application/xproc+xml", (Object)582);
        mimeTypes.put((Object)"application/xslt+xml", (Object)583);
        mimeTypes.put((Object)"application/xspf+xml", (Object)584);
        mimeTypes.put((Object)"application/xv+xml", (Object)585);
        mimeTypes.put((Object)"application/yang", (Object)586);
        mimeTypes.put((Object)"application/yin+xml", (Object)587);
        mimeTypes.put((Object)"application/zip", (Object)588);
        mimeTypes.put((Object)"audio/adpcm", (Object)589);
        mimeTypes.put((Object)"audio/basic", (Object)590);
        mimeTypes.put((Object)"audio/midi", (Object)591);
        mimeTypes.put((Object)"audio/mp4", (Object)592);
        mimeTypes.put((Object)"audio/mpeg", (Object)593);
        mimeTypes.put((Object)"audio/ogg", (Object)594);
        mimeTypes.put((Object)"audio/s3m", (Object)595);
        mimeTypes.put((Object)"audio/silk", (Object)596);
        mimeTypes.put((Object)"audio/vnd.dece.audio", (Object)597);
        mimeTypes.put((Object)"audio/vnd.digital-winds", (Object)598);
        mimeTypes.put((Object)"audio/vnd.dra", (Object)599);
        mimeTypes.put((Object)"audio/vnd.dts", (Object)600);
        mimeTypes.put((Object)"audio/vnd.dts.hd", (Object)601);
        mimeTypes.put((Object)"audio/vnd.lucent.voice", (Object)602);
        mimeTypes.put((Object)"audio/vnd.ms-playready.media.pya", (Object)603);
        mimeTypes.put((Object)"audio/vnd.nuera.ecelp4800", (Object)604);
        mimeTypes.put((Object)"audio/vnd.nuera.ecelp7470", (Object)605);
        mimeTypes.put((Object)"audio/vnd.nuera.ecelp9600", (Object)606);
        mimeTypes.put((Object)"audio/vnd.rip", (Object)607);
        mimeTypes.put((Object)"audio/webm", (Object)608);
        mimeTypes.put((Object)"audio/x-aac", (Object)609);
        mimeTypes.put((Object)"audio/x-aiff", (Object)610);
        mimeTypes.put((Object)"audio/x-caf", (Object)611);
        mimeTypes.put((Object)"audio/x-flac", (Object)612);
        mimeTypes.put((Object)"audio/x-matroska", (Object)613);
        mimeTypes.put((Object)"audio/x-mpegurl", (Object)614);
        mimeTypes.put((Object)"audio/x-ms-wax", (Object)615);
        mimeTypes.put((Object)"audio/x-ms-wma", (Object)616);
        mimeTypes.put((Object)"audio/x-pn-realaudio", (Object)617);
        mimeTypes.put((Object)"audio/x-pn-realaudio-plugin", (Object)618);
        mimeTypes.put((Object)"audio/x-wav", (Object)619);
        mimeTypes.put((Object)"audio/xm", (Object)620);
        mimeTypes.put((Object)"chemical/x-cdx", (Object)621);
        mimeTypes.put((Object)"chemical/x-cif", (Object)622);
        mimeTypes.put((Object)"chemical/x-cmdf", (Object)623);
        mimeTypes.put((Object)"chemical/x-cml", (Object)624);
        mimeTypes.put((Object)"chemical/x-csml", (Object)625);
        mimeTypes.put((Object)"chemical/x-xyz", (Object)626);
        mimeTypes.put((Object)"image/bmp", (Object)627);
        mimeTypes.put((Object)"image/cgm", (Object)628);
        mimeTypes.put((Object)"image/g3fax", (Object)629);
        mimeTypes.put((Object)"image/gif", (Object)630);
        mimeTypes.put((Object)"image/ief", (Object)631);
        mimeTypes.put((Object)"image/jpeg", (Object)632);
        mimeTypes.put((Object)"image/ktx", (Object)633);
        mimeTypes.put((Object)"image/png", (Object)634);
        mimeTypes.put((Object)"image/prs.btif", (Object)635);
        mimeTypes.put((Object)"image/sgi", (Object)636);
        mimeTypes.put((Object)"image/svg+xml", (Object)637);
        mimeTypes.put((Object)"image/tiff", (Object)638);
        mimeTypes.put((Object)"image/vnd.adobe.photoshop", (Object)639);
        mimeTypes.put((Object)"image/vnd.dece.graphic", (Object)640);
        mimeTypes.put((Object)"image/vnd.dvb.subtitle", (Object)641);
        mimeTypes.put((Object)"image/vnd.djvu", (Object)642);
        mimeTypes.put((Object)"image/vnd.dwg", (Object)643);
        mimeTypes.put((Object)"image/vnd.dxf", (Object)644);
        mimeTypes.put((Object)"image/vnd.fastbidsheet", (Object)645);
        mimeTypes.put((Object)"image/vnd.fpx", (Object)646);
        mimeTypes.put((Object)"image/vnd.fst", (Object)647);
        mimeTypes.put((Object)"image/vnd.fujixerox.edmics-mmr", (Object)648);
        mimeTypes.put((Object)"image/vnd.fujixerox.edmics-rlc", (Object)649);
        mimeTypes.put((Object)"image/vnd.ms-modi", (Object)650);
        mimeTypes.put((Object)"image/vnd.ms-photo", (Object)651);
        mimeTypes.put((Object)"image/vnd.net-fpx", (Object)652);
        mimeTypes.put((Object)"image/vnd.wap.wbmp", (Object)653);
        mimeTypes.put((Object)"image/vnd.xiff", (Object)654);
        mimeTypes.put((Object)"image/webp", (Object)655);
        mimeTypes.put((Object)"image/x-3ds", (Object)656);
        mimeTypes.put((Object)"image/x-cmu-raster", (Object)657);
        mimeTypes.put((Object)"image/x-cmx", (Object)658);
        mimeTypes.put((Object)"image/x-freehand", (Object)659);
        mimeTypes.put((Object)"image/x-icon", (Object)660);
        mimeTypes.put((Object)"image/x-mrsid-image", (Object)661);
        mimeTypes.put((Object)"image/x-pcx", (Object)662);
        mimeTypes.put((Object)"image/x-pict", (Object)663);
        mimeTypes.put((Object)"image/x-portable-anymap", (Object)664);
        mimeTypes.put((Object)"image/x-portable-bitmap", (Object)665);
        mimeTypes.put((Object)"image/x-portable-graymap", (Object)666);
        mimeTypes.put((Object)"image/x-portable-pixmap", (Object)667);
        mimeTypes.put((Object)"image/x-rgb", (Object)668);
        mimeTypes.put((Object)"image/x-tga", (Object)669);
        mimeTypes.put((Object)"image/x-xbitmap", (Object)670);
        mimeTypes.put((Object)"image/x-xpixmap", (Object)671);
        mimeTypes.put((Object)"image/x-xwindowdump", (Object)672);
        mimeTypes.put((Object)"message/rfc822", (Object)673);
        mimeTypes.put((Object)"model/iges", (Object)674);
        mimeTypes.put((Object)"model/mesh", (Object)675);
        mimeTypes.put((Object)"model/vnd.collada+xml", (Object)676);
        mimeTypes.put((Object)"model/vnd.dwf", (Object)677);
        mimeTypes.put((Object)"model/vnd.gdl", (Object)678);
        mimeTypes.put((Object)"model/vnd.gtw", (Object)679);
        mimeTypes.put((Object)"model/vnd.mts", (Object)680);
        mimeTypes.put((Object)"model/vnd.vtu", (Object)681);
        mimeTypes.put((Object)"model/vrml", (Object)682);
        mimeTypes.put((Object)"model/x3d+binary", (Object)683);
        mimeTypes.put((Object)"model/x3d+vrml", (Object)684);
        mimeTypes.put((Object)"model/x3d+xml", (Object)685);
        mimeTypes.put((Object)"text/cache-manifest", (Object)686);
        mimeTypes.put((Object)"text/calendar", (Object)687);
        mimeTypes.put((Object)"text/css", (Object)688);
        mimeTypes.put((Object)"text/csv", (Object)689);
        mimeTypes.put((Object)"text/html", (Object)690);
        mimeTypes.put((Object)"text/n3", (Object)691);
        mimeTypes.put((Object)"text/plain", (Object)692);
        mimeTypes.put((Object)"text/prs.lines.tag", (Object)693);
        mimeTypes.put((Object)"text/richtext", (Object)694);
        mimeTypes.put((Object)"text/sgml", (Object)695);
        mimeTypes.put((Object)"text/tab-separated-values", (Object)696);
        mimeTypes.put((Object)"text/troff", (Object)697);
        mimeTypes.put((Object)"text/turtle", (Object)698);
        mimeTypes.put((Object)"text/uri-list", (Object)699);
        mimeTypes.put((Object)"text/vcard", (Object)700);
        mimeTypes.put((Object)"text/vnd.curl", (Object)701);
        mimeTypes.put((Object)"text/vnd.curl.dcurl", (Object)702);
        mimeTypes.put((Object)"text/vnd.curl.scurl", (Object)703);
        mimeTypes.put((Object)"text/vnd.curl.mcurl", (Object)704);
        mimeTypes.put((Object)"text/vnd.dvb.subtitle", (Object)705);
        mimeTypes.put((Object)"text/vnd.fly", (Object)706);
        mimeTypes.put((Object)"text/vnd.fmi.flexstor", (Object)707);
        mimeTypes.put((Object)"text/vnd.graphviz", (Object)708);
        mimeTypes.put((Object)"text/vnd.in3d.3dml", (Object)709);
        mimeTypes.put((Object)"text/vnd.in3d.spot", (Object)710);
        mimeTypes.put((Object)"text/vnd.sun.j2me.app-descriptor", (Object)711);
        mimeTypes.put((Object)"text/vnd.wap.wml", (Object)712);
        mimeTypes.put((Object)"text/vnd.wap.wmlscript", (Object)713);
        mimeTypes.put((Object)"text/x-asm", (Object)714);
        mimeTypes.put((Object)"text/x-c", (Object)715);
        mimeTypes.put((Object)"text/x-fortran", (Object)716);
        mimeTypes.put((Object)"text/x-java-source", (Object)717);
        mimeTypes.put((Object)"text/x-opml", (Object)718);
        mimeTypes.put((Object)"text/x-pascal", (Object)719);
        mimeTypes.put((Object)"text/x-nfo", (Object)720);
        mimeTypes.put((Object)"text/x-setext", (Object)721);
        mimeTypes.put((Object)"text/x-sfv", (Object)722);
        mimeTypes.put((Object)"text/x-uuencode", (Object)723);
        mimeTypes.put((Object)"text/x-vcalendar", (Object)724);
        mimeTypes.put((Object)"text/x-vcard", (Object)725);
        mimeTypes.put((Object)"video/3gpp", (Object)726);
        mimeTypes.put((Object)"video/3gpp2", (Object)727);
        mimeTypes.put((Object)"video/h261", (Object)728);
        mimeTypes.put((Object)"video/h263", (Object)729);
        mimeTypes.put((Object)"video/h264", (Object)730);
        mimeTypes.put((Object)"video/jpeg", (Object)731);
        mimeTypes.put((Object)"video/jpm", (Object)732);
        mimeTypes.put((Object)"video/mj2", (Object)733);
        mimeTypes.put((Object)"video/mp4", (Object)734);
        mimeTypes.put((Object)"video/mpeg", (Object)735);
        mimeTypes.put((Object)"video/ogg", (Object)736);
        mimeTypes.put((Object)"video/quicktime", (Object)737);
        mimeTypes.put((Object)"video/vnd.dece.hd", (Object)738);
        mimeTypes.put((Object)"video/vnd.dece.mobile", (Object)739);
        mimeTypes.put((Object)"video/vnd.dece.pd", (Object)740);
        mimeTypes.put((Object)"video/vnd.dece.sd", (Object)741);
        mimeTypes.put((Object)"video/vnd.dece.video", (Object)742);
        mimeTypes.put((Object)"video/vnd.dvb.file", (Object)743);
        mimeTypes.put((Object)"video/vnd.fvt", (Object)744);
        mimeTypes.put((Object)"video/vnd.mpegurl", (Object)745);
        mimeTypes.put((Object)"video/vnd.ms-playready.media.pyv", (Object)746);
        mimeTypes.put((Object)"video/vnd.uvvu.mp4", (Object)747);
        mimeTypes.put((Object)"video/vnd.vivo", (Object)748);
        mimeTypes.put((Object)"video/webm", (Object)749);
        mimeTypes.put((Object)"video/x-f4v", (Object)750);
        mimeTypes.put((Object)"video/x-fli", (Object)751);
        mimeTypes.put((Object)"video/x-flv", (Object)752);
        mimeTypes.put((Object)"video/x-m4v", (Object)753);
        mimeTypes.put((Object)"video/x-matroska", (Object)754);
        mimeTypes.put((Object)"video/x-mng", (Object)755);
        mimeTypes.put((Object)"video/x-ms-asf", (Object)756);
        mimeTypes.put((Object)"video/x-ms-vob", (Object)757);
        mimeTypes.put((Object)"video/x-ms-wm", (Object)758);
        mimeTypes.put((Object)"video/x-ms-wmv", (Object)759);
        mimeTypes.put((Object)"video/x-ms-wmx", (Object)760);
        mimeTypes.put((Object)"video/x-ms-wvx", (Object)761);
        mimeTypes.put((Object)"video/x-msvideo", (Object)762);
        mimeTypes.put((Object)"video/x-sgi-movie", (Object)763);
        mimeTypes.put((Object)"video/x-smv", (Object)764);
        mimeTypes.put((Object)"x-conference/x-cooltalk", (Object)765);
        mimeTypes.put((Object)"application/x-download", (Object)766);
        mimeTypes.put((Object)"image/pjpeg", (Object)767);
        mimeTypes.put((Object)"audio/flac", (Object)768);
        mimeTypes.put((Object)"pdf", (Object)769);
        mimeTypes.put((Object)"image", (Object)770);
        mimeTypes.put((Object)"image/pjpeg", (Object)771);
        mimeTypes.put((Object)"image/jpg", (Object)772);
        mimeTypes.put((Object)"audio/x-mpeg", (Object)773);
        mimeTypes.put((Object)"audio/mpeg3", (Object)774);
        mimeTypes.put((Object)"image/x-ms-bmp", (Object)775);
    }
}

