/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.model.facets.inverseLogic;

import eu.europeana.corelib.definitions.model.facets.inverseLogic.TagEncoding;
import eu.europeana.corelib.definitions.model.facets.logic.ImageTagExtractor;
import org.apache.commons.lang.StringUtils;

public class ImagePropertyExtractor {
    public static String getSize(int tag) {
        Integer sizeCode = TagEncoding.IMAGE_SIZE.extractValue(tag);
        switch (sizeCode) {
            case 1: {
                return "small";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "extra_large";
            }
        }
        return "";
    }

    public static String getColorSpace(int tag) {
        Integer colorSpaceCode = TagEncoding.IMAGE_COLOURSPACE.extractValue(tag);
        if (2 == colorSpaceCode) {
            return "false";
        }
        if (1 == colorSpaceCode || 3 == colorSpaceCode) {
            return "true";
        }
        return "";
    }

    public static String getAspectRatio(int tag) {
        Integer aspectRatioCode = TagEncoding.IMAGE_ASPECTRATIO.extractValue(tag);
        switch (aspectRatioCode) {
            case 1: {
                return "Landscape";
            }
            case 2: {
                return "Portrait";
            }
        }
        return "";
    }

    public static String getColor(int tag) {
        Integer colorCode = TagEncoding.IMAGE_COLOUR.extractValue(tag);
        return StringUtils.defaultIfEmpty((String)((String)ImageTagExtractor.hexColors.inverse().get((Object)colorCode)), (String)"");
    }
}

