/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr.model;

import eu.europeana.corelib.definitions.solr.SolrFacetType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FacetCollector {
    private static final String OR = " OR ";
    private boolean isTagged = true;
    private String name;
    private String tagName;
    private List<String> values = new ArrayList<String>();
    private List<String> replacedValues = new ArrayList<String>();
    private boolean isApiQuery = false;
    private boolean replaced = false;

    public FacetCollector(String name) {
        this.name = name;
        this.tagName = name;
    }

    public FacetCollector(String name, boolean isApiQuery) {
        this(name);
        this.isApiQuery = isApiQuery;
    }

    public boolean isTagged() {
        return this.isTagged;
    }

    public void setTagged(boolean isTagged) {
        this.isTagged = isTagged;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    private boolean isAlreadyQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    private boolean hasOr(String value) {
        return value.startsWith("(") && value.endsWith(")") && value.contains(OR);
    }

    public void addValue(String value, boolean isReplaced) {
        value = this.cleanIfValueContainsFieldName((String)value);
        if (this.name.equals(SolrFacetType.RIGHTS.name())) {
            if (((String)value).endsWith("*")) {
                value = ((String)value).replace(":", "\\:").replace("/", "\\/");
            } else if (!this.isAlreadyQuoted((String)value) && !this.hasOr((String)value)) {
                value = "\"" + (String)value + "\"";
            }
        } else if (this.name.equals(SolrFacetType.TYPE.name())) {
            value = ((String)value).toUpperCase().replace("\"", "");
        } else if (!this.isApiQuery && (((String)value).contains(" ") || ((String)value).contains("!"))) {
            if (!((String)value).startsWith("\"")) {
                value = "\"" + (String)value;
            }
            if (!((String)value).endsWith("\"")) {
                value = (String)value + "\"";
            }
        }
        if (isReplaced) {
            this.replacedValues.add((String)value);
        } else {
            this.values.add((String)value);
        }
    }

    private String cleanIfValueContainsFieldName(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)this.name)) {
            return StringUtils.replace((String)value, (String)(this.name + ":"), (String)"");
        }
        return value;
    }

    private String join(List<String> valueList, String booleanOperator) {
        if (valueList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (valueList.size() > 1) {
            sb.append("(");
            sb.append(StringUtils.join(valueList, (String)booleanOperator));
            sb.append(")");
        } else {
            sb.append(valueList.get(0));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTagged && !this.replaced) {
            sb.append("{!tag=").append(this.tagName).append("}");
        }
        sb.append(this.name);
        sb.append(":");
        String valuesString = this.join(this.values, OR);
        String replacedValuesString = this.join(this.replacedValues, OR);
        if (StringUtils.isNotBlank((CharSequence)valuesString)) {
            if (StringUtils.isNotBlank((CharSequence)replacedValuesString)) {
                sb.append(String.format("(%s AND %s)", valuesString, replacedValuesString));
            } else {
                sb.append(valuesString);
            }
        } else if (StringUtils.isNotBlank((CharSequence)replacedValuesString)) {
            sb.append(replacedValuesString);
        }
        return sb.toString();
    }
}

