/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr.model;

import eu.europeana.corelib.definitions.solr.model.RandomSeed;
import org.apache.commons.lang3.StringUtils;

public class QuerySort {
    public static final int ORDER_DESC = 0;
    public static final int ORDER_ASC = 1;
    public static final String SORT_RANDOM = "random";
    public static final char SORT_RANDOM_SEED_SEPARATOR = '_';
    private static final String SORT_ORDER_PATTERN = "(?i)(ascending|descending|asc|desc)";
    private static final String SORT_ORDER_DELIMETER_PATTERN = "(\\s|\\+)";
    private String sortField;
    private int sortOrder = 0;

    public QuerySort(String sortField, int sortOrder) {
        this.sortField = this.checkSortField(sortField);
        this.sortOrder = sortOrder;
    }

    public QuerySort(String sortField, String sortOrder) {
        this.sortField = this.checkSortField(sortField);
        if (QuerySort.isSortOrder(sortOrder)) {
            this.sortOrder = QuerySort.isAscending(sortOrder) ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Provided sort order isn't a proper sort order");
        }
    }

    public QuerySort(String sortField) {
        String field = this.checkSortField(sortField);
        if (field.matches(".*(\\s|\\+)(?i)(ascending|descending|asc|desc)$")) {
            int index = Math.max(field.lastIndexOf(43), field.lastIndexOf(32));
            this.sortField = field.substring(0, index).trim();
            this.sortOrder = QuerySort.isAscending(field.substring(index + 1, field.length())) ? 1 : 0;
        } else {
            this.sortField = field;
            this.sortOrder = 0;
        }
    }

    private String checkSortField(String sortField) {
        if (StringUtils.isBlank((CharSequence)sortField)) {
            throw new IllegalArgumentException("Sort field is null or empty");
        }
        Object result = sortField.trim();
        if (QuerySort.isRandomNoSeed((String)result)) {
            result = (String)result + "_" + RandomSeed.randomString(12);
        }
        return result;
    }

    public static boolean isSortOrder(String s) {
        return s != null && s.trim().matches("^(?i)(ascending|descending|asc|desc)$");
    }

    public static boolean isAscending(String sortOrder) {
        return sortOrder != null && sortOrder.trim().matches("(?i)(asc(ending)?)");
    }

    public static boolean isRandomNoSeed(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return SORT_RANDOM.equalsIgnoreCase(s.trim());
        }
        return false;
    }

    public String getSortField() {
        return this.sortField;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return this.sortField + (this.sortOrder == 1 ? " asc" : " desc");
    }
}

