/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import eu.europeana.corelib.utils.StringArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public enum DocType {
    TEXT("TEXT"),
    IMAGE("IMAGE"),
    SOUND("SOUND"),
    VIDEO("VIDEO"),
    _3D("3D");

    private String enumNameValue;

    private DocType(String enumNameValue) {
        this.enumNameValue = enumNameValue;
    }

    public static DocType safeValueOf(String[] strings) {
        if (StringArrayUtils.isNotBlank((String[])strings)) {
            return DocType.safeValueOf(strings[0]);
        }
        LogManager.getLogger(DocType.class).debug("Illegal type value (empty array)");
        return null;
    }

    @JsonCreator
    public static DocType safeValueOf(String enumNameValue) {
        if (StringUtils.isNotBlank((CharSequence)enumNameValue)) {
            for (DocType t : DocType.values()) {
                if (!t.getEnumNameValue().equalsIgnoreCase(enumNameValue)) continue;
                return t;
            }
        }
        LogManager.getLogger(DocType.class).debug("Illegal type value '{}'", (Object)enumNameValue);
        return null;
    }

    @JsonValue
    public String getEnumNameValue() {
        return this.enumNameValue;
    }

    public String toString() {
        return this.getEnumNameValue();
    }
}

