/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr.model;

import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import eu.europeana.corelib.definitions.solr.model.QueryFacet;
import eu.europeana.corelib.definitions.solr.model.QuerySort;
import eu.europeana.corelib.definitions.solr.model.QueryTranslation;
import eu.europeana.corelib.utils.EuropeanaStringUtils;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.utils.model.LanguageVersion;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public class Query
implements Cloneable {
    private String currentCursorMark;
    private static final String OR = " OR ";
    private static final int DEFAULT_START = 0;
    private static final int DEFAULT_PAGE_SIZE = 12;
    private boolean produceFacetUnion = true;
    private boolean spellcheckAllowed = true;
    private boolean allowFacets = true;
    private boolean apiQuery = false;
    private boolean defaultFacetsRequested = false;
    private boolean rangeFacetsRequested = false;
    private int start;
    private int pageSize;
    private String query;
    private String queryType;
    private String executedQuery;
    private int nrSelectors;
    private QueryTranslation queryTranslation;
    private Map<String, String> valueReplacementMap;
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private Map<String, Integer> technicalFacetOffsetMap = new HashMap<String, Integer>();
    private Map<String, Integer> technicalFacetLimitMap = new HashMap<String, Integer>();
    private String[] refinementArray;
    private static List<String> defaultSolrFacetList = new ArrayList<String>();
    private static List<String> defaultTechnicalFacetList;
    private List<String> solrFacetList = new ArrayList<String>();
    private List<String> technicalFacetList;
    private List<String> searchRefinementsList;
    private List<String> facetedRefinementsList;
    private List<String> facetsUsedInRefinementsList;
    private List<QueryFacet> queryFacetList;
    private List<QuerySort> sorts = new ArrayList<QuerySort>();

    public Query(String query) {
        this.query = query;
        this.start = 0;
        this.pageSize = 12;
    }

    public String getQuery() {
        return this.query;
    }

    public String getQuery(boolean withTranslations) {
        if (withTranslations && this.queryTranslation != null && StringUtils.isNotBlank((CharSequence)this.queryTranslation.getModifiedQuery())) {
            return this.queryTranslation.getModifiedQuery();
        }
        return this.query;
    }

    public Query setQuery(String query) {
        this.query = query;
        return this;
    }

    public String[] getRefinements() {
        return this.getRefinements(false);
    }

    public String[] getRefinements(boolean useDividedRefinements) {
        if (!useDividedRefinements) {
            return this.refinementArray;
        }
        this.divideRefinements();
        return (String[])ArrayUtils.addAll((Object[])this.searchRefinementsList.toArray(new String[this.searchRefinementsList.size()]), (Object[])this.facetedRefinementsList.toArray(new String[this.facetedRefinementsList.size()]));
    }

    public List<String> getFacetsUsedInRefinements() {
        return this.facetsUsedInRefinementsList;
    }

    public Query setRefinements(String ... refinementArray) {
        this.refinementArray = refinementArray != null ? (String[])refinementArray.clone() : StringArrayUtils.EMPTY_ARRAY;
        return this;
    }

    public String getCurrentCursorMark() {
        return this.currentCursorMark;
    }

    public Query setCurrentCursorMark(String currentCursorMark) {
        this.currentCursorMark = currentCursorMark;
        return this;
    }

    public Query addRefinement(String refinement) {
        if (this.refinementArray == null) {
            this.refinementArray = StringArrayUtils.EMPTY_ARRAY;
        }
        this.refinementArray = (String[])ArrayUtils.add((Object[])this.refinementArray, (Object)refinement);
        return this;
    }

    public Query setValueReplacements(Map<String, String> valueReplacementMap) {
        this.valueReplacementMap = valueReplacementMap;
        return this;
    }

    public Query setQueryTranslation(QueryTranslation queryTranslation) {
        this.queryTranslation = queryTranslation;
        return this;
    }

    public QueryTranslation getQueryTranslation() {
        return this.queryTranslation;
    }

    public Query addFacetQuery(QueryFacet queryFacet) {
        if (this.queryFacetList == null) {
            this.queryFacetList = new ArrayList<QueryFacet>();
        }
        this.queryFacetList.add(queryFacet);
        return this;
    }

    public Query setQueryFacets(List<QueryFacet> queryFacets) {
        this.queryFacetList = queryFacets;
        return this;
    }

    public List<String> getQueryFacets() {
        ArrayList<String> queries = new ArrayList<String>();
        if (this.queryFacetList != null) {
            for (QueryFacet queryFacet : this.queryFacetList) {
                queries.add(queryFacet.getQueryFacetString());
            }
        }
        return queries;
    }

    public Integer getStart() {
        return this.start;
    }

    public Query setStart(int start) {
        this.start = start;
        return this;
    }

    public List<QuerySort> getSorts() {
        return this.sorts;
    }

    public Query setSort(String sort) {
        this.sorts.clear();
        if (!StringUtils.isEmpty((CharSequence)sort)) {
            String toSplit = sort.trim();
            ArrayList<String> sortFields = new ArrayList<String>();
            while (toSplit.length() > 0) {
                String currentField;
                int endIndex;
                if (toSplit.toLowerCase(Locale.GERMAN).startsWith("field(")) {
                    endIndex = toSplit.indexOf(41);
                    currentField = toSplit.substring(0, endIndex + 1);
                } else {
                    endIndex = this.indexOfFirstCommaPlusOrSpace(toSplit);
                    currentField = toSplit.substring(0, endIndex);
                }
                if (StringUtils.isNotEmpty((CharSequence)currentField)) {
                    sortFields.add(currentField);
                }
                if (endIndex == toSplit.length()) break;
                toSplit = toSplit.substring(endIndex + 1, toSplit.length()).trim();
            }
            this.combineSortAndOrder(sortFields);
        }
        return this;
    }

    private int indexOfFirstCommaPlusOrSpace(String s) {
        int index3;
        int index2;
        int index1 = s.indexOf(44);
        if (index1 == -1) {
            index1 = s.length();
        }
        if ((index2 = s.indexOf(32)) == -1) {
            index2 = s.length();
        }
        if ((index3 = s.indexOf(43)) == -1) {
            index3 = s.length();
        }
        return Math.min(Math.min(index1, index2), index3);
    }

    private void combineSortAndOrder(List<String> sortFields) {
        for (int i = 0; i < sortFields.size(); ++i) {
            String sortField = sortFields.get(i);
            if (StringUtils.isEmpty((CharSequence)sortField.trim())) continue;
            if (i < sortFields.size() - 1) {
                String nextSortField = sortFields.get(i + 1);
                if (QuerySort.isSortOrder(nextSortField)) {
                    this.sorts.add(new QuerySort(sortField, nextSortField));
                    ++i;
                    continue;
                }
                this.sorts.add(new QuerySort(sortField));
                continue;
            }
            this.sorts.add(new QuerySort(sortField));
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Query setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public List<String> getSolrFacets() {
        return this.solrFacetList;
    }

    public Query setDefaultSolrFacets() {
        this.solrFacetList = new ArrayList<String>(defaultSolrFacetList);
        return this;
    }

    public Query setSolrFacets(String ... solrFacets) {
        if (ArrayUtils.isNotEmpty((Object[])solrFacets)) {
            this.setSolrFacets(Arrays.asList(solrFacets));
        }
        return this;
    }

    public Query setSolrFacets(List<String> solrFacets) {
        if (solrFacets != null) {
            return this.replaceSpecialSolrFacets(solrFacets);
        }
        return this;
    }

    public Query addSolrFacets(List<String> solrFacets) {
        if (solrFacets != null) {
            ArrayList<String> oldSolrFacetList = new ArrayList<String>(this.solrFacetList);
            this.replaceSpecialSolrFacets(solrFacets);
            for (String oldSolrFacet : oldSolrFacetList) {
                if (this.solrFacetList.contains(oldSolrFacet)) continue;
                this.solrFacetList.add(oldSolrFacet);
            }
        }
        return this;
    }

    public void removeSolrFacet(SolrFacetType facetToRemove) {
        this.removeSolrFacet(facetToRemove.toString());
    }

    public void removeSolrFacet(String facetToRemove) {
        if (this.solrFacetList.contains(facetToRemove)) {
            this.solrFacetList.remove(facetToRemove);
        }
    }

    public void setSolrFacet(String facet) {
        this.solrFacetList.add(facet);
    }

    public Query setDefaultTechnicalFacets() {
        this.technicalFacetList = new ArrayList<String>(defaultTechnicalFacetList);
        return this;
    }

    public Query setTechnicalFacets(String ... technicalFacets) {
        if (technicalFacets != null) {
            return this.setTechnicalFacets(Arrays.asList(technicalFacets));
        }
        return this;
    }

    public Query setTechnicalFacets(List<String> technicalFacets) {
        this.technicalFacetList = new ArrayList<String>();
        for (String technicalFacet : technicalFacets) {
            if (!defaultTechnicalFacetList.contains(technicalFacet)) continue;
            this.technicalFacetList.add(technicalFacet);
        }
        return this;
    }

    public List<String> getTechnicalFacets() {
        return this.technicalFacetList;
    }

    public boolean areFacetsAllowed() {
        return this.allowFacets;
    }

    public Query setFacetsAllowed(boolean allowFacets) {
        this.allowFacets = allowFacets;
        if (this.allowFacets && this.technicalFacetList != null && this.technicalFacetList.size() > 0 && (this.solrFacetList.size() == 0 || !this.solrFacetList.contains(SolrFacetType.FACET_TAGS.toString()))) {
            this.solrFacetList.add(SolrFacetType.FACET_TAGS.toString());
        }
        return this;
    }

    public Query setProduceFacetUnion(boolean produceFacetUnion) {
        this.produceFacetUnion = produceFacetUnion;
        return this;
    }

    private Query replaceSpecialSolrFacets(List<String> solrFacetList) {
        HashSet<String> replacedFacetSet = new HashSet<String>();
        for (String solrFacet : solrFacetList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"MEDIA", (CharSequence)solrFacet)) {
                replacedFacetSet.add("has_media");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"THUMBNAIL", (CharSequence)solrFacet)) {
                replacedFacetSet.add("has_thumbnails");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"TEXT_FULLTEXT", (CharSequence)solrFacet)) {
                replacedFacetSet.add("is_fulltext");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"REUSABILITY", (CharSequence)solrFacet)) continue;
            replacedFacetSet.add(solrFacet);
        }
        this.solrFacetList = new ArrayList<String>(replacedFacetSet);
        return this;
    }

    public boolean isDefaultFacetsRequested() {
        return this.defaultFacetsRequested;
    }

    public Query setDefaultFacetsRequested(boolean defaultFacetsRequested) {
        this.defaultFacetsRequested = defaultFacetsRequested;
        return this;
    }

    private void generateFacetTagQuery(int ... tags) {
        if (null == tags || 0 == tags.length) {
            return;
        }
        for (int tag : tags) {
            this.addFacetQuery(new QueryFacet("facet_tags:" + tag, "facet_tags"));
        }
    }

    public boolean isApiQuery() {
        return this.apiQuery;
    }

    public Query setApiQuery(boolean apiQuery) {
        this.apiQuery = apiQuery;
        return this;
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public boolean hasParameter(String key) {
        return this.parameterMap.containsKey(key);
    }

    public boolean areRangeFacetsRequested() {
        return this.rangeFacetsRequested;
    }

    public Query setParameter(String key, String value) {
        this.parameterMap.put(key, value);
        return this;
    }

    public Query setFacetDateRangeParameters(Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            this.rangeFacetsRequested = true;
            this.parameterMap.putAll(parameters);
        }
        return this;
    }

    public void setNrSelectors(String key, int value) {
        this.nrSelectors = value;
        this.setParameter(key, Integer.toString(value));
    }

    public int getNrSelectors() {
        return this.nrSelectors;
    }

    public Query convertAndSetSolrParameters(Map<String, Integer> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.parameterMap.putAll(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()))));
        }
        return this;
    }

    public Query setTechnicalFacetOffsets(Map<String, Integer> technicalFacetOffsetMap) {
        if (technicalFacetOffsetMap != null && !technicalFacetOffsetMap.isEmpty()) {
            this.technicalFacetOffsetMap = technicalFacetOffsetMap;
        }
        return this;
    }

    public Map<String, Integer> getTechnicalFacetOffsets() {
        return this.technicalFacetOffsetMap;
    }

    public Query setTechnicalFacetLimits(Map<String, Integer> technicalFacetLimitMap) {
        if (technicalFacetLimitMap != null && !technicalFacetLimitMap.isEmpty()) {
            this.technicalFacetLimitMap = technicalFacetLimitMap;
        }
        return this;
    }

    public Map<String, Integer> getTechnicalFacetLimits() {
        return this.technicalFacetLimitMap;
    }

    public Query clone() throws CloneNotSupportedException {
        return (Query)super.clone();
    }

    public String toString() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("q=" + this.query);
        params.add("start=" + this.start);
        params.add("rows=" + this.pageSize);
        if (this.sorts.size() > 0) {
            StringBuilder sortsText = new StringBuilder();
            for (QuerySort sort : this.sorts) {
                if (sortsText.length() > 0) {
                    sortsText.append(',');
                }
                sortsText.append(sort.toString());
            }
            sortsText.insert(0, "sorts=");
            params.add(sortsText.toString());
        }
        if (this.refinementArray != null) {
            for (String refinement : this.refinementArray) {
                params.add("qf=" + (String)refinement);
            }
        }
        if (this.solrFacetList != null) {
            for (String string : this.solrFacetList) {
                params.add("facet.field=" + string);
            }
        }
        if (this.parameterMap != null) {
            for (Map.Entry entry : this.parameterMap.entrySet()) {
                params.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (this.getQueryFacets() != null) {
            for (String string : this.getQueryFacets()) {
                params.add("facet.query=" + string);
            }
        }
        return StringUtils.join(params, (String)"&");
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public boolean doProduceFacetUnion() {
        return this.produceFacetUnion;
    }

    public boolean isSpellcheckAllowed() {
        return this.spellcheckAllowed;
    }

    public Query setSpellcheckAllowed(boolean allowSpellcheck) {
        this.spellcheckAllowed = allowSpellcheck;
        return this;
    }

    public String getExecutedQuery() {
        return this.executedQuery;
    }

    public void setExecutedQuery(String executedQuery) {
        try {
            this.executedQuery = URLDecoder.decode(executedQuery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.executedQuery = executedQuery;
            LogManager.getLogger(Query.class).error(e.getMessage());
        }
    }

    public void divideRefinements() {
        this.searchRefinementsList = new ArrayList<String>();
        this.facetedRefinementsList = new ArrayList<String>();
        if (null == this.refinementArray || this.refinementArray.length == 0) {
            return;
        }
        LinkedHashMap<String, FacetCollector> register = new LinkedHashMap<String, FacetCollector>();
        for (String facetTerm : this.refinementArray) {
            if (facetTerm.contains(":")) {
                boolean replaced = false;
                String pseudoFacetName = null;
                if (this.valueReplacementMap != null && this.valueReplacementMap.containsKey(facetTerm)) {
                    pseudoFacetName = StringUtils.substringBefore((String)facetTerm, (String)":");
                    facetTerm = this.valueReplacementMap.get(facetTerm);
                    replaced = true;
                    if (StringUtils.isBlank((CharSequence)facetTerm)) continue;
                }
                String facetName = StringUtils.substringBefore((String)facetTerm, (String)":");
                boolean isTagged = false;
                if (facetName.contains("!tag")) {
                    facetName = facetName.replaceFirst("\\{!tag=.*?\\}", "");
                    isTagged = true;
                }
                if (!defaultTechnicalFacetList.contains(facetName)) {
                    FacetCollector collector;
                    String key;
                    String string = key = pseudoFacetName == null ? facetName : pseudoFacetName;
                    if (register.containsKey(key)) {
                        collector = (FacetCollector)register.get(key);
                    } else {
                        collector = new FacetCollector(facetName, this.isApiQuery());
                        if (pseudoFacetName != null) {
                            collector.setTagName(pseudoFacetName);
                        }
                        register.put(key, collector);
                    }
                    if (isTagged && !collector.isTagged()) {
                        collector.setTagged(true);
                    }
                    collector.addValue(StringUtils.substringAfter((String)facetTerm, (String)":"), replaced);
                    continue;
                }
                this.searchRefinementsList.add(facetTerm);
                continue;
            }
            this.searchRefinementsList.add(facetTerm);
        }
        this.facetsUsedInRefinementsList = new ArrayList(register.keySet());
        for (FacetCollector collector : register.values()) {
            this.facetedRefinementsList.add(collector.toString());
        }
    }

    public static String concatenateQueryTranslations(List<LanguageVersion> languageVersions) {
        ArrayList<String> queryTranslationTerms = new ArrayList<String>();
        for (LanguageVersion term : languageVersions) {
            String phrase = EuropeanaStringUtils.createPhraseValue((String)term.getText());
            if (queryTranslationTerms.contains(phrase)) continue;
            queryTranslationTerms.add(phrase);
        }
        return StringUtils.join(queryTranslationTerms, (String)OR);
    }

    static {
        for (SolrFacetType solrFacetType : SolrFacetType.values()) {
            defaultSolrFacetList.add(solrFacetType.toString());
        }
        defaultTechnicalFacetList = new ArrayList<String>();
        for (Enum enum_ : TechnicalFacetType.values()) {
            defaultTechnicalFacetList.add(enum_.toString());
        }
    }

    private class FacetCollector {
        private boolean isTagged = true;
        private String name;
        private String tagName;
        private List<String> values = new ArrayList<String>();
        private List<String> replacedValues = new ArrayList<String>();
        private boolean isApiQuery = false;
        private boolean replaced = false;

        public FacetCollector(String name) {
            this.name = name;
            this.tagName = name;
        }

        public FacetCollector(String name, boolean isApiQuery) {
            this(name);
            this.isApiQuery = isApiQuery;
        }

        public boolean isTagged() {
            return this.isTagged;
        }

        public void setTagged(boolean isTagged) {
            this.isTagged = isTagged;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        private boolean isAlreadyQuoted(String value) {
            return value.startsWith("\"") && value.endsWith("\"");
        }

        private boolean hasOr(String value) {
            return value.startsWith("(") && value.endsWith(")") && value.contains(Query.OR);
        }

        public void addValue(String value, boolean isReplaced) {
            if (this.name.equals(SolrFacetType.RIGHTS.name())) {
                if (value.endsWith("*")) {
                    value = value.replace(":", "\\:").replace("/", "\\/");
                } else if (!this.isAlreadyQuoted(value) && !this.hasOr(value)) {
                    value = '\"' + value + '\"';
                }
            } else if (this.name.equals(SolrFacetType.TYPE.name())) {
                value = value.toUpperCase().replace("\"", "");
            } else if (!this.isApiQuery && (value.contains(" ") || value.contains("!"))) {
                if (!value.startsWith("\"")) {
                    value = '\"' + value;
                }
                if (!value.endsWith("\"")) {
                    value = value + '\"';
                }
            }
            if (isReplaced) {
                this.replacedValues.add(value);
            } else {
                this.values.add(value);
            }
        }

        private String join(List<String> valueList, String booleanOperator) {
            if (valueList.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (valueList.size() > 1) {
                sb.append("(");
                sb.append(StringUtils.join(valueList, (String)booleanOperator));
                sb.append(")");
            } else {
                sb.append(valueList.get(0));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isTagged && !this.replaced) {
                sb.append("{!tag=").append(this.tagName).append("}");
            }
            sb.append(this.name);
            sb.append(":");
            String valuesString = this.join(this.values, Query.OR);
            String replacedValuesString = this.join(this.replacedValues, Query.OR);
            if (StringUtils.isNotBlank((CharSequence)valuesString)) {
                if (StringUtils.isNotBlank((CharSequence)replacedValuesString)) {
                    sb.append(String.format("(%s AND %s)", valuesString, replacedValuesString));
                } else {
                    sb.append(valuesString);
                }
            } else if (StringUtils.isNotBlank((CharSequence)replacedValuesString)) {
                sb.append(replacedValuesString);
            }
            return sb.toString();
        }
    }
}

