/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import eu.europeana.corelib.utils.StringArrayUtils;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public enum DocType {
    TEXT("TEXT", "doc", "pdf"),
    IMAGE("IMAGE", "jpeg", "jpg", "png", "tif"),
    SOUND("SOUND", "mp3"),
    VIDEO("VIDEO", "avi", "mpg"),
    _3D("3D", new String[0]);

    private String enumNameValue;
    private String[] extentions;

    private DocType(String enumNameValue, String ... extentions) {
        this.enumNameValue = enumNameValue;
        this.extentions = extentions;
    }

    public static DocType safeValueOf(String[] strings) {
        if (StringArrayUtils.isNotBlank((String[])strings)) {
            return DocType.safeValueOf(strings[0]);
        }
        LogManager.getLogger(DocType.class).debug("Illegal type value (empty array)");
        return null;
    }

    @JsonCreator
    public static DocType safeValueOf(String enumNameValue) {
        if (StringUtils.isNotBlank((CharSequence)enumNameValue)) {
            for (DocType t : DocType.values()) {
                if (!t.getEnumNameValue().equalsIgnoreCase(enumNameValue)) continue;
                return t;
            }
        }
        LogManager.getLogger(DocType.class).debug("Illegal type value '{}'", (Object)enumNameValue);
        return null;
    }

    public static DocType getByExtention(String ext) {
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            for (DocType t : DocType.values()) {
                if (!StringArrayUtils.isNotBlank((String[])t.extentions)) continue;
                for (String e : t.extentions) {
                    if (!StringUtils.endsWithIgnoreCase((CharSequence)ext, (CharSequence)(e = StringArrayUtils.concat((String[])new String[]{".", e})))) continue;
                    return t;
                }
            }
        }
        return null;
    }

    @JsonValue
    public String getEnumNameValue() {
        return this.enumNameValue;
    }

    public String toString() {
        return this.getEnumNameValue();
    }

    public static class DocTypeConverter
    extends TypeConverter
    implements SimpleValueConverter {
        public DocTypeConverter() {
            super(new Class[]{DocType.class});
        }

        public DocType decode(Class<?> targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
            return Optional.ofNullable(fromDBObject).map(object -> (String)object).map(DocType::safeValueOf).orElse(null);
        }

        public String encode(Object value, MappedField optionalExtraInfo) {
            return Optional.ofNullable(value).map(object -> (DocType)((Object)((Object)object))).map(DocType::getEnumNameValue).orElse(null);
        }
    }
}

