/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr.model;

import eu.europeana.corelib.definitions.solr.Facet;
import eu.europeana.corelib.definitions.solr.model.QueryFacet;
import eu.europeana.corelib.definitions.solr.model.QueryTranslation;
import eu.europeana.corelib.utils.EuropeanaStringUtils;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.utils.model.LanguageVersion;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class Query
implements Cloneable {
    private static final String OR = " OR ";
    private static final int DEFAULT_START = 0;
    private static final int DEFAULT_PAGE_SIZE = 12;
    private String query;
    private String[] refinements;
    private QueryTranslation queryTranslation;
    private Map<String, String> valueReplacements;
    private int start;
    private int pageSize;
    private static List<String> defaultFacets = new ArrayList<String>();
    private List<String> facets = new ArrayList<String>(defaultFacets);
    private List<String> allFacetList;
    private Map<String, String> parameters = new HashMap<String, String>();
    private String queryType;
    private String executedQuery;
    private List<String> searchRefinements;
    private List<String> facetRefinements;
    private List<String> filteredFacets;
    private List<QueryFacet> facetQueries;
    private boolean produceFacetUnion = true;
    private boolean allowSpellcheck = true;
    private boolean allowFacets = true;
    private boolean apiQuery = false;

    public Query(String query) {
        this.query = query;
        this.start = 0;
        this.pageSize = 12;
        this.createAllFacetList();
    }

    public String getQuery() {
        return this.query;
    }

    public String getQuery(boolean withTranslations) {
        if (withTranslations && this.queryTranslation != null && StringUtils.isNotBlank((String)this.queryTranslation.getModifiedQuery())) {
            return this.queryTranslation.getModifiedQuery();
        }
        return this.query;
    }

    public Query setQuery(String query) {
        this.query = query;
        return this;
    }

    public String[] getRefinements() {
        return this.getRefinements(false);
    }

    public String[] getRefinements(boolean useDividedRefinements) {
        if (!useDividedRefinements) {
            return this.refinements;
        }
        this.divideRefinements();
        return (String[])ArrayUtils.addAll((Object[])this.searchRefinements.toArray(new String[this.searchRefinements.size()]), (Object[])this.facetRefinements.toArray(new String[this.facetRefinements.size()]));
    }

    public List<String> getFilteredFacets() {
        return this.filteredFacets;
    }

    public Query setRefinements(String ... refinements) {
        this.refinements = refinements != null ? (String[])refinements.clone() : StringArrayUtils.EMPTY_ARRAY;
        return this;
    }

    public Query addRefinement(String refinement) {
        if (this.refinements == null) {
            this.refinements = StringArrayUtils.EMPTY_ARRAY;
        }
        this.refinements = (String[])ArrayUtils.add((Object[])this.refinements, (Object)refinement);
        return this;
    }

    public Query setValueReplacements(Map<String, String> valueReplacements) {
        this.valueReplacements = valueReplacements;
        return this;
    }

    public Query setQueryTranslation(QueryTranslation queryTranslation) {
        this.queryTranslation = queryTranslation;
        return this;
    }

    public QueryTranslation getQueryTranslation() {
        return this.queryTranslation;
    }

    public Query addFacetQuery(QueryFacet queryFacet) {
        if (this.facetQueries == null) {
            this.facetQueries = new ArrayList<QueryFacet>();
        }
        this.facetQueries.add(queryFacet);
        return this;
    }

    public Query setFacetQueries(List<QueryFacet> queryFacets) {
        this.facetQueries = queryFacets;
        return this;
    }

    public List<String> getFacetQueries() {
        ArrayList<String> queries = new ArrayList<String>();
        if (this.facetQueries != null) {
            for (QueryFacet queryFacet : this.facetQueries) {
                queries.add(queryFacet.getQueryFacetString());
            }
        }
        return queries;
    }

    public Integer getStart() {
        return this.start;
    }

    public Query setStart(int start) {
        this.start = start;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Query setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    public Query setFacets(String ... facets) {
        if (facets != null) {
            this.facets = Arrays.asList(facets);
            this.replaceSpecialFacets();
        } else {
            this.facets = defaultFacets;
        }
        return this;
    }

    public Query setFacets(List<String> facets) {
        if (facets != null) {
            this.facets = facets;
            this.replaceSpecialFacets();
        } else {
            this.facets = defaultFacets;
        }
        return this;
    }

    private void replaceSpecialFacets() {
        ArrayList<String> additionalFacets = new ArrayList<String>();
        for (String facet : this.facets) {
            if (StringUtils.equals((String)"DEFAULT", (String)facet)) {
                additionalFacets.addAll(new ArrayList<String>(defaultFacets));
                continue;
            }
            if (StringUtils.equals((String)"REUSABILITY", (String)facet)) continue;
            additionalFacets.add(facet);
        }
        this.facets = additionalFacets;
    }

    public boolean isApiQuery() {
        return this.apiQuery;
    }

    public Query setApiQuery(boolean apiQuery) {
        this.apiQuery = apiQuery;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter(String key) {
        return this.parameters.containsKey(key);
    }

    public Query setParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public Query clone() throws CloneNotSupportedException {
        return (Query)super.clone();
    }

    public String toString() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("q=" + this.query);
        params.add("start=" + this.start);
        params.add("rows=" + this.pageSize);
        if (this.refinements != null) {
            for (String refinement : this.refinements) {
                params.add("qf=" + refinement);
            }
        }
        if (this.facets != null) {
            for (String string : this.facets) {
                params.add("facet.field=" + string);
            }
        }
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                params.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (this.getFacetQueries() != null) {
            for (String string : this.getFacetQueries()) {
                params.add("facet.query=" + string);
            }
        }
        return StringUtils.join(params, (String)"&");
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public boolean isProduceFacetUnion() {
        return this.produceFacetUnion;
    }

    public boolean isAllowSpellcheck() {
        return this.allowSpellcheck;
    }

    public Query setAllowSpellcheck(boolean allowSpellcheck) {
        this.allowSpellcheck = allowSpellcheck;
        return this;
    }

    public boolean isAllowFacets() {
        return this.allowFacets;
    }

    public Query setAllowFacets(boolean allowFacets) {
        this.allowFacets = allowFacets;
        return this;
    }

    public Query setProduceFacetUnion(boolean produceFacetUnion) {
        this.produceFacetUnion = produceFacetUnion;
        return this;
    }

    private void createAllFacetList() {
        this.allFacetList = new ArrayList<String>();
        this.allFacetList.addAll(this.facets);
    }

    public void removeFacet(Facet facetToRemove) {
        this.removeFacet(facetToRemove.toString());
    }

    public void removeFacet(String facetToRemove) {
        if (this.facets.contains(facetToRemove)) {
            this.facets.remove(facetToRemove);
        }
    }

    public void setFacet(String facet) {
        this.facets = new ArrayList<String>();
        this.facets.add(facet);
    }

    public String getExecutedQuery() {
        return this.executedQuery;
    }

    public void setExecutedQuery(String executedQuery) {
        try {
            this.executedQuery = URLDecoder.decode(executedQuery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.executedQuery = executedQuery;
            e.printStackTrace();
        }
    }

    public void divideRefinements() {
        this.searchRefinements = new ArrayList<String>();
        this.facetRefinements = new ArrayList<String>();
        if (this.refinements == null) {
            return;
        }
        LinkedHashMap<String, FacetCollector> register = new LinkedHashMap<String, FacetCollector>();
        for (String facetTerm : this.refinements) {
            if (facetTerm.contains(":")) {
                boolean replaced = false;
                String pseudoFacetName = null;
                if (this.valueReplacements != null && this.valueReplacements.containsKey(facetTerm)) {
                    pseudoFacetName = facetTerm.substring(0, facetTerm.indexOf(":"));
                    facetTerm = this.valueReplacements.get(facetTerm);
                    replaced = true;
                    if (StringUtils.isBlank((String)facetTerm)) continue;
                }
                int colon = facetTerm.indexOf(":");
                String facetName = facetTerm.substring(0, colon);
                boolean isTagged = false;
                if (facetName.contains("!tag")) {
                    facetName = facetName.replaceFirst("\\{!tag=.*?\\}", "");
                    isTagged = true;
                }
                if (this.allFacetList.contains(facetName)) {
                    FacetCollector collector;
                    String key;
                    String string = key = pseudoFacetName == null ? facetName : pseudoFacetName;
                    if (register.containsKey(key)) {
                        collector = (FacetCollector)register.get(key);
                    } else {
                        collector = new FacetCollector(facetName, this.isApiQuery());
                        if (pseudoFacetName != null) {
                            collector.setTagName(pseudoFacetName);
                        }
                        register.put(key, collector);
                    }
                    if (isTagged && !collector.isTagged()) {
                        collector.setTagged(true);
                    }
                    collector.addValue(facetTerm.substring(colon + 1), replaced);
                    continue;
                }
                this.searchRefinements.add(facetTerm);
                continue;
            }
            this.searchRefinements.add(facetTerm);
        }
        this.filteredFacets = new ArrayList(register.keySet());
        for (FacetCollector collector : register.values()) {
            this.facetRefinements.add(collector.toString());
        }
    }

    public static String concatenateQueryTranslations(List<LanguageVersion> languageVersions) {
        ArrayList<String> queryTranslationTerms = new ArrayList<String>();
        for (LanguageVersion term : languageVersions) {
            String phrase = EuropeanaStringUtils.createPhraseValue((String)term.getText());
            if (queryTranslationTerms.contains(phrase)) continue;
            queryTranslationTerms.add(phrase);
        }
        return StringUtils.join(queryTranslationTerms, (String)OR);
    }

    static {
        for (Facet facet : Facet.values()) {
            defaultFacets.add(facet.toString());
        }
    }

    private class FacetCollector {
        private boolean isTagged = true;
        private String name;
        private String tagName;
        private List<String> values = new ArrayList<String>();
        private List<String> replacedValues = new ArrayList<String>();
        private boolean isApiQuery = false;
        private boolean replaced = false;

        public FacetCollector(String name) {
            this.name = name;
            this.tagName = name;
        }

        public FacetCollector(String name, boolean isApiQuery) {
            this(name);
            this.isApiQuery = isApiQuery;
        }

        public boolean isTagged() {
            return this.isTagged;
        }

        public void setTagged(boolean isTagged) {
            this.isTagged = isTagged;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        private boolean isAlreadyQuoted(String value) {
            return value.startsWith("\"") && value.endsWith("\"");
        }

        private boolean hasOr(String value) {
            return value.startsWith("(") && value.endsWith(")") && value.contains(Query.OR);
        }

        public void addValue(String value, boolean isReplaced) {
            if (this.name.equals(Facet.RIGHTS.name())) {
                if (value.endsWith("*")) {
                    value = value.replace(":", "\\:").replace("/", "\\/");
                } else if (!this.isAlreadyQuoted(value) && !this.hasOr(value)) {
                    value = '\"' + value + '\"';
                }
            } else if (this.name.equals(Facet.TYPE.name())) {
                value = value.toUpperCase().replace("\"", "");
            } else if (!(this.isApiQuery || value.indexOf(" ") <= -1 && value.indexOf("!") <= -1)) {
                if (!value.startsWith("\"")) {
                    value = '\"' + value;
                }
                if (!value.endsWith("\"")) {
                    value = value + '\"';
                }
            }
            if (isReplaced) {
                this.replacedValues.add(value);
            } else {
                this.values.add(value);
            }
        }

        private String join(List<String> valueList, String booleanOperator) {
            if (valueList.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (valueList.size() > 1) {
                sb.append("(");
                sb.append(StringUtils.join(valueList, (String)booleanOperator));
                sb.append(")");
            } else {
                sb.append(valueList.get(0));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isTagged && !this.replaced) {
                sb.append("{!tag=").append(this.tagName).append("}");
            }
            sb.append(this.name);
            sb.append(":");
            String valuesString = this.join(this.values, Query.OR);
            String replacedValuesString = this.join(this.replacedValues, Query.OR);
            if (StringUtils.isNotBlank((String)valuesString)) {
                if (StringUtils.isNotBlank((String)replacedValuesString)) {
                    sb.append(String.format("(%s AND %s)", valuesString, replacedValuesString));
                } else {
                    sb.append(valuesString);
                }
            } else if (StringUtils.isNotBlank((String)replacedValuesString)) {
                sb.append(replacedValuesString);
            }
            return sb.toString();
        }
    }
}

