/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.model;

import org.apache.commons.lang.StringUtils;

public enum RightsOption {
    CC_ZERO("http://creativecommons.org/publicdomain/zero", "CC0", "icon-cczero", true),
    CC_BY("http://creativecommons.org/licenses/by/", "CC BY", "icon-cc icon-by", true),
    CC_BY_SA("http://creativecommons.org/licenses/by-sa/", "CC BY-SA", "icon-cc icon-by icon-sa", true),
    CC_BY_NC_SA("http://creativecommons.org/licenses/by-nc-sa/", "CC BY-NC-SA", "icon-cc icon-by icon-nceu icon-sa", true),
    CC_BY_ND("http://creativecommons.org/licenses/by-nd/", "CC BY-ND", "icon-cc icon-by icon-nd", true),
    CC_BY_NC("http://creativecommons.org/licenses/by-nc/", "CC BY-NC", "icon-cc icon-by icon-nceu", true),
    CC_BY_NC_ND("http://creativecommons.org/licenses/by-nc-nd/", "CC BY-NC-ND", "icon-cc icon-by icon-nceu icon-nd", true),
    NOC("http://creativecommons.org/publicdomain/mark/", "Public Domain marked", "icon-pd", true),
    EU_RR_F("http://www.europeana.eu/rights/rr-f/", "Rights Reserved - Free Access", "icon-copyright", false, true),
    EU_RR_P("http://www.europeana.eu/rights/rr-p/", "Rights Reserved - Paid Access", "icon-copyright", false, true),
    EU_RR_R("http://www.europeana.eu/rights/rr-r/", "Restricted Access - Rights Reserved", "icon-copyright", false, true),
    EU_ORPHAN("http://www.europeana.eu/rights/test-orphan-work-test/", "Orphan Work", "icon-unknown", false, true),
    EU_U("http://www.europeana.eu/rights/unknown/", "Unknown copyright status", "icon-unknown", false, true),
    OOC_NC("http://www.europeana.eu/rights/out-of-copyright-non-commercial/", "Out of copyright - non commercial re-use", "icon-publicdomain icon-nceu", false, true);

    private String url = null;
    private String rightsText = null;
    private String rightsIcon = null;
    private boolean showExternalIcon = false;
    private boolean isRelativeUrl = false;
    private String relativeUrl = null;

    private RightsOption(String url, String rightsText, String rightsIcon, boolean showExternalIconIn) {
        this.url = url;
        this.rightsText = rightsText;
        this.rightsIcon = rightsIcon;
        this.showExternalIcon = showExternalIconIn;
    }

    private RightsOption(String url, String rightsText, String rightsIcon, boolean showExternalIconIn, boolean isRelativeUrl) {
        this(url, rightsText, rightsIcon, showExternalIconIn);
        this.isRelativeUrl = isRelativeUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRelativeUrl(String portalUrl) {
        if (this.relativeUrl == null) {
            if (this.isRelativeUrl) {
                if (!portalUrl.endsWith("/")) {
                    portalUrl = portalUrl + "/";
                }
                this.relativeUrl = this.url.replace("http://www.europeana.eu/", portalUrl).replaceAll("/$", ".html");
            } else {
                this.relativeUrl = this.url;
            }
        }
        return this.relativeUrl;
    }

    public String getRightsText() {
        return this.rightsText;
    }

    public String getRightsIcon() {
        return this.rightsIcon;
    }

    public boolean getShowExternalIcon() {
        return this.showExternalIcon;
    }

    public static RightsOption safeValueByUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            for (RightsOption option : RightsOption.values()) {
                if (!url.contains(option.getUrl())) continue;
                return option;
            }
        }
        return null;
    }

    public boolean isRelativeUrl() {
        return this.isRelativeUrl;
    }
}

