/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.cassandra.CassandraConnectionProviderSingleton;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.RevisionServiceClient;
import eu.europeana.cloud.service.dps.storm.utils.CassandraSubTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskErrorsDAO;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.utils.TaskStatusChecker;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.testing.CompleteTopologyParam;
import org.apache.storm.testing.MkClusterParam;
import org.apache.storm.testing.MockedSources;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class TopologyTestHelper {
    protected CassandraTaskInfoDAO taskInfoDAO;
    protected CassandraSubTaskInfoDAO subTaskInfoDAO;
    protected CassandraTaskErrorsDAO taskErrorsDAO;
    protected TaskStatusChecker taskStatusChecker;
    protected FileServiceClient fileServiceClient;
    protected DataSetServiceClient dataSetClient;
    protected RecordServiceClient recordServiceClient;
    protected RevisionServiceClient revisionServiceClient;
    private static final Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
    private static Gson gson = new GsonBuilder().create();

    protected static MkClusterParam prepareMKClusterParm() {
        MkClusterParam mkClusterParam = new MkClusterParam();
        int SUPERVISORS = 4;
        mkClusterParam.setSupervisors(Integer.valueOf(SUPERVISORS));
        Config daemonConf = new Config();
        daemonConf.put((Object)"storm.local.mode.zmq", (Object)false);
        mkClusterParam.setDaemonConf((Map)daemonConf);
        return mkClusterParam;
    }

    protected void mockCassandraInteraction() throws Exception {
        this.taskInfoDAO = (CassandraTaskInfoDAO)Mockito.mock(CassandraTaskInfoDAO.class);
        PowerMockito.mockStatic(CassandraTaskInfoDAO.class, (Class[])new Class[0]);
        Mockito.when((Object)CassandraTaskInfoDAO.getInstance((CassandraConnectionProvider)((CassandraConnectionProvider)Matchers.isA(CassandraConnectionProvider.class)))).thenReturn((Object)this.taskInfoDAO);
        this.taskStatusChecker = (TaskStatusChecker)Mockito.mock(TaskStatusChecker.class);
        PowerMockito.mockStatic(TaskStatusChecker.class, (Class[])new Class[0]);
        Mockito.when((Object)TaskStatusChecker.getTaskStatusChecker()).thenReturn((Object)this.taskStatusChecker);
        this.subTaskInfoDAO = (CassandraSubTaskInfoDAO)Mockito.mock(CassandraSubTaskInfoDAO.class);
        PowerMockito.mockStatic(CassandraSubTaskInfoDAO.class, (Class[])new Class[0]);
        Mockito.when((Object)CassandraSubTaskInfoDAO.getInstance((CassandraConnectionProvider)((CassandraConnectionProvider)Matchers.isA(CassandraConnectionProvider.class)))).thenReturn((Object)this.subTaskInfoDAO);
        this.taskErrorsDAO = (CassandraTaskErrorsDAO)Mockito.mock(CassandraTaskErrorsDAO.class);
        PowerMockito.mockStatic(CassandraTaskErrorsDAO.class, (Class[])new Class[0]);
        Mockito.when((Object)CassandraTaskErrorsDAO.getInstance((CassandraConnectionProvider)((CassandraConnectionProvider)Matchers.isA(CassandraConnectionProvider.class)))).thenReturn((Object)this.taskErrorsDAO);
        Mockito.when((Object)this.taskInfoDAO.hasKillFlag(Matchers.anyLong())).thenReturn((Object)false);
        PowerMockito.mockStatic(CassandraConnectionProviderSingleton.class, (Class[])new Class[0]);
        Mockito.when((Object)CassandraConnectionProviderSingleton.getCassandraConnectionProvider((String)Matchers.anyString(), (int)Matchers.anyInt(), (String)Matchers.anyString(), (String)Matchers.anyString(), (String)Matchers.anyString())).thenReturn(Mockito.mock(CassandraConnectionProvider.class));
    }

    protected void mockRecordSC() throws Exception {
        this.recordServiceClient = (RecordServiceClient)Mockito.mock(RecordServiceClient.class);
        PowerMockito.whenNew(RecordServiceClient.class).withAnyArguments().thenReturn((Object)this.recordServiceClient);
    }

    protected void mockFileSC() throws Exception {
        this.fileServiceClient = (FileServiceClient)Mockito.mock(FileServiceClient.class);
        PowerMockito.whenNew(FileServiceClient.class).withAnyArguments().thenReturn((Object)this.fileServiceClient);
    }

    protected void mockDatSetClient() throws Exception {
        this.dataSetClient = (DataSetServiceClient)Mockito.mock(DataSetServiceClient.class);
        PowerMockito.whenNew(DataSetServiceClient.class).withAnyArguments().thenReturn((Object)this.dataSetClient);
    }

    protected void mockRevisionServiceClient() throws Exception {
        this.revisionServiceClient = (RevisionServiceClient)Mockito.mock(RevisionServiceClient.class);
        PowerMockito.whenNew(RevisionServiceClient.class).withAnyArguments().thenReturn((Object)this.revisionServiceClient);
    }

    protected CompleteTopologyParam prepareCompleteTopologyParam(MockedSources mockedSources) {
        CompleteTopologyParam completeTopologyParam = new CompleteTopologyParam();
        completeTopologyParam.setMockedSources(mockedSources);
        completeTopologyParam.setStormConf(this.buildConfig());
        return completeTopologyParam;
    }

    private Config buildConfig() {
        Config conf = new Config();
        conf.setNumWorkers(1);
        conf.put((Object)"CASSANDRA_HOSTS", (Object)"CASSANDRA_HOSTS");
        conf.put((Object)"CASSANDRA_PORT", (Object)"9042");
        conf.put((Object)"CASSANDRA_KEYSPACE_NAME", (Object)"CASSANDRA_KEYSPACE_NAME");
        conf.put((Object)"CASSANDRA_USERNAME", (Object)"CASSANDRA_USERNAME");
        conf.put((Object)"CASSANDRA_PASSWORD", (Object)"CASSANDRA_PASSWORD");
        conf.setNumAckers(0);
        return conf;
    }

    protected static void prettyPrintJSON(List printIn, String input) {
        String json = prettyGson.toJson((Object)printIn);
        System.out.println("=============================" + input + "=============================\n" + json);
    }

    protected static String parse(List input) {
        return gson.toJson((Object)input);
    }
}

