/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.Map;

public class WiremockHelper {
    private static final String LOCATION_HEADER_NAME = "Location";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String APPLICATION_XML = "application/xml";
    private static final String APPLICATION_JSON = "application/json";
    private final WireMockRule wireMockRule;

    public WiremockHelper(WireMockRule wireMockRule) {
        this.wireMockRule = wireMockRule;
    }

    public void reset() {
        this.wireMockRule.resetAll();
    }

    public void stubGet(String url, int responseStatus, String responseBody) {
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withBody(responseBody)));
    }

    public void stubGetWithJsonContent(String url, int responseStatus, String responseBody) {
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_JSON}).withBody(responseBody)));
    }

    public void stubPost(String url, int responseStatus, Map<String, String> headers, String responseBody) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpHeaders.plus(new HttpHeader[]{HttpHeader.httpHeader((String)entry.getKey(), (String[])new String[]{entry.getValue()})});
        }
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeaders(httpHeaders).withBody(responseBody)));
    }

    public void stubPost(String url, int responseStatus, String responseBody) {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withBody(responseBody)));
    }

    public void stubPost(String url, String requestBody, String locationHeader, int responseStatus, String responseBody) {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).withRequestBody((ContentPattern)WireMock.matching((String)requestBody)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withHeader(LOCATION_HEADER_NAME, new String[]{locationHeader}).withBody(responseBody)));
    }

    public void stubPost(String url, JsonNode requestBody, int responseStatus, JsonNode responseBody) {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).withRequestBody(requestBody != null ? WireMock.containing((String)requestBody.toString()) : null).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_JSON}).withJsonBody(responseBody)));
    }

    public void stubPost(String url, int responseStatus, String locationHeader, String eTag, String responseBody) {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withHeader(LOCATION_HEADER_NAME, new String[]{locationHeader}).withHeader("ETag", new String[]{eTag}).withBody(responseBody)));
    }

    public void stubPost(String url, int responseStatus, String locationHeader, String responseBody) {
        this.wireMockRule.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withHeader(LOCATION_HEADER_NAME, new String[]{locationHeader}).withBody(responseBody)));
    }

    public void stubDelete(String url, int responseStatus) {
        this.wireMockRule.stubFor(WireMock.delete((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus)));
    }

    public void stubDelete(String url, int responseStatus, String responseBody) {
        this.wireMockRule.stubFor(WireMock.delete((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withBody(responseBody)));
    }

    public void stubPut(String url, int responseStatus) {
        this.wireMockRule.stubFor(WireMock.put((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus)));
    }

    public void stubPut(String url, int responseStatus, String locationHeader, String eTag, String responseBody) {
        this.wireMockRule.stubFor(WireMock.put((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus).withHeader(CONTENT_TYPE_HEADER_NAME, new String[]{APPLICATION_XML}).withHeader(LOCATION_HEADER_NAME, new String[]{locationHeader}).withHeader("ETag", new String[]{eTag}).withBody(responseBody)));
    }

    public void stubHead(String url, int responseStatus) {
        this.wireMockRule.stubFor(WireMock.head((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withStatus(responseStatus)));
    }
}

