/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.test;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.findify.s3mock.S3Mock;
import java.util.concurrent.ThreadLocalRandom;

public final class S3TestHelper {
    private static S3Mock api;
    private static AmazonS3Client client;

    private S3TestHelper() {
    }

    public static void startS3MockServer() {
        api = new S3Mock.Builder().withInMemoryBackend().withPort(S3TestConstants.S3_TEST_PORT.intValue()).build();
        api.start();
        client = (AmazonS3Client)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(S3TestConstants.S3_TEST_ENDPOINT, "test_region"))).build();
        client.createBucket("test-container");
    }

    public static void cleanUpBetweenTests() {
        client.deleteBucket("test-container");
        client.createBucket("test-container");
    }

    public static void stopS3MockServer() {
        api.stop();
    }

    public static final class S3TestConstants {
        public static final Integer S3_TEST_PORT = ThreadLocalRandom.current().nextInt(10000, 65536);
        public static final String S3_TEST_ENDPOINT = "http://127.0.0.1:" + S3_TEST_PORT;
        public static final String S3_TEST_CONTAINER = "test-container";
        public static final String S3_TEST_USER = "test_user";
        public static final String S3_TEST_PASSWORD = "test_pwd";
        public static final String S3_TEST_REGION = "test_region";
        public static final int S3_TEST_MAX_PART_SIZE = 5;

        private S3TestConstants() {
        }
    }
}

