/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.test;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;

public final class CassandraTestInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTestInstance.class);
    private static CassandraTestInstance instance;
    private static final Map<String, Session> keyspaceSessions;
    private static Throwable containerStartException;
    private final Cluster cluster;
    private final CassandraContainer container;

    private CassandraTestInstance() {
        if (instance != null) {
            throw new IllegalStateException("Already initialized.");
        }
        if (containerStartException != null) {
            throw new RuntimeException("Cassandra container is not initialized!", containerStartException);
        }
        try {
            LOGGER.info("Starting Cassandra container in docker");
            this.container = new CassandraContainer("cassandra:3.11.2");
            this.container.withStartupTimeout(Duration.ofSeconds(180L));
            this.container.withEnv("HEAP_NEWSIZE", "32M");
            this.container.withEnv("MAX_HEAP_SIZE", "256M");
            this.container.setStartupAttempts(1);
            this.container.start();
            this.cluster = this.container.getCluster();
            LOGGER.info("Cassandra container initialized.");
        }
        catch (Exception e) {
            containerStartException = e;
            throw new RuntimeException("Cannot start Cassandra container!", e);
        }
        catch (Error e) {
            containerStartException = e;
            throw e;
        }
    }

    public static int getPort() {
        return CassandraTestInstance.instance.container.getMappedPort(9042);
    }

    public static synchronized CassandraTestInstance getInstance(String keyspaceSchemaCql, String keyspace) {
        if (instance == null) {
            instance = new CassandraTestInstance();
        }
        instance.initKeyspaceIfNeeded(keyspaceSchemaCql, keyspace);
        return instance;
    }

    public static synchronized void truncateAllData(boolean hard) {
        LOGGER.info(keyspaceSessions.toString());
        for (String keyspaceName : keyspaceSessions.keySet()) {
            if (hard) {
                LOGGER.warn("Truncating all tables! Operation is slow use CassandraTestInstance.truncateAllData(false).");
                CassandraTestInstance.truncateAllKeyspaceTables(keyspaceName);
                continue;
            }
            LOGGER.info("Truncating all not empty tables!");
            CassandraTestInstance.truncateAllNotEmptyKeyspaceTables(keyspaceName);
        }
    }

    public static Session getSession(String keyspace) {
        return keyspaceSessions.get(keyspace);
    }

    private static void truncateAllKeyspaceTables(String keyspaceName) {
        Session session = keyspaceSessions.get(keyspaceName);
        ResultSet rs = session.execute("SELECT table_name from system.tables where keyspace_name='" + keyspaceName + "';");
        for (Row r : rs.all()) {
            String tableName = r.getString("columnfamily_name");
            LOGGER.info("embedded Cassandra tuncating table: {}", (Object)tableName);
            session.execute("TRUNCATE " + tableName);
        }
    }

    private static void truncateAllNotEmptyKeyspaceTables(String keyspaceName) {
        Session session = keyspaceSessions.get(keyspaceName);
        ResultSet rs = session.execute("SELECT table_name from system_schema.tables where keyspace_name='" + keyspaceName + "';");
        for (Row r : rs.all()) {
            String tableName = r.getString("table_name");
            ResultSet rows = session.execute("SELECT * FROM " + tableName + " LIMIT 1;");
            if (rows.one() == null) {
                LOGGER.info("embedded Cassandra keyspace table:{} - is empty", (Object)tableName);
                continue;
            }
            LOGGER.info("embedded Cassandra tuncating table: {}", (Object)tableName);
            session.execute("TRUNCATE " + tableName);
        }
    }

    public static synchronized void print() {
        LOGGER.info(keyspaceSessions.toString());
        for (String keyspaceName : keyspaceSessions.keySet()) {
            Session session = keyspaceSessions.get(keyspaceName);
            ResultSet rs = session.execute("SELECT columnfamily_name from system.schema_columnfamilies where keyspace_name='" + keyspaceName + "';");
            for (Row r : rs.all()) {
                String tableName = r.getString("columnfamily_name");
                ResultSet rows = session.execute("SELECT * FROM " + tableName + ";");
                LOGGER.info("keyspace : {}, table : {}  have rows : {} ", new Object[]{keyspaceName, tableName, rows.getAvailableWithoutFetching()});
            }
        }
    }

    public void initKeyspaceIfNeeded(String keyspaceSchemaCql, String keyspace) {
        if (!keyspaceSessions.containsKey(keyspace)) {
            this.initKeyspace(keyspaceSchemaCql, keyspace);
        } else {
            LOGGER.info("embedded Cassandra keyspace {} is already initialized.", (Object)keyspace);
        }
    }

    public synchronized void clean() {
        keyspaceSessions.clear();
    }

    private void initKeyspace(String keyspaceSchemaCql, String keyspace) {
        LOGGER.info("Initializing embedded Cassandra keyspace {} ...", (Object)keyspace);
        this.applyCQL(keyspaceSchemaCql);
        Session session = this.cluster.connect(keyspace);
        keyspaceSessions.put(keyspace, session);
        LOGGER.info("embedded Cassandra keyspace {} initialized.", (Object)keyspace);
    }

    private void applyCQL(String keyspaceSchemaCql) {
        try (Session tempSession = this.cluster.newSession();){
            String[] statements = StringUtils.split((String)IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(keyspaceSchemaCql)), (String)";");
            Arrays.stream(statements).map(statement -> StringUtils.normalizeSpace((String)statement) + ";").forEach(arg_0 -> ((Session)tempSession).execute(arg_0));
        }
        catch (IOException e) {
            LOGGER.error("Unable to load data to Cassandra", (Throwable)e);
            throw new RuntimeException("Unable to load data to Cassandra");
        }
    }

    static {
        keyspaceSessions = Collections.synchronizedMap(new HashMap());
    }

    private static final class TestRetryPolicy
    implements RetryPolicy {
        public static final Logger log = LoggerFactory.getLogger(TestRetryPolicy.class);
        private final double maxReadNbRetry;
        private final double maxWriteNbRetry;
        private final double maxUnavailableNbRetry;
        private final long waitRetryTime;

        TestRetryPolicy(double maxReadNbRetry, double maxWriteNbRetry, double maxUnavailableNbRetry, long waitRetryTime) {
            this.maxReadNbRetry = maxReadNbRetry;
            this.maxWriteNbRetry = maxWriteNbRetry;
            this.maxUnavailableNbRetry = maxUnavailableNbRetry;
            this.waitRetryTime = waitRetryTime;
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            this.waitForNextRetry();
            if (dataRetrieved && receivedResponses >= requiredResponses) {
                return RetryPolicy.RetryDecision.ignore();
            }
            if ((double)nbRetry < this.maxReadNbRetry) {
                return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
            }
            return RetryPolicy.RetryDecision.rethrow();
        }

        private void waitForNextRetry() {
            try {
                Thread.sleep(this.waitRetryTime);
            }
            catch (InterruptedException e) {
                log.error("Sleep interrupted!", (Throwable)e);
            }
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            this.waitForNextRetry();
            return this.getRetryDecision(cl, requiredAcks, receivedAcks, nbRetry, this.maxWriteNbRetry);
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            this.waitForNextRetry();
            return this.getRetryDecision(cl, requiredReplica, aliveReplica, nbRetry, this.maxUnavailableNbRetry);
        }

        public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel consistencyLevel, DriverException e, int i) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public void init(Cluster cluster) {
        }

        public void close() {
        }

        private RetryPolicy.RetryDecision getRetryDecision(ConsistencyLevel cl, int required, int actual, int nbRetry, double maxNbRetry) {
            if (actual >= required) {
                return RetryPolicy.RetryDecision.ignore();
            }
            if ((double)nbRetry < maxNbRetry) {
                return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
            }
            return RetryPolicy.RetryDecision.rethrow();
        }
    }
}

