/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.test;

import com.datastax.driver.core.AtomicMonotonicTimestampGenerator;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraTestInstance {
    private static final int PORT = 19142;
    private static final String CASSANDRA_CONFIG_FILE = "eu-cassandra.yaml";
    private static final long CASSANDRA_STARTUP_TIMEOUT = 180000L;
    private static final int CONNECT_TIMEOUT_MILLIS = 100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTestInstance.class);
    private static volatile CassandraTestInstance instance;
    private static volatile Map<String, Session> keyspaceSessions;
    private final Cluster cluster;

    private CassandraTestInstance() {
        if (instance != null) {
            throw new IllegalStateException("Already initialized.");
        }
        try {
            LOGGER.info("Starting embedded Cassandra");
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)CASSANDRA_CONFIG_FILE, (long)180000L);
            this.cluster = this.buildClusterWithConsistencyLevel(ConsistencyLevel.ALL);
            LOGGER.info("embedded Cassandra initialized.");
        }
        catch (Exception e) {
            LOGGER.error("Cannot start embedded Cassandra!", (Throwable)e);
            EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
            throw new RuntimeException("Cannot start embedded Cassandra!", e);
        }
    }

    private Cluster buildClusterWithConsistencyLevel(ConsistencyLevel level) {
        QueryOptions queryOptions = new QueryOptions().setConsistencyLevel(level);
        SocketOptions socketOptions = new SocketOptions().setConnectTimeoutMillis(100000);
        return Cluster.builder().addContactPoints("localhost").withPort(19142).withProtocolVersion(ProtocolVersion.V3).withQueryOptions(queryOptions).withSocketOptions(socketOptions).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)new TestRetryPolicy(3.0, 3.0, 3.0))).withTimestampGenerator((TimestampGenerator)new AtomicMonotonicTimestampGenerator()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CassandraTestInstance getInstance(String keyspaceSchemaCql, String keyspace) {
        CassandraTestInstance result = instance;
        if (result == null) {
            Class<CassandraTestInstance> clazz = CassandraTestInstance.class;
            // MONITORENTER : eu.europeana.cloud.test.CassandraTestInstance.class
            result = instance;
            if (result == null) {
                instance = result = new CassandraTestInstance();
            }
            // MONITOREXIT : clazz
        }
        instance.initKeyspaceIfNeeded(keyspaceSchemaCql, keyspace);
        return result;
    }

    public static synchronized void truncateAllData(boolean hard) {
        LOGGER.info(keyspaceSessions.toString());
        for (String keyspaceName : keyspaceSessions.keySet()) {
            if (hard) {
                LOGGER.warn("Truncating all tables! Operation is slow use CassandraTestInstance.truncateAllData(false).");
                CassandraTestInstance.truncateAllKeyspaceTables(keyspaceName);
                continue;
            }
            LOGGER.info("Truncating all not empty tables!");
            CassandraTestInstance.truncateAllNotEmptyKeyspaceTables(keyspaceName);
        }
    }

    public static Session getSession(String keyspace) {
        return keyspaceSessions.get(keyspace);
    }

    private static void truncateAllKeyspaceTables(String keyspaceName) {
        Session session = keyspaceSessions.get(keyspaceName);
        ResultSet rs = session.execute("SELECT columnfamily_name from system.schema_columnfamilies where keyspace_name='" + keyspaceName + "';");
        for (Row r : rs.all()) {
            String tableName = r.getString("columnfamily_name");
            LOGGER.info("embedded Cassandra tuncating table: " + tableName);
            session.execute("TRUNCATE " + tableName);
        }
    }

    private static void truncateAllNotEmptyKeyspaceTables(String keyspaceName) {
        Session session = keyspaceSessions.get(keyspaceName);
        ResultSet rs = session.execute("SELECT columnfamily_name from system.schema_columnfamilies where keyspace_name='" + keyspaceName + "';");
        for (Row r : rs.all()) {
            String tableName = r.getString("columnfamily_name");
            ResultSet rows = session.execute("SELECT * FROM " + tableName + " LIMIT 1;");
            if (rows.one() == null) {
                LOGGER.info("embedded Cassandra keyspace table:" + tableName + " - is empty");
                continue;
            }
            LOGGER.info("embedded Cassandra tuncating table: " + tableName);
            session.execute("TRUNCATE " + tableName);
        }
    }

    public static synchronized void print() {
        LOGGER.info(keyspaceSessions.toString());
        for (String keyspaceName : keyspaceSessions.keySet()) {
            ResultSet rs = keyspaceSessions.get(keyspaceName).execute("SELECT columnfamily_name from system.schema_columnfamilies where keyspace_name='" + keyspaceName + "';");
            for (Row r : rs.all()) {
                String tableName = r.getString("columnfamily_name");
                Session session = keyspaceSessions.get(keyspaceName);
                ResultSet rows = session.execute("SELECT * FROM " + tableName + ";");
                LOGGER.info("keyspace : " + keyspaceName + ", table : " + tableName + " have rows : " + rows.getAvailableWithoutFetching());
            }
        }
    }

    private void initKeyspaceIfNeeded(String keyspaceSchemaCql, String keyspace) {
        if (!keyspaceSessions.containsKey(keyspace)) {
            this.initKeyspace(keyspaceSchemaCql, keyspace);
        } else {
            LOGGER.info("embedded Cassandra keyspace " + keyspace + " is already initialized.");
        }
    }

    public synchronized void clean() {
        keyspaceSessions.clear();
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    private void initKeyspace(String keyspaceSchemaCql, String keyspace) {
        LOGGER.info("Initializing embedded Cassandra keyspace " + keyspace + " ...");
        this.applyCQL(keyspaceSchemaCql, keyspace);
        Session session = this.cluster.connect(keyspace);
        keyspaceSessions.put(keyspace, session);
        LOGGER.info("embedded Cassandra keyspace " + keyspace + " initialized.");
    }

    private void applyCQL(String keyspaceSchemaCql, String keyspace) {
        Session tempSession = this.cluster.newSession();
        CQLDataLoader dataLoader = new CQLDataLoader(tempSession);
        dataLoader.load((CQLDataSet)new ClassPathCQLDataSet(keyspaceSchemaCql, keyspace));
        tempSession.close();
    }

    static {
        keyspaceSessions = Collections.synchronizedMap(new HashMap());
    }

    private static final class TestRetryPolicy
    implements RetryPolicy {
        public static final Logger log = LoggerFactory.getLogger(TestRetryPolicy.class);
        private final double maxReadNbRetry;
        private final double maxWriteNbRetry;
        private final double maxUnavailableNbRetry;

        TestRetryPolicy(double maxReadNbRetry, double maxWriteNbRetry, double maxUnavailableNbRetry) {
            this.maxReadNbRetry = maxReadNbRetry;
            this.maxWriteNbRetry = maxWriteNbRetry;
            this.maxUnavailableNbRetry = maxUnavailableNbRetry;
        }

        public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            if (dataRetrieved && receivedResponses >= requiredResponses) {
                return RetryPolicy.RetryDecision.ignore();
            }
            if ((double)nbRetry < this.maxReadNbRetry) {
                return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
            }
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return this.getRetryDecision(cl, requiredAcks, receivedAcks, nbRetry, this.maxWriteNbRetry);
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            return this.getRetryDecision(cl, requiredReplica, aliveReplica, nbRetry, this.maxUnavailableNbRetry);
        }

        private RetryPolicy.RetryDecision getRetryDecision(ConsistencyLevel cl, int required, int actual, int nbRetry, double maxNbRetry) {
            if (actual >= required) {
                return RetryPolicy.RetryDecision.ignore();
            }
            if ((double)nbRetry < maxNbRetry) {
                return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
            }
            return RetryPolicy.RetryDecision.rethrow();
        }
    }
}

