/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.web.common;

import eu.europeana.cloud.service.web.common.LoggingMessage;
import eu.europeana.cloud.service.web.common.LoggingMessageBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoggingFilter
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingFilter.class);
    private static final String REQUEST_ID_ATTRIBUTE_NAME = "requestId";

    public boolean preHandle(HttpServletRequest servletRequest, HttpServletResponse hsr1, Object handler) {
        MDC.put((String)REQUEST_ID_ATTRIBUTE_NAME, (String)RandomStringUtils.randomAlphanumeric((int)6));
        this.readContextAttributes(servletRequest);
        this.publishRequestStartTimeTo(servletRequest);
        return true;
    }

    private void readContextAttributes(HttpServletRequest servletRequest) {
        String recordId;
        String taskId = servletRequest.getHeader("task_id");
        if (taskId != null) {
            MDC.put((String)"task_id", (String)taskId);
        }
        if ((recordId = servletRequest.getHeader("record_id")) != null) {
            MDC.put((String)"record_id", (String)recordId);
        }
    }

    public void afterCompletion(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler, Exception exception) {
        LoggingMessage message = this.buildMessage(servletRequest, servletResponse);
        switch (message.getStatus()) {
            case 404: 
            case 409: {
                LOGGER.warn(message.getMessage());
                break;
            }
            default: {
                LOGGER.info(message.getMessage());
            }
        }
        MDC.remove((String)REQUEST_ID_ATTRIBUTE_NAME);
        MDC.remove((String)"task_id");
        MDC.remove((String)"record_id");
    }

    private void publishRequestStartTimeTo(HttpServletRequest servletRequest) {
        long requestStartTime = System.currentTimeMillis();
        servletRequest.setAttribute("startTime", (Object)requestStartTime);
    }

    private LoggingMessage buildMessage(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        LoggingMessageBuilder builder = new LoggingMessageBuilder();
        return builder.withStatusCode(servletResponse.getStatus()).withRemoteAddr(this.readRemoteAddr(servletRequest)).withRequestTime(this.calculateRequestTime(servletRequest)).withResourcePath(this.readRequestPath(servletRequest)).withRequestMethod(this.readRequestMethod(servletRequest)).withClientUsername(servletRequest.getRemoteUser()).build();
    }

    private String readRemoteAddr(HttpServletRequest servletRequest) {
        try {
            return servletRequest.getRemoteAddr();
        }
        catch (Exception e) {
            return "error.remote.address";
        }
    }

    private long calculateRequestTime(HttpServletRequest servletRequest) {
        long now = System.currentTimeMillis();
        return now - (Long)servletRequest.getAttribute("startTime");
    }

    private String readRequestPath(HttpServletRequest servletRequest) {
        return servletRequest.getRequestURI();
    }

    private String readRequestMethod(HttpServletRequest servletRequest) {
        return servletRequest.getMethod();
    }
}

