/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.web.common;

import eu.europeana.cloud.service.web.common.LoggingMessage;

public class LoggingMessageBuilder {
    private static final String LOG_MESSAGE_PATTERN = "%STATUS_CODE %REQUEST_TIME %CLIENT_IP %CLIENT_USERNAME %REQUEST_METHOD %RESOURCE_PATH Request received";
    private int statusCode;
    private long requestTime;
    private String remoteAddr;
    private String resourcePath;
    private String requestMethod;
    private String clientUsername;

    public LoggingMessage build() {
        String message = LOG_MESSAGE_PATTERN;
        message = message.replace("%STATUS_CODE", "" + this.statusCode);
        message = message.replace("%REQUEST_TIME", this.requestTime + "ms");
        message = message.replace("%CLIENT_IP", this.remoteAddr);
        message = message.replace("%RESOURCE_PATH", this.resourcePath);
        message = message.replace("%REQUEST_METHOD", this.requestMethod);
        message = message.replace("%CLIENT_USERNAME", this.clientUsername == null ? "" : this.clientUsername);
        LoggingMessage m = new LoggingMessage();
        m.setMessage(message);
        m.setStatus(this.statusCode);
        return m;
    }

    public LoggingMessageBuilder withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public LoggingMessageBuilder withRequestTime(long requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    public LoggingMessageBuilder withClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
        return this;
    }

    public LoggingMessageBuilder withRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public LoggingMessageBuilder withResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public LoggingMessageBuilder withRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }
}

