/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.codec;

public final class Hex {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static char[] encode(byte[] bytes) {
        int nBytes = bytes.length;
        char[] result2 = new char[2 * nBytes];
        int j = 0;
        for (int i = 0; i < nBytes; ++i) {
            result2[j++] = HEX[(0xF0 & bytes[i]) >>> 4];
            result2[j++] = HEX[0xF & bytes[i]];
        }
        return result2;
    }

    public static byte[] decode(CharSequence s2) {
        int nChars = s2.length();
        if (nChars % 2 != 0) {
            throw new IllegalArgumentException("Hex-encoded string must have an even number of characters");
        }
        byte[] result2 = new byte[nChars / 2];
        for (int i = 0; i < nChars; i += 2) {
            int msb = Character.digit(s2.charAt(i), 16);
            int lsb = Character.digit(s2.charAt(i + 1), 16);
            if (msb < 0 || lsb < 0) {
                throw new IllegalArgumentException("Non-hex character in input: " + s2);
            }
            result2[i / 2] = (byte)(msb << 4 | lsb);
        }
        return result2;
    }
}

