/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.BootstrapConfiguration;
import javax.validation.executable.ExecutableType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.BootstrapConfigurationImpl;
import org.hibernate.validator.internal.xml.DefaultValidatedExecutableTypesType;
import org.hibernate.validator.internal.xml.ExecutableValidationType;
import org.hibernate.validator.internal.xml.PropertyType;
import org.hibernate.validator.internal.xml.ResourceLoaderHelper;
import org.hibernate.validator.internal.xml.ValidationConfigType;
import org.hibernate.validator.internal.xml.XmlParserHelper;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final ConcurrentMap<String, String> SCHEMAS_BY_VERSION = new ConcurrentHashMap<String, String>(2, 0.75f, 1);
    private final XmlParserHelper xmlParserHelper = new XmlParserHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BootstrapConfiguration parseValidationXml() {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return BootstrapConfigurationImpl.getDefaultBootstrapConfiguration();
        }
        try {
            String schemaVersion = this.xmlParserHelper.getSchemaVersion(VALIDATION_XML_FILE, inputStream);
            Schema schema = this.getSchema(schemaVersion);
            ValidationConfigType validationConfig = this.unmarshal(inputStream, schema);
            BootstrapConfiguration bootstrapConfiguration = this.createBootstrapConfiguration(validationConfig);
            return bootstrapConfiguration;
        }
        finally {
            this.closeStream(inputStream);
        }
    }

    private InputStream getInputStream() {
        log.debugf("Trying to load %s for XML based Validator configuration.", (Object)VALIDATION_XML_FILE);
        InputStream inputStream = ResourceLoaderHelper.getResettableInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream != null) {
            return inputStream;
        }
        log.debugf("No %s found. Using annotation based configuration only.", (Object)VALIDATION_XML_FILE);
        return null;
    }

    private Schema getSchema(String schemaVersion) {
        String schemaResource = (String)SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException(VALIDATION_XML_FILE, schemaVersion);
        }
        return this.xmlParserHelper.getSchema(schemaResource);
    }

    private ValidationConfigType unmarshal(InputStream inputStream, Schema schema) {
        log.parsingXMLFile(VALIDATION_XML_FILE);
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ValidationConfigType.class));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root2 = (JAXBElement)this.run(Unmarshal.action(unmarshaller, stream, ValidationConfigType.class));
            return (ValidationConfigType)root2.getValue();
        }
        catch (Exception e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException io) {
            log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
        }
    }

    private BootstrapConfiguration createBootstrapConfiguration(ValidationConfigType config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Found property '%s' with value '%s' in validation.xml.", (Object)property.getName(), (Object)property.getValue());
            }
            properties.put(property.getName(), property.getValue());
        }
        ExecutableValidationType executableValidationType = config.getExecutableValidation();
        EnumSet<ExecutableType> defaultValidatedExecutableTypes = executableValidationType == null ? this.getValidatedExecutableTypes(null) : this.getValidatedExecutableTypes(executableValidationType.getDefaultValidatedExecutableTypes());
        boolean executableValidationEnabled = executableValidationType == null || executableValidationType.getEnabled();
        return new BootstrapConfigurationImpl(config.getDefaultProvider(), config.getConstraintValidatorFactory(), config.getMessageInterpolator(), config.getTraversableResolver(), config.getParameterNameProvider(), defaultValidatedExecutableTypes, executableValidationEnabled, new HashSet<String>(config.getConstraintMapping()), properties);
    }

    private EnumSet<ExecutableType> getValidatedExecutableTypes(DefaultValidatedExecutableTypesType validatedExecutables) {
        if (validatedExecutables == null) {
            return null;
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        executableTypes.addAll(validatedExecutables.getExecutableType());
        return executableTypes;
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws Exception {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static {
        SCHEMAS_BY_VERSION.put("1.0", "META-INF/validation-configuration-1.0.xsd");
        SCHEMAS_BY_VERSION.put("1.1", "META-INF/validation-configuration-1.1.xsd");
    }
}

