/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.annotationfactory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;

class AnnotationProxy
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6907601010599429454L;
    private static final Log log = LoggerFactory.make();
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> values;
    private final int hashCode;

    AnnotationProxy(AnnotationDescriptor<?> descriptor) {
        this.annotationType = descriptor.type();
        this.values = Collections.unmodifiableMap(this.getAnnotationValues(descriptor));
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.values.containsKey(method.getName())) {
            return this.values.get(method.getName());
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.annotationType.isInstance(obj)) {
            return false;
        }
        Annotation other = this.annotationType.cast(obj);
        for (Map.Entry<String, Object> member : this.values.entrySet()) {
            Object otherValue;
            Object value2 = member.getValue();
            if (this.areEqual(value2, otherValue = this.getAnnotationMemberValue(other, member.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('@').append(this.annotationType.getName()).append('(');
        for (String s2 : this.getRegisteredMethodsInAlphabeticalOrder()) {
            result2.append(s2).append('=').append(this.values.get(s2)).append(", ");
        }
        if (this.values.size() > 0) {
            result2.delete(result2.length() - 2, result2.length());
            result2.append(")");
        } else {
            result2.delete(result2.length() - 1, result2.length());
        }
        return result2.toString();
    }

    private Map<String, Object> getAnnotationValues(AnnotationDescriptor<?> descriptor) {
        Method[] declaredMethods;
        HashMap<String, Object> result2 = CollectionHelper.newHashMap();
        int processedValuesFromDescriptor = 0;
        for (Method m : declaredMethods = this.run(GetDeclaredMethods.action(this.annotationType))) {
            if (descriptor.containsElement(m.getName())) {
                result2.put(m.getName(), descriptor.valueOf(m.getName()));
                ++processedValuesFromDescriptor;
                continue;
            }
            if (m.getDefaultValue() != null) {
                result2.put(m.getName(), m.getDefaultValue());
                continue;
            }
            throw log.getNoValueProvidedForAnnotationParameterException(m.getName(), this.annotationType.getSimpleName());
        }
        if (processedValuesFromDescriptor != descriptor.numberOfElements()) {
            Set<String> unknownParameters = descriptor.getElements().keySet();
            unknownParameters.removeAll(result2.keySet());
            throw log.getTryingToInstantiateAnnotationWithUnknownParametersException(this.annotationType, unknownParameters);
        }
        return result2;
    }

    private int calculateHashCode() {
        int hashCode = 0;
        for (Map.Entry<String, Object> member : this.values.entrySet()) {
            Object value2 = member.getValue();
            int nameHashCode = member.getKey().hashCode();
            int valueHashCode = !value2.getClass().isArray() ? value2.hashCode() : (value2.getClass() == boolean[].class ? Arrays.hashCode((boolean[])value2) : (value2.getClass() == byte[].class ? Arrays.hashCode((byte[])value2) : (value2.getClass() == char[].class ? Arrays.hashCode((char[])value2) : (value2.getClass() == double[].class ? Arrays.hashCode((double[])value2) : (value2.getClass() == float[].class ? Arrays.hashCode((float[])value2) : (value2.getClass() == int[].class ? Arrays.hashCode((int[])value2) : (value2.getClass() == long[].class ? Arrays.hashCode((long[])value2) : (value2.getClass() == short[].class ? Arrays.hashCode((short[])value2) : Arrays.hashCode((Object[])value2)))))))));
            hashCode += 127 * nameHashCode ^ valueHashCode;
        }
        return hashCode;
    }

    private SortedSet<String> getRegisteredMethodsInAlphabeticalOrder() {
        TreeSet<String> result2 = new TreeSet<String>();
        result2.addAll(this.values.keySet());
        return result2;
    }

    private boolean areEqual(Object o1, Object o2) {
        return !o1.getClass().isArray() ? o1.equals(o2) : (o1.getClass() == boolean[].class ? Arrays.equals((boolean[])o1, (boolean[])o2) : (o1.getClass() == byte[].class ? Arrays.equals((byte[])o1, (byte[])o2) : (o1.getClass() == char[].class ? Arrays.equals((char[])o1, (char[])o2) : (o1.getClass() == double[].class ? Arrays.equals((double[])o1, (double[])o2) : (o1.getClass() == float[].class ? Arrays.equals((float[])o1, (float[])o2) : (o1.getClass() == int[].class ? Arrays.equals((int[])o1, (int[])o2) : (o1.getClass() == long[].class ? Arrays.equals((long[])o1, (long[])o2) : (o1.getClass() == short[].class ? Arrays.equals((short[])o1, (short[])o2) : Arrays.equals((Object[])o1, (Object[])o2)))))))));
    }

    private Object getAnnotationMemberValue(Annotation annotation, String name) {
        try {
            return this.run(GetDeclaredMethod.action(annotation.annotationType(), name, new Class[0])).invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw log.getUnableToRetrieveAnnotationParameterValueException(e);
        }
        catch (IllegalArgumentException e) {
            throw log.getUnableToRetrieveAnnotationParameterValueException(e);
        }
        catch (InvocationTargetException e) {
            throw log.getUnableToRetrieveAnnotationParameterValueException(e);
        }
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

