/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.List;

public final class ModUtil {
    private ModUtil() {
    }

    public static int calculateLuhnMod10Check(List<Integer> digits) {
        int sum2 = 0;
        boolean even = true;
        for (int index2 = digits.size() - 1; index2 >= 0; --index2) {
            int digit2 = digits.get(index2);
            if (even) {
                digit2 <<= 1;
            }
            if (digit2 > 9) {
                digit2 -= 9;
            }
            sum2 += digit2;
            even = !even;
        }
        return (10 - sum2 % 10) % 10;
    }

    public static int calculateMod10Check(List<Integer> digits, int multiplier, int weight) {
        int sum2 = 0;
        boolean even = true;
        for (int index2 = digits.size() - 1; index2 >= 0; --index2) {
            int digit2 = digits.get(index2);
            digit2 = even ? (digit2 *= multiplier) : (digit2 *= weight);
            sum2 += digit2;
            even = !even;
        }
        return (10 - sum2 % 10) % 10;
    }

    public static int calculateMod11Check(List<Integer> digits, int threshold) {
        int sum2 = 0;
        int multiplier = 2;
        for (int index2 = digits.size() - 1; index2 >= 0; --index2) {
            sum2 += digits.get(index2) * multiplier++;
            if (multiplier <= threshold) continue;
            multiplier = 2;
        }
        return 11 - sum2 % 11;
    }

    public static int calculateMod11Check(List<Integer> digits) {
        return ModUtil.calculateMod11Check(digits, Integer.MAX_VALUE);
    }
}

