/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class NodeImpl
implements Path.PropertyNode,
Path.MethodNode,
Path.ConstructorNode,
Path.BeanNode,
Path.ParameterNode,
Path.ReturnValueNode,
Path.CrossParameterNode,
Serializable {
    private static final long serialVersionUID = 2075466571633860499L;
    private static final Log log = LoggerFactory.make();
    private static final String INDEX_OPEN = "[";
    private static final String INDEX_CLOSE = "]";
    private static final String RETURN_VALUE_NODE_NAME = "<return value>";
    private static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";
    private final String name;
    private final NodeImpl parent;
    private final boolean isIterable;
    private final Integer index;
    private final Object key;
    private final ElementKind kind;
    private final int hashCode;
    private final List<Class<?>> parameterTypes;
    private final Integer parameterIndex;
    private String asString;

    private NodeImpl(String name, NodeImpl parent, boolean indexable, Integer index2, Object key, ElementKind kind, List<Class<?>> parameterTypes, Integer parameterIndex) {
        this.name = name;
        this.parent = parent;
        this.index = index2;
        this.key = key;
        this.isIterable = indexable;
        this.kind = kind;
        this.parameterTypes = parameterTypes;
        this.parameterIndex = parameterIndex;
        this.hashCode = this.buildHashCode();
    }

    public static NodeImpl createPropertyNode(String name, NodeImpl parent) {
        return new NodeImpl(name, parent, false, null, null, ElementKind.PROPERTY, Collections.<Class<?>>emptyList(), null);
    }

    public static NodeImpl createParameterNode(String name, NodeImpl parent, int parameterIndex) {
        return new NodeImpl(name, parent, false, null, null, ElementKind.PARAMETER, Collections.<Class<?>>emptyList(), parameterIndex);
    }

    public static NodeImpl createCrossParameterNode(NodeImpl parent) {
        return new NodeImpl(CROSS_PARAMETER_NODE_NAME, parent, false, null, null, ElementKind.CROSS_PARAMETER, Collections.<Class<?>>emptyList(), null);
    }

    public static NodeImpl createMethodNode(String name, NodeImpl parent, List<Class<?>> parameterTypes) {
        return new NodeImpl(name, parent, false, null, null, ElementKind.METHOD, parameterTypes, null);
    }

    public static NodeImpl createConstructorNode(String name, NodeImpl parent, List<Class<?>> parameterTypes) {
        return new NodeImpl(name, parent, false, null, null, ElementKind.CONSTRUCTOR, parameterTypes, null);
    }

    public static NodeImpl createBeanNode(NodeImpl parent) {
        return new NodeImpl(null, parent, false, null, null, ElementKind.BEAN, Collections.<Class<?>>emptyList(), null);
    }

    public static NodeImpl createReturnValue(NodeImpl parent) {
        return new NodeImpl(RETURN_VALUE_NODE_NAME, parent, false, null, null, ElementKind.RETURN_VALUE, Collections.<Class<?>>emptyList(), null);
    }

    public static NodeImpl makeIterable(NodeImpl node) {
        return new NodeImpl(node.name, node.parent, true, null, null, node.kind, node.parameterTypes, node.parameterIndex);
    }

    public static NodeImpl setIndex(NodeImpl node, Integer index2) {
        return new NodeImpl(node.name, node.parent, true, index2, null, node.kind, node.parameterTypes, node.parameterIndex);
    }

    public static NodeImpl setMapKey(NodeImpl node, Object key) {
        return new NodeImpl(node.name, node.parent, true, null, key, node.kind, node.parameterTypes, node.parameterIndex);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isInIterable() {
        return this.parent != null && this.parent.isIterable();
    }

    public final boolean isIterable() {
        return this.isIterable;
    }

    @Override
    public final Integer getIndex() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.index;
    }

    @Override
    public final Object getKey() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.key;
    }

    public final NodeImpl getParent() {
        return this.parent;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    @Override
    public <T extends Path.Node> T as(Class<T> nodeType) {
        if (this.kind == ElementKind.BEAN && nodeType == Path.BeanNode.class || this.kind == ElementKind.CONSTRUCTOR && nodeType == Path.ConstructorNode.class || this.kind == ElementKind.CROSS_PARAMETER && nodeType == Path.CrossParameterNode.class || this.kind == ElementKind.METHOD && nodeType == Path.MethodNode.class || this.kind == ElementKind.PARAMETER && nodeType == Path.ParameterNode.class || this.kind == ElementKind.PROPERTY && nodeType == Path.PropertyNode.class || this.kind == ElementKind.RETURN_VALUE && nodeType == Path.ReturnValueNode.class) {
            return (T)((Path.Node)nodeType.cast(this));
        }
        throw log.getUnableToNarrowNodeTypeException(this.getClass().getName(), this.kind, nodeType.getName());
    }

    @Override
    public List<Class<?>> getParameterTypes() {
        return new ArrayList(this.parameterTypes);
    }

    @Override
    public int getParameterIndex() {
        Contracts.assertTrue(this.kind == ElementKind.PARAMETER, "getParameterIndex() may only be invoked for nodes of ElementKind.PARAMETER.");
        return this.parameterIndex;
    }

    public String toString() {
        return this.asString();
    }

    public final String asString() {
        if (this.asString == null) {
            this.asString = this.buildToString();
        }
        return this.asString;
    }

    private String buildToString() {
        StringBuilder builder = new StringBuilder();
        if (ElementKind.BEAN.equals((Object)this.getKind())) {
            builder.append("");
        } else {
            builder.append(this.getName());
        }
        if (this.isIterable()) {
            builder.append(INDEX_OPEN);
            if (this.index != null) {
                builder.append(this.index);
            } else if (this.key != null) {
                builder.append(this.key);
            }
            builder.append(INDEX_CLOSE);
        }
        return builder.toString();
    }

    public int buildHashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.index == null ? 0 : this.index.hashCode());
        result2 = 31 * result2 + (this.isIterable ? 1231 : 1237);
        result2 = 31 * result2 + (this.key == null ? 0 : this.key.hashCode());
        result2 = 31 * result2 + (this.kind == null ? 0 : this.kind.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
        result2 = 31 * result2 + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        result2 = 31 * result2 + (this.parent == null ? 0 : this.parent.hashCode());
        return result2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeImpl other = (NodeImpl)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.isIterable != other.isIterable) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex)) {
            return false;
        }
        if (this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

