/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class ModCheckBase {
    private static final Log log = LoggerFactory.make();
    private static final Pattern NUMBERS_ONLY_REGEXP = Pattern.compile("[^0-9]");
    private static final int DEC_RADIX = 10;
    private int startIndex;
    private int endIndex;
    private int checkDigitIndex;
    private boolean ignoreNonDigitCharacters;

    public boolean isValid(CharSequence value2, ConstraintValidatorContext context) {
        List<Integer> digits;
        char checkDigit;
        String digitsAsString;
        if (value2 == null) {
            return true;
        }
        String valueAsString = value2.toString();
        try {
            digitsAsString = this.extractVerificationString(valueAsString);
            checkDigit = this.extractCheckDigit(valueAsString);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        digitsAsString = this.stripNonDigitsIfRequired(digitsAsString);
        try {
            digits = this.extractDigits(digitsAsString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return this.isCheckDigitValid(digits, checkDigit);
    }

    public abstract boolean isCheckDigitValid(List<Integer> var1, char var2);

    protected void initialize(int startIndex, int endIndex, int checkDigitIndex, boolean ignoreNonDigitCharacters) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.checkDigitIndex = checkDigitIndex;
        this.ignoreNonDigitCharacters = ignoreNonDigitCharacters;
        this.validateOptions();
    }

    protected int extractDigit(char value2) throws NumberFormatException {
        if (Character.isDigit(value2)) {
            return Character.digit(value2, 10);
        }
        throw log.getCharacterIsNotADigitException(value2);
    }

    private List<Integer> extractDigits(String value2) throws NumberFormatException {
        char[] chars;
        ArrayList<Integer> digits = new ArrayList<Integer>(value2.length());
        for (char c : chars = value2.toCharArray()) {
            digits.add(this.extractDigit(c));
        }
        return digits;
    }

    private boolean validateOptions() {
        if (this.startIndex < 0) {
            throw log.getStartIndexCannotBeNegativeException(this.startIndex);
        }
        if (this.endIndex < 0) {
            throw log.getEndIndexCannotBeNegativeException(this.endIndex);
        }
        if (this.startIndex > this.endIndex) {
            throw log.getInvalidRangeException(this.startIndex, this.endIndex);
        }
        if (this.checkDigitIndex > 0 && this.startIndex <= this.checkDigitIndex && this.endIndex > this.checkDigitIndex) {
            throw log.getInvalidCheckDigitException(this.startIndex, this.endIndex);
        }
        return true;
    }

    private String stripNonDigitsIfRequired(String value2) {
        if (this.ignoreNonDigitCharacters) {
            return NUMBERS_ONLY_REGEXP.matcher(value2).replaceAll("");
        }
        return value2;
    }

    private String extractVerificationString(String value2) throws IndexOutOfBoundsException {
        if (this.endIndex == Integer.MAX_VALUE) {
            return value2.substring(0, value2.length() - 1);
        }
        if (this.checkDigitIndex == -1) {
            return value2.substring(this.startIndex, this.endIndex);
        }
        return value2.substring(this.startIndex, this.endIndex + 1);
    }

    private char extractCheckDigit(String value2) throws IndexOutOfBoundsException {
        if (this.checkDigitIndex == -1) {
            if (this.endIndex == Integer.MAX_VALUE) {
                return value2.charAt(value2.length() - 1);
            }
            return value2.charAt(this.endIndex);
        }
        return value2.charAt(this.checkDigitIndex);
    }
}

