/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring.scope;

import javax.ws.rs.container.ContainerRequestContext;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;

class JaxrsRequestAttributes
extends AbstractRequestAttributes {
    private final ContainerRequestContext requestContext;

    public JaxrsRequestAttributes(ContainerRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    protected void updateAccessedSessionAttributes() {
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.requestContext.getProperty(name);
    }

    @Override
    public void setAttribute(String name, Object value2, int scope) {
        this.requestContext.setProperty(name, value2);
    }

    @Override
    public void removeAttribute(String name, int scope) {
        this.requestContext.removeProperty(name);
    }

    @Override
    public String[] getAttributeNames(int scope) {
        if (!this.isRequestActive()) {
            throw new IllegalStateException(LocalizationMessages.NOT_IN_REQUEST_SCOPE());
        }
        return StringUtils.toStringArray(this.requestContext.getPropertyNames());
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        this.registerRequestDestructionCallback(name, callback);
    }

    @Override
    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.requestContext;
        }
        return null;
    }

    @Override
    public String getSessionId() {
        return null;
    }

    @Override
    public Object getSessionMutex() {
        return null;
    }
}

