/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.HashBasedTable;
import jersey.repackaged.com.google.common.collect.HashMultimap;
import jersey.repackaged.com.google.common.collect.Maps;
import jersey.repackaged.com.google.common.collect.Sets;
import jersey.repackaged.com.google.common.collect.Table;
import org.glassfish.jersey.message.filtering.spi.EntityGraph;
import org.glassfish.jersey.message.filtering.spi.ScopeProvider;

final class EntityGraphImpl
implements EntityGraph {
    private final Class<?> entityClass;
    private final Set<String> globalScopes;
    private final Set<String> localScopes;
    private final HashMultimap<String, String> fields;
    private final Table<String, String, Class<?>> subgraphs;

    public EntityGraphImpl(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.fields = HashMultimap.create();
        this.subgraphs = HashBasedTable.create();
        this.globalScopes = Sets.newHashSet();
        this.localScopes = Sets.newHashSet();
    }

    @Override
    public EntityGraphImpl addField(String fieldName) {
        return this.addField(fieldName, (Set)this.globalScopes);
    }

    @Override
    public EntityGraphImpl addField(String fieldName, String ... filteringScopes) {
        return this.addField(fieldName, Sets.newHashSet(filteringScopes));
    }

    @Override
    public EntityGraphImpl addField(String fieldName, Set<String> filteringScopes) {
        for (String filteringScope : filteringScopes) {
            this.createFilteringScope(filteringScope);
            this.fields.get((Object)filteringScope).add(fieldName);
        }
        return this;
    }

    @Override
    public EntityGraphImpl addFilteringScopes(Set<String> filteringScopes) {
        this.globalScopes.addAll(filteringScopes);
        return this;
    }

    @Override
    public EntityGraphImpl addSubgraph(String fieldName, Class<?> fieldClass) {
        return this.addSubgraph(fieldName, (Class)fieldClass, (Set)this.globalScopes);
    }

    @Override
    public EntityGraphImpl addSubgraph(String fieldName, Class<?> fieldClass, String ... filteringScopes) {
        return this.addSubgraph(fieldName, (Class)fieldClass, Sets.newHashSet(filteringScopes));
    }

    @Override
    public EntityGraphImpl addSubgraph(String fieldName, Class<?> fieldClass, Set<String> filteringScopes) {
        for (String filteringScope : filteringScopes) {
            this.createFilteringScope(filteringScope);
            this.subgraphs.put(filteringScope, fieldName, fieldClass);
        }
        return this;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Set<String> getFields(String filteringScope) {
        return this.fields.containsKey(filteringScope) ? Collections.unmodifiableSet(this.fields.get((Object)filteringScope)) : Collections.emptySet();
    }

    @Override
    public Set<String> getFields(String ... filteringScopes) {
        return filteringScopes.length == 0 ? Collections.emptySet() : (filteringScopes.length == 1 ? this.getFields(filteringScopes[0]) : this.getFields(Sets.newHashSet(filteringScopes)));
    }

    @Override
    public Set<String> getFields(Set<String> filteringScopes) {
        HashSet<String> matched = Sets.newHashSet();
        for (String filteringContext : filteringScopes) {
            matched.addAll(this.fields.get((Object)filteringContext));
        }
        return matched;
    }

    @Override
    public Set<String> getFilteringScopes() {
        return Collections.unmodifiableSet(Sets.union(this.globalScopes, this.localScopes));
    }

    @Override
    public Set<String> getClassFilteringScopes() {
        return Collections.unmodifiableSet(this.globalScopes);
    }

    @Override
    public Map<String, Class<?>> getSubgraphs(String filteringScope) {
        return this.subgraphs.containsRow(filteringScope) ? Collections.unmodifiableMap(this.subgraphs.row(filteringScope)) : Collections.emptyMap();
    }

    @Override
    public Map<String, Class<?>> getSubgraphs(String ... filteringScopes) {
        return filteringScopes.length == 0 ? Collections.emptyMap() : (filteringScopes.length == 1 ? this.getSubgraphs(filteringScopes[0]) : this.getSubgraphs(Sets.newHashSet(filteringScopes)));
    }

    @Override
    public Map<String, Class<?>> getSubgraphs(Set<String> filteringScopes) {
        HashMap<String, Class<?>> matched = Maps.newHashMap();
        for (String filteringContext : filteringScopes) {
            matched.putAll(this.subgraphs.row(filteringContext));
        }
        return matched;
    }

    @Override
    public boolean presentInScopes(String name) {
        return this.fields.containsValue(name) || this.subgraphs.containsColumn(name);
    }

    @Override
    public boolean presentInScope(String field2, String filteringScope) {
        return this.fields.containsEntry(filteringScope, field2) || this.subgraphs.contains(filteringScope, field2);
    }

    @Override
    public EntityGraphImpl remove(String fieldName) {
        for (String scope : this.getFilteringScopes()) {
            if (this.fields.containsEntry(scope, fieldName)) {
                this.fields.remove(scope, fieldName);
            }
            if (!this.subgraphs.containsColumn(fieldName)) continue;
            this.subgraphs.remove(scope, fieldName);
        }
        return this;
    }

    private void createFilteringScope(String filteringScope) {
        if (!this.getFilteringScopes().contains(filteringScope)) {
            if (this.localScopes.contains(ScopeProvider.DEFAULT_SCOPE)) {
                this.fields.putAll((Object)filteringScope, (Iterable)this.fields.get((Object)ScopeProvider.DEFAULT_SCOPE));
                Map<String, Class<?>> row = this.subgraphs.row(ScopeProvider.DEFAULT_SCOPE);
                for (Map.Entry<String, Class<?>> entry2 : row.entrySet()) {
                    this.subgraphs.put(filteringScope, entry2.getKey(), entry2.getValue());
                }
            }
            this.localScopes.add(filteringScope);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityGraphImpl that = (EntityGraphImpl)o;
        return this.entityClass.equals(that.entityClass) && this.fields.equals(that.fields) && this.globalScopes.equals(that.globalScopes) && this.localScopes.equals(that.localScopes) && this.subgraphs.equals(that.subgraphs);
    }

    public int hashCode() {
        int result2 = this.entityClass.hashCode();
        result2 = 53 * result2 + this.globalScopes.hashCode();
        result2 = 53 * result2 + this.localScopes.hashCode();
        result2 = 53 * result2 + this.fields.hashCode();
        result2 = 53 * result2 + this.subgraphs.hashCode();
        return result2;
    }
}

