/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class AccessPlatform
extends DatabasePlatform {
    @Override
    protected Map<String, Class> buildClassTypes() {
        Map<String, Class> classTypeMapping = super.buildClassTypes();
        classTypeMapping.put("LONG", Long.class);
        classTypeMapping.put("TEXT", String.class);
        return classTypeMapping;
    }

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("LONG", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SHORT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("BYTE", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("TEXT", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("TEXT", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("LONGBINARY", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("MEMO", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("LONGBINARY", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("MEMO", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("LONGBINARY", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("MEMO", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("DATETIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("DATETIME", false));
        return fieldTypeMapping;
    }

    @Override
    public int getMaxFieldNameSize() {
        return 64;
    }

    @Override
    public Timestamp getTimestampFromServer(AbstractSession session, String sessionName) {
        if (this.getTimestampQuery() == null) {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            currentTime.setNanos(0);
            return currentTime;
        }
        this.getTimestampQuery().setSessionName(sessionName);
        return (Timestamp)session.executeQuery(this.getTimestampQuery());
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
    }

    @Override
    public boolean isAccess() {
        return true;
    }

    @Override
    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MAX_VALUE);
        values.put(Long.class, Long.MAX_VALUE);
        values.put(Double.class, Double.MAX_VALUE);
        values.put(Short.class, (short)Short.MAX_VALUE);
        values.put(Byte.class, (byte)127);
        values.put(Float.class, Float.valueOf(1.2345679E8f));
        values.put(BigInteger.class, new BigInteger("999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("99999999999999999999.9999999999999999999"));
        return values;
    }

    @Override
    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, Integer.MIN_VALUE);
        values.put(Long.class, Long.MIN_VALUE);
        values.put(Double.class, Double.MIN_VALUE);
        values.put(Short.class, (short)Short.MIN_VALUE);
        values.put(Byte.class, (byte)-128);
        values.put(Float.class, Float.valueOf(-1.2345679E8f));
        values.put(BigInteger.class, new BigInteger("-999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return values;
    }

    @Override
    public boolean requiresNamedPrimaryKeyConstraints() {
        return true;
    }

    @Override
    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    @Override
    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("SELECT @@IDENTITY");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    @Override
    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" COUNTER");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public void printFieldTypeSize(Writer writer, FieldDefinition field2, FieldTypeDefinition fieldType, boolean shouldPrintFieldIdentityClause) throws IOException {
        if (!shouldPrintFieldIdentityClause) {
            super.printFieldTypeSize(writer, field2, fieldType, shouldPrintFieldIdentityClause);
        }
    }

    @Override
    public void printFieldUnique(Writer writer, boolean shouldPrintFieldIdentityClause) throws IOException {
        if (!shouldPrintFieldIdentityClause) {
            super.printFieldUnique(writer, shouldPrintFieldIdentityClause);
        }
    }
}

