/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements DirectCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLRecord>,
XMLMapping,
XMLNillableMapping {
    private boolean isCDATA;
    private boolean isDefaultEmptyContainer = true;
    private boolean isWriteOnly;
    private AbstractNullPolicy nullPolicy = new NullPolicy();
    protected boolean reuseContainer;
    private boolean isCollapsingStringValues;
    private boolean isNormalizingStringValues;
    private AbstractNullPolicy wrapperNullPolicy;
    protected transient Object nullValue;

    public XMLCompositeDirectCollectionMapping() {
        this.nullPolicy.setNullRepresentedByEmptyNode(true);
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        CoreContainerPolicy cp;
        super.initialize(session);
        if (this.getField() instanceof XMLField) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                TypeConversionConverter converter = (TypeConversionConverter)this.valueConverter;
                ((DatabaseField)this.getField()).setType(converter.getObjectClass());
            }
            String xpathString = ((XMLField)this.getField()).getXPath();
            if (this.isAbstractCompositeDirectCollectionMapping() && xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
                throw DescriptorException.invalidXpathForXMLDirectMapping(this);
            }
        }
        if ((cp = this.getContainerPolicy()) != null && ((ContainerPolicy)cp).getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(((ContainerPolicy)cp).getContainerClassName());
            ((ContainerPolicy)cp).setContainerClass(cls);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    @Override
    public void setXPath(String xpathString) {
        if (xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
            xpathString = String.valueOf(xpathString) + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        CoreContainerPolicy cp = this.getContainerPolicy();
        DOMRecord domRecord = (DOMRecord)row;
        Object fieldValue = domRecord.getValues((DatabaseField)this.getField(), this.getNullPolicy());
        if (fieldValue == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Vector fieldValues = ((ClassDescriptor)this.getDescriptor()).buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Object result2 = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
            result2 = container != null ? container : ((ContainerPolicy)cp).containerInstance();
        } else {
            result2 = ((ContainerPolicy)cp).containerInstance(fieldValues.size());
        }
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if ((element = this.convertDataValueToObjectValue(element, executionSession, ((XMLRecord)row).getUnmarshaller())) != null && element.getClass() == ClassConstants.STRING) {
                if (this.isCollapsingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().collapseStringValue((String)element);
                } else if (this.isNormalizingStringValues) {
                    element = XMLConversionManager.getDefaultXMLManager().normalizeStringValue((String)element);
                }
            }
            ((ContainerPolicy)cp).addInto(element, result2, sourceQuery.getSession());
        }
        return result2;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put((DatabaseField)this.getField(), (Object)null);
            return;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(((ContainerPolicy)cp).sizeFor(attributeValue));
        Object iter2 = ((ContainerPolicy)cp).iteratorFor(attributeValue);
        if (iter2 != null) {
            while (((ContainerPolicy)cp).hasNext(iter2)) {
                Object element = ((ContainerPolicy)cp).next(iter2, session);
                if ((element = this.convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller())) != null) {
                    elements.addElement(element);
                    continue;
                }
                if (this.usesSingleNode()) continue;
                AbstractNullPolicy nullPolicy = this.getNullPolicy();
                if (nullPolicy == null) {
                    elements.addElement(null);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    elements.addElement(XMLRecord.NIL);
                    continue;
                }
                if (nullPolicy.getMarshalNullRepresentation() == XMLNullRepresentationType.ABSENT_NODE) continue;
                elements.addElement("");
            }
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = ((ClassDescriptor)this.getDescriptor()).buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put((DatabaseField)this.getField(), fieldValue);
    }

    @Override
    public void writeSingleValue(Object value2, Object parent, XMLRecord record, AbstractSession session) {
        Object element = this.convertObjectValueToDataValue(value2, session, record.getMarshaller());
        record.add((DatabaseField)this.getField(), element);
    }

    @Override
    public void setIsCDATA(boolean CDATA) {
        this.isCDATA = CDATA;
    }

    @Override
    public boolean isCDATA() {
        return this.isCDATA;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value2);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    @Override
    public void setNullPolicy(AbstractNullPolicy value2) {
        this.nullPolicy = value2;
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public boolean isNormalizingStringValues() {
        return this.isNormalizingStringValues;
    }

    @Override
    public void setNormalizingStringValues(boolean normalize) {
        this.isNormalizingStringValues = normalize;
    }

    @Override
    public void setCollapsingStringValues(boolean collapse) {
        this.isCollapsingStringValues = collapse;
    }

    @Override
    public boolean isCollapsingStringValues() {
        return this.isCollapsingStringValues;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.isDefaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.isDefaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value2, Session session, XMLMarshaller marshaller) {
        if (this.hasValueConverter()) {
            if (this.valueConverter instanceof XMLConverter) {
                return ((XMLConverter)this.valueConverter).convertObjectValueToDataValue(value2, session, marshaller);
            }
            return this.valueConverter.convertObjectValueToDataValue(value2, session);
        }
        return value2;
    }

    @Override
    public Object convertDataValueToObjectValue(Object value2, Session session, XMLUnmarshaller unmarshaller) {
        if (this.hasValueConverter()) {
            if (this.valueConverter instanceof XMLConverter) {
                return ((XMLConverter)this.valueConverter).convertDataValueToObjectValue(value2, session, unmarshaller);
            }
            return this.valueConverter.convertDataValueToObjectValue(value2, session);
        }
        return value2;
    }

    @Override
    public Object getNullValue() {
        return this.nullValue;
    }

    @Override
    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }
}

