/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class RelationTableMechanism
implements Cloneable,
Serializable {
    protected DatabaseTable relationTable;
    protected Vector<DatabaseField> sourceKeyFields;
    protected Vector<DatabaseField> targetKeyFields;
    protected Vector<DatabaseField> sourceRelationKeyFields;
    protected Vector<DatabaseField> targetRelationKeyFields;
    protected DataModifyQuery deleteQuery;
    protected boolean hasCustomDeleteQuery = false;
    protected DataModifyQuery insertQuery = new DataModifyQuery();
    protected boolean hasCustomInsertQuery = false;
    protected ReadQuery lockRelationTableQuery;

    public RelationTableMechanism() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetKeyFields = NonSynchronizedVector.newInstance(1);
    }

    public void addSourceRelationKeyField(DatabaseField sourceRelationKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceRelationKeyFields().addElement(sourceRelationKeyField);
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
    }

    public void addSourceRelationKeyFieldName(String sourceRelationKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addSourceRelationKeyField(new DatabaseField(sourceRelationKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    public void addTargetRelationKeyField(DatabaseField targetRelationKeyField, DatabaseField targetPrimaryKeyField) {
        this.getTargetRelationKeyFields().addElement(targetRelationKeyField);
        this.getTargetKeyFields().addElement(targetPrimaryKeyField);
    }

    public void addTargetRelationKeyFieldName(String targetRelationKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addTargetRelationKeyField(new DatabaseField(targetRelationKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    Expression buildSelectionCriteria(ForeignReferenceMapping mapping, Expression criteria) {
        return this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, criteria, true, false);
    }

    Expression buildSelectionCriteriaAndAddFieldsToQuery(ForeignReferenceMapping mapping, Expression criteria) {
        return this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, criteria, true, true);
    }

    public Expression buildSelectionCriteriaAndAddFieldsToQueryInternal(ForeignReferenceMapping mapping, Expression criteria, boolean shouldAddTargetFields, boolean shouldAddFieldsToQuery) {
        Expression expression;
        DatabaseField relationKey;
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression linkTable = ((Expression)builder).getTable(this.relationTable);
        if (shouldAddTargetFields) {
            Iterator<DatabaseField> targetKeyIterator = this.getTargetKeyFields().iterator();
            Iterator<DatabaseField> relationKeyIterator = this.getTargetRelationKeyFields().iterator();
            while (targetKeyIterator.hasNext()) {
                relationKey = relationKeyIterator.next();
                DatabaseField targetKey = targetKeyIterator.next();
                expression = ((Expression)builder).getField(targetKey).equal(linkTable.getField(relationKey));
                criteria = criteria == null ? expression : expression.and(criteria);
            }
        }
        Iterator<DatabaseField> relationKeyIterator = this.getSourceRelationKeyFields().iterator();
        Iterator<DatabaseField> sourceKeyIterator = this.getSourceKeyFields().iterator();
        while (relationKeyIterator.hasNext()) {
            relationKey = relationKeyIterator.next();
            DatabaseField sourceKey = sourceKeyIterator.next();
            expression = linkTable.getField(relationKey).equal(builder.getParameter(sourceKey));
            criteria = criteria == null ? expression : expression.and(criteria);
        }
        if (shouldAddFieldsToQuery && mapping.isCollectionMapping()) {
            ((CollectionMapping)mapping).getContainerPolicy().addAdditionalFieldsToQuery(mapping.getSelectionQuery(), linkTable);
        }
        return criteria;
    }

    protected void collectQueryParameters(Set<DatabaseField> cacheFields) {
        for (DatabaseField field2 : this.getSourceKeyFields()) {
            cacheFields.add(field2);
        }
    }

    public Object clone() {
        RelationTableMechanism clone2;
        try {
            clone2 = (RelationTableMechanism)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        clone2.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        clone2.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone2.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        clone2.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        clone2.setInsertQuery((DataModifyQuery)this.insertQuery.clone());
        clone2.setDeleteQuery((DataModifyQuery)this.deleteQuery.clone());
        if (this.lockRelationTableQuery != null) {
            clone2.lockRelationTableQuery = (DirectReadQuery)this.lockRelationTableQuery.clone();
        }
        return clone2;
    }

    protected Vector cloneFields(Vector fields) {
        NonSynchronizedVector clonedFields = NonSynchronizedVector.newInstance();
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ((Vector)clonedFields).addElement(((DatabaseField)fieldsEnum.nextElement()).clone());
        }
        return clonedFields;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    ReadQuery getLockRelationTableQueryClone(AbstractSession session, short lockMode) {
        DirectReadQuery lockRelationTableQueryClone = (DirectReadQuery)this.lockRelationTableQuery.clone();
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.relationTable);
        statement.addField(this.sourceRelationKeyFields.get(0).clone());
        statement.setWhereClause((Expression)this.lockRelationTableQuery.getSelectionCriteria().clone());
        statement.setLockingClause(new ForUpdateClause(lockMode));
        statement.normalize(session, null);
        lockRelationTableQueryClone.setSQLStatement(statement);
        lockRelationTableQueryClone.setIsExecutionClone(true);
        return lockRelationTableQueryClone;
    }

    public void setRelationTableLockingClause(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        ForUpdateOfClause lockingClause = new ForUpdateOfClause();
        lockingClause.setLockMode(sourceQuery.getLockMode());
        FieldExpression exp = (FieldExpression)targetQuery.getExpressionBuilder().getTable(this.relationTable).getField(this.sourceRelationKeyFields.get(0));
        lockingClause.addLockedExpression(exp);
        targetQuery.setLockingClause(lockingClause);
        targetQuery.setShouldOuterJoinSubclasses(true);
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        Expression linkTable = builder.getTable(this.relationTable);
        Expression criteria = null;
        int size2 = this.targetRelationKeyFields.size();
        int index2 = 0;
        while (index2 < size2) {
            DatabaseField relationKey = this.targetRelationKeyFields.get(index2);
            DatabaseField targetKey = this.targetKeyFields.get(index2);
            criteria = builder.getField(targetKey).equal(linkTable.getField(relationKey)).and(criteria);
            ++index2;
        }
        size2 = this.sourceRelationKeyFields.size();
        if (size2 > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size2);
            for (DatabaseField sourceRelationKeyField : this.sourceRelationKeyFields) {
                fields.add(linkTable.getField(sourceRelationKeyField));
            }
            return criteria.and(query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields));
        }
        return criteria.and(query.getSession().getPlatform().buildBatchCriteria(builder, linkTable.getField(this.sourceRelationKeyFields.get(0))));
    }

    public void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        mappingBatchQuery.setShouldIncludeData(true);
        Expression linkTable = mappingBatchQuery.getExpressionBuilder().getTable(this.relationTable);
        for (DatabaseField relationField : this.sourceRelationKeyFields) {
            mappingBatchQuery.getAdditionalFields().add(linkTable.getField(relationField));
        }
    }

    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        Vector<DatabaseField> sourceKeyFields = this.sourceKeyFields;
        int size2 = sourceKeyFields.size();
        Object[] key = new Object[size2];
        int index2 = 0;
        while (index2 < size2) {
            DatabaseField field2 = (DatabaseField)sourceKeyFields.get(index2);
            Object value2 = row.get(field2);
            key[index2] = conversionManager.convertObject(value2, field2.getType());
            ++index2;
        }
        return new CacheId(key);
    }

    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        int size2 = this.getSourceRelationKeyFields().size();
        Object[] key = new Object[size2];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        int index2 = 0;
        while (index2 < size2) {
            DatabaseField relationField = this.sourceRelationKeyFields.get(index2);
            DatabaseField sourceField = this.sourceKeyFields.get(index2);
            Object value2 = row.get(relationField);
            key[index2] = value2 = conversionManager.convertObject(value2, sourceField.getType());
            ++index2;
        }
        return new CacheId(key);
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getSourceRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public Vector getTargetKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public DatabaseField getRelationFieldForTargetField(DatabaseField targetField) {
        int index2 = this.targetKeyFields.indexOf(targetField);
        if (index2 == -1) {
            return null;
        }
        return this.targetRelationKeyFields.get(index2);
    }

    public Vector<DatabaseField> getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public Vector getTargetRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    public boolean hasRelationTable() {
        return this.relationTable != null && this.relationTable.getName().length() > 0;
    }

    public void initialize(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        this.initializeRelationTable(session, mapping);
        this.initializeSourceRelationKeys(mapping);
        this.initializeTargetRelationKeys(mapping);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(mapping);
        } else {
            this.initializeSourceKeys(mapping);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(session, mapping);
        } else {
            this.initializeTargetKeys(session, mapping);
        }
        if (this.getRelationTable().getName().indexOf(32) != -1) {
            String beginQuote = ((DatasourcePlatform)session.getDatasourcePlatform()).getStartDelimiter();
            String endQuote = ((DatasourcePlatform)session.getDatasourcePlatform()).getEndDelimiter();
            if (this.getRelationTable().getName().indexOf(beginQuote) == -1) {
                this.getRelationTable().setName(String.valueOf(beginQuote) + this.getRelationTable().getName() + endQuote);
            }
        }
        if (mapping.isCollectionMapping()) {
            ((CollectionMapping)mapping).getContainerPolicy().initialize(session, this.getRelationTable());
        }
        this.initializeInsertQuery(session, mapping);
        this.initializeDeleteQuery(session, mapping);
        if (mapping.extendPessimisticLockScope != ForeignReferenceMapping.ExtendPessimisticLockScope.NONE) {
            this.initializeExtendPessipisticLockScope(session, mapping);
        }
    }

    protected void initializeDeleteQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        Expression expression;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.getDeleteQuery().getPartitioningPolicy() == null) {
            this.getDeleteQuery().setPartitioningPolicy(mapping.getPartitioningPolicy());
        }
        this.getInsertQuery().setName(mapping.getAttributeName());
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField relationKey : this.getSourceRelationKeyFields()) {
            expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
            whereClause = expression.and(whereClause);
        }
        if (mapping.isCollectionMapping()) {
            for (DatabaseField relationKey : this.getTargetRelationKeyFields()) {
                expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
                whereClause = expression.and(whereClause);
            }
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        statement.setTable(this.getRelationTable());
        statement.setWhereClause(whereClause);
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeExtendPessipisticLockScope(AbstractSession session, ForeignReferenceMapping mapping) {
        mapping.extendPessimisticLockScope = mapping.usesIndirection() ? (session.getPlatform().isForUpdateCompatibleWithDistinct() && session.getPlatform().supportsLockingQueriesWithMultipleTables() ? ForeignReferenceMapping.ExtendPessimisticLockScope.SOURCE_QUERY : ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY) : (session.getPlatform().supportsIndividualTableLocking() && session.getPlatform().supportsLockingQueriesWithMultipleTables() ? ForeignReferenceMapping.ExtendPessimisticLockScope.TARGET_QUERY : ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY);
        if (mapping.extendPessimisticLockScope == ForeignReferenceMapping.ExtendPessimisticLockScope.DEDICATED_QUERY) {
            Expression startCriteria = mapping.getSelectionQuery().getSelectionCriteria();
            if (startCriteria != null) {
                startCriteria = (Expression)startCriteria.clone();
            }
            this.initializeLockRelationTableQuery(session, mapping, startCriteria);
        }
    }

    protected void initializeInsertQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.getInsertQuery().getPartitioningPolicy() == null) {
            this.getInsertQuery().setPartitioningPolicy(mapping.getPartitioningPolicy());
        }
        this.getInsertQuery().setName(mapping.getAttributeName());
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getRelationTable());
        DatabaseRecord joinRow = new DatabaseRecord();
        for (DatabaseField field2 : this.getTargetRelationKeyFields()) {
            joinRow.put(field2, (Object)null);
        }
        for (DatabaseField field2 : this.getSourceRelationKeyFields()) {
            joinRow.put(field2, (Object)null);
        }
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            if (collectionMapping.getListOrderField() != null) {
                joinRow.put(collectionMapping.getListOrderField(), (Object)null);
            }
            collectionMapping.getContainerPolicy().addFieldsForMapKey(joinRow);
        }
        statement.setModifyRow(joinRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(joinRow);
    }

    protected void initializeLockRelationTableQuery(AbstractSession session, ForeignReferenceMapping mapping, Expression startCriteria) {
        this.lockRelationTableQuery = new DirectReadQuery();
        Expression criteria = this.buildSelectionCriteriaAndAddFieldsToQueryInternal(mapping, startCriteria, false, false);
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.relationTable);
        statement.addField(this.sourceRelationKeyFields.get(0).clone());
        statement.setWhereClause(criteria);
        statement.normalize(session, null);
        this.lockRelationTableQuery.setSQLStatement(statement);
        this.lockRelationTableQuery.setSessionName(session.getName());
    }

    protected void initializeRelationTable(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (mapping.isReadOnly() && mapping.getReferenceDescriptor().hasTablePerMultitenantPolicy()) {
            this.setRelationTable(((TablePerMultitenantPolicy)mapping.getReferenceDescriptor().getMultitenantPolicy()).getTable(this.getRelationTable()));
        }
        if (!this.hasRelationTable()) {
            throw DescriptorException.noRelationTable(mapping);
        }
        if (platform.getTableQualifier().length() > 0 && this.getRelationTable().getTableQualifier().length() == 0) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSourceKeys(ForeignReferenceMapping mapping) {
        int index2 = 0;
        while (index2 < this.getSourceKeyFields().size()) {
            DatabaseField field2 = mapping.getDescriptor().buildField(this.getSourceKeyFields().get(index2));
            if (mapping.usesIndirection()) {
                field2.setKeepInRow(true);
            }
            this.getSourceKeyFields().set(index2, field2);
            ++index2;
        }
    }

    protected void initializeSourceKeysWithDefaults(DatabaseMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getDescriptor().getPrimaryKeyFields();
        int index2 = 0;
        while (index2 < primaryKeyFields.size()) {
            DatabaseField field2 = primaryKeyFields.get(index2);
            if (((ForeignReferenceMapping)mapping).usesIndirection()) {
                field2.setKeepInRow(true);
            }
            this.getSourceKeyFields().addElement(field2);
            ++index2;
        }
    }

    protected void initializeSourceRelationKeys(ForeignReferenceMapping mapping) throws DescriptorException {
        if (this.getSourceRelationKeyFields().size() == 0) {
            throw DescriptorException.noSourceRelationKeysSpecified(mapping);
        }
        Enumeration<DatabaseField> entry2 = this.getSourceRelationKeyFields().elements();
        while (entry2.hasMoreElements()) {
            DatabaseField field2 = entry2.nextElement();
            ClassDescriptor sourceDescriptor = mapping.getDescriptor();
            if (sourceDescriptor.hasTablePerMultitenantPolicy()) {
                field2.setTable(((TablePerMultitenantPolicy)sourceDescriptor.getMultitenantPolicy()).getTable(field2.getTable()));
            }
            if (field2.hasTableName() && !field2.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field2, mapping);
            }
            field2.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(AbstractSession session, ForeignReferenceMapping mapping) {
        int index2 = 0;
        while (index2 < this.getTargetKeyFields().size()) {
            DatabaseField field2 = mapping.getReferenceDescriptor().buildField(this.getTargetKeyFields().get(index2));
            this.getTargetKeyFields().set(index2, field2);
            ++index2;
        }
    }

    protected void initializeTargetKeysWithDefaults(AbstractSession session, ForeignReferenceMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getReferenceDescriptor().getPrimaryKeyFields();
        int index2 = 0;
        while (index2 < primaryKeyFields.size()) {
            this.getTargetKeyFields().addElement(primaryKeyFields.get(index2));
            ++index2;
        }
    }

    protected void initializeTargetRelationKeys(ForeignReferenceMapping mapping) {
        if (this.getTargetRelationKeyFields().size() == 0) {
            throw DescriptorException.noTargetRelationKeysSpecified(mapping);
        }
        Enumeration<DatabaseField> targetEnum = this.getTargetRelationKeyFields().elements();
        while (targetEnum.hasMoreElements()) {
            DatabaseField field2 = targetEnum.nextElement();
            ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
            if (referenceDescriptor.hasTablePerMultitenantPolicy()) {
                field2.setTable(((TablePerMultitenantPolicy)referenceDescriptor.getMultitenantPolicy()).getTable(field2.getTable()));
            }
            if (field2.hasTableName() && !field2.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field2, mapping);
            }
            field2.setTable(this.getRelationTable());
        }
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    public Expression joinRelationTableField(Expression expression, Expression baseExpression) {
        return baseExpression.getField(this.sourceKeyFields.get(0)).equal(baseExpression.getTable(this.relationTable).getField(this.sourceRelationKeyFields.get(0))).and(expression);
    }

    public void setCustomDeleteQuery(DataModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteQuery(query);
    }

    protected void setHasCustomDeleteQuery(boolean hasCustomDeleteQuery) {
        this.hasCustomDeleteQuery = hasCustomDeleteQuery;
    }

    protected void setHasCustomInsertQuery(boolean bool2) {
        this.hasCustomInsertQuery = bool2;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomInsertQuery(query);
    }

    public void setRelationTable(DatabaseTable relationTable) {
        this.relationTable = relationTable;
    }

    public void setRelationTableName(String tableName) {
        this.relationTable = new DatabaseTable(tableName);
    }

    public void setSessionName(String name) {
        this.getInsertQuery().setSessionName(name);
        this.getDeleteQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setSourceRelationKeyFieldName(String sourceRelationKeyFieldName) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(sourceRelationKeyFieldName));
    }

    public void setSourceRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceRelationKeyFields(fields);
    }

    public void setSourceRelationKeyFields(Vector<DatabaseField> sourceRelationKeyFields) {
        this.sourceRelationKeyFields = sourceRelationKeyFields;
    }

    public void setTargetKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetKeyFields(fields);
    }

    public void setTargetKeyFields(Vector<DatabaseField> targetKeyFields) {
        this.targetKeyFields = targetKeyFields;
    }

    public void setTargetRelationKeyFieldName(String targetRelationKeyFieldName) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(targetRelationKeyFieldName));
    }

    public void setTargetRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetRelationKeyFields(fields);
    }

    public void setTargetRelationKeyFields(Vector<DatabaseField> targetRelationKeyFields) {
        this.targetRelationKeyFields = targetRelationKeyFields;
    }

    public AbstractRecord buildRelationTableSourceRow(Object sourceObject, AbstractSession session, ForeignReferenceMapping mapping) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceObject, session, databaseRow, mapping);
    }

    public AbstractRecord addRelationTableSourceRow(Object sourceObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getDescriptor().getObjectBuilder();
        int size2 = this.sourceKeyFields.size();
        int i = 0;
        while (i < size2) {
            Object sourceValue = builder.extractValueFromObjectForField(sourceObject, this.sourceKeyFields.get(i), session);
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
            ++i;
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceRow(AbstractRecord sourceRow) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceRow, databaseRow);
    }

    public AbstractRecord addRelationTableSourceRow(AbstractRecord sourceRow, AbstractRecord databaseRow) {
        int size2 = this.sourceKeyFields.size();
        int i = 0;
        while (i < size2) {
            Object sourceValue = sourceRow.get(this.sourceKeyFields.get(i));
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
            ++i;
        }
        return databaseRow;
    }

    public AbstractRecord addRelationTableTargetRow(Object targetObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
        int size2 = this.targetKeyFields.size();
        int i = 0;
        while (i < size2) {
            Object sourceValue = builder.extractValueFromObjectForField(targetObject, this.targetKeyFields.get(i), session);
            databaseRow.put(this.targetRelationKeyFields.get(i), sourceValue);
            ++i;
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(Object sourceObject, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceObject, session, mapping);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(AbstractRecord sourceRow, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceRow);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }
}

