/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.AttributeGroup;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Group;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class Schema {
    private String name;
    private List imports;
    private List includes;
    private String targetNamespace;
    private String defaultNamespace;
    private boolean elementFormDefault;
    private boolean attributeFormDefault;
    private Map topLevelSimpleTypes;
    private Map topLevelComplexTypes;
    private Map topLevelElements;
    private Map topLevelAttributes;
    private NamespaceResolver namespaceResolver = new NamespaceResolver();
    private Map attributesMap;
    private Map attributeGroups;
    private Map groups;
    private Annotation annotation;
    private Result result;

    public Schema() {
        this.imports = new ArrayList();
        this.includes = new ArrayList();
        this.topLevelSimpleTypes = new LinkedHashMap();
        this.topLevelComplexTypes = new LinkedHashMap();
        this.topLevelElements = new LinkedHashMap();
        this.topLevelAttributes = new LinkedHashMap();
        this.attributesMap = new LinkedHashMap();
        this.attributeGroups = new LinkedHashMap();
        this.groups = new LinkedHashMap();
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setTopLevelSimpleTypes(Map topLevelSimpleTypes) {
        this.topLevelSimpleTypes = topLevelSimpleTypes;
    }

    public Map getTopLevelSimpleTypes() {
        return this.topLevelSimpleTypes;
    }

    public void addTopLevelSimpleTypes(SimpleType simpleType) {
        this.topLevelSimpleTypes.put(simpleType.getName(), simpleType);
    }

    public void setTopLevelComplexTypes(Map topLevelComplexTypes) {
        this.topLevelComplexTypes = topLevelComplexTypes;
    }

    public Map getTopLevelComplexTypes() {
        return this.topLevelComplexTypes;
    }

    public void addTopLevelComplexTypes(ComplexType complexType) {
        this.topLevelComplexTypes.put(complexType.getName(), complexType);
    }

    public void setTopLevelElements(Map topLevelElements) {
        this.topLevelElements = topLevelElements;
    }

    public Map getTopLevelElements() {
        return this.topLevelElements;
    }

    public void addTopLevelElement(Element element) {
        this.topLevelElements.put(element.getName(), element);
    }

    public void setElementFormDefault(boolean elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setAttributeFormDefault(boolean attributeFormDefault) {
        this.attributeFormDefault = attributeFormDefault;
    }

    public boolean isAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setTopLevelAttributes(Map topLevelAttributes) {
        this.topLevelAttributes = topLevelAttributes;
    }

    public Map getTopLevelAttributes() {
        return this.topLevelAttributes;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setImports(List imports) {
        this.imports = imports;
    }

    public List getImports() {
        return this.imports;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public List getIncludes() {
        return this.includes;
    }

    public void setAttributesMap(Map attributesMap) {
        this.attributesMap = attributesMap;
        for (Map.Entry nextEntry : attributesMap.entrySet()) {
            QName key = (QName)nextEntry.getKey();
            if (!key.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            String value2 = (String)nextEntry.getValue();
            String prefix = key.getLocalPart();
            int index2 = prefix.indexOf(58);
            if (index2 > -1) {
                prefix = prefix.substring(index2 + 1, prefix.length());
            }
            this.namespaceResolver.put(prefix, value2);
        }
    }

    public Map getAttributesMap() {
        return this.attributesMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributeGroups(Map attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public Map getAttributeGroups() {
        return this.attributeGroups;
    }

    public AttributeGroup getAttributeGroup(String uri, String localName) {
        AttributeGroup globalAttributeGroup = null;
        if (uri.equals(this.targetNamespace) && (globalAttributeGroup = (AttributeGroup)this.getAttributeGroups().get(localName)) != null) {
            return globalAttributeGroup;
        }
        globalAttributeGroup = this.getAttributeGroupFromReferencedSchemas(uri, localName);
        return globalAttributeGroup;
    }

    protected AttributeGroup getAttributeGroupFromReferencedSchemas(String uri, String localName) {
        AttributeGroup globalAttributeGroup = null;
        Iterator iter2 = this.getIncludes().iterator();
        while (iter2.hasNext() && globalAttributeGroup == null) {
            Schema includedSchema = ((Include)iter2.next()).getSchema();
            globalAttributeGroup = includedSchema.getAttributeGroup(uri, localName);
        }
        if (globalAttributeGroup == null) {
            iter2 = this.getImports().iterator();
            while (iter2.hasNext() && globalAttributeGroup == null) {
                Schema importedSchema = ((Import)iter2.next()).getSchema();
                globalAttributeGroup = importedSchema.getAttributeGroup(uri, localName);
            }
        }
        return globalAttributeGroup;
    }

    public void setGroups(Map groups) {
        this.groups = groups;
    }

    public Map getGroups() {
        return this.groups;
    }

    public Group getGroup(String uri, String localName) {
        Group globalGroup = null;
        if (uri.equals(this.targetNamespace) && (globalGroup = (Group)this.getGroups().get(localName)) != null) {
            return globalGroup;
        }
        globalGroup = this.getGroupFromReferencedSchemas(uri, localName);
        return globalGroup;
    }

    protected Group getGroupFromReferencedSchemas(String uri, String localName) {
        Group globalGroup = null;
        Iterator iter2 = this.getIncludes().iterator();
        while (iter2.hasNext() && globalGroup == null) {
            Schema includedSchema = ((Include)iter2.next()).getSchema();
            globalGroup = includedSchema.getGroup(uri, localName);
        }
        if (globalGroup == null) {
            iter2 = this.getImports().iterator();
            while (iter2.hasNext() && globalGroup == null) {
                Schema importedSchema = ((Import)iter2.next()).getSchema();
                globalGroup = importedSchema.getGroup(uri, localName);
            }
        }
        return globalGroup;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result2) {
        this.result = result2;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public boolean hasSystemId() {
        return this.getSystemId() != null;
    }

    public String getSystemId() {
        if (this.hasResult()) {
            return this.getResult().getSystemId();
        }
        return null;
    }
}

