/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;

public class ThreadCursoredList
extends Vector {
    protected boolean isComplete = false;
    protected RuntimeException exception;

    public ThreadCursoredList() {
        this(10);
    }

    public ThreadCursoredList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ThreadCursoredList(int initialCapacity, int capacityIncrement) {
        super(0);
    }

    @Override
    public synchronized void add(int index2, Object element) {
        super.add(index2, element);
        this.notifyAll();
    }

    @Override
    public synchronized boolean add(Object element) {
        boolean result2 = super.add(element);
        this.notifyAll();
        return result2;
    }

    @Override
    public synchronized boolean addAll(int index2, Collection collection) {
        boolean result2 = super.addAll(index2, collection);
        this.notifyAll();
        return result2;
    }

    @Override
    public synchronized boolean addAll(Collection collection) {
        boolean result2 = super.addAll(collection);
        this.notifyAll();
        return result2;
    }

    public synchronized void addElement(Object object) {
        super.addElement(object);
        this.notifyAll();
    }

    @Override
    public synchronized void clear() {
        this.waitUntilComplete();
        super.clear();
    }

    @Override
    public synchronized Object clone() {
        this.waitUntilComplete();
        return super.clone();
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public synchronized void throwException(RuntimeException exception) {
        this.exception = exception;
        this.setIsComplete(true);
    }

    public synchronized boolean isComplete() {
        if (this.exception != null) {
            RuntimeException thrownException = this.exception;
            this.exception = null;
            throw thrownException;
        }
        return this.isComplete;
    }

    public synchronized void setIsComplete(boolean isComplete) {
        this.isComplete = isComplete;
        this.notifyAll();
    }

    public synchronized void waitUntilComplete() {
        while (!this.isComplete()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitUntilAdd() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public synchronized boolean contains(Object element) {
        boolean result2 = super.contains(element);
        if (!result2 && !this.isComplete()) {
            this.waitUntilComplete();
            result2 = super.contains(element);
        }
        return result2;
    }

    @Override
    public synchronized boolean containsAll(Collection collection) {
        boolean result2 = super.containsAll(collection);
        if (!result2 && !this.isComplete()) {
            this.waitUntilComplete();
            result2 = super.containsAll(collection);
        }
        return result2;
    }

    @Override
    public synchronized void copyInto(Object[] array) {
        this.waitUntilComplete();
        super.copyInto(array);
    }

    public synchronized Object elementAt(int index2) {
        Object result2 = super.elementAt(index2);
        if (result2 == null && !this.isComplete()) {
            this.waitUntilComplete();
            result2 = super.elementAt(index2);
        }
        return result2;
    }

    protected int getSize() {
        return super.size();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result2 = this.count < ThreadCursoredList.this.getSize();
                    while (!result2 && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result2 = this.count < ThreadCursoredList.this.getSize();
                    }
                    return result2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result2 = this.count < ThreadCursoredList.this.getSize();
                    while (!result2 && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result2 = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (result2) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public synchronized boolean equals(Object object) {
        this.waitUntilComplete();
        return super.equals(object);
    }

    public synchronized Object firstElement() {
        while (!this.isComplete() && super.size() < 1) {
            this.waitUntilAdd();
        }
        return super.firstElement();
    }

    @Override
    public synchronized Object get(int index2) {
        while (!this.isComplete() && super.size() < index2) {
            this.waitUntilAdd();
        }
        return super.get(index2);
    }

    @Override
    public synchronized int hashCode() {
        this.waitUntilComplete();
        return super.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        int result2 = super.indexOf(element);
        if (result2 == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result2 = super.indexOf(element);
        }
        return result2;
    }

    @Override
    public synchronized int indexOf(Object element, int index2) {
        int result2 = super.indexOf(element, index2);
        if (result2 == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result2 = super.indexOf(element, index2);
        }
        return result2;
    }

    public synchronized void insertElementAt(Object element, int index2) {
        super.insertElementAt(element, index2);
        this.notify();
    }

    @Override
    public boolean isEmpty() {
        boolean result2 = super.isEmpty();
        if (result2 && !this.isComplete()) {
            this.waitUntilAdd();
            result2 = super.isEmpty();
        }
        return result2;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public synchronized Object lastElement() {
        this.waitUntilComplete();
        return super.lastElement();
    }

    @Override
    public int lastIndexOf(Object element) {
        this.waitUntilComplete();
        return super.lastIndexOf(element);
    }

    @Override
    public synchronized int lastIndexOf(Object element, int index2) {
        this.waitUntilComplete();
        return super.lastIndexOf(element, index2);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index2) {
        return new ListIterator(index2){
            int count;
            {
                this.count = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result2 = this.count < ThreadCursoredList.this.getSize();
                    while (!result2 && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result2 = this.count < ThreadCursoredList.this.getSize();
                    }
                    return result2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object next() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result2 = this.count < ThreadCursoredList.this.getSize();
                    while (!result2 && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result2 = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (result2) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Iterator");
            }

            @Override
            public void remove() {
                throw ValidationException.operationNotSupported("remove");
            }

            public void set(Object object) {
                throw ValidationException.operationNotSupported("set");
            }

            public void add(Object object) {
                throw ValidationException.operationNotSupported("add");
            }

            @Override
            public int previousIndex() {
                return this.count - 1;
            }

            @Override
            public int nextIndex() {
                return this.count;
            }

            public Object previous() {
                --this.count;
                return ThreadCursoredList.this.get(this.count);
            }

            @Override
            public boolean hasPrevious() {
                return this.count > 0;
            }
        };
    }

    @Override
    public synchronized Object remove(int index2) {
        while (!this.isComplete() && super.size() < index2) {
            this.waitUntilAdd();
        }
        return super.remove(index2);
    }

    @Override
    public boolean remove(Object element) {
        boolean result2 = super.remove(element);
        if (!result2 && !this.isComplete()) {
            this.waitUntilAdd();
            result2 = super.remove(element);
        }
        return result2;
    }

    @Override
    public synchronized boolean removeAll(Collection collection) {
        this.waitUntilComplete();
        return super.removeAll(collection);
    }

    @Override
    public synchronized void removeAllElements() {
        this.waitUntilComplete();
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object element) {
        boolean result2 = super.removeElement(element);
        if (!result2 && !this.isComplete()) {
            this.waitUntilAdd();
            result2 = super.removeElement(element);
        }
        return result2;
    }

    @Override
    public synchronized void removeElementAt(int index2) {
        while (!this.isComplete() && super.size() < index2) {
            this.waitUntilAdd();
        }
        super.removeElementAt(index2);
    }

    @Override
    public synchronized boolean retainAll(Collection collection) {
        this.waitUntilComplete();
        return super.retainAll(collection);
    }

    @Override
    public synchronized Object set(int index2, Object element) {
        while (!this.isComplete() && super.size() < index2) {
            this.waitUntilAdd();
        }
        return super.set(index2, element);
    }

    public synchronized void setElementAt(Object element, int index2) {
        while (!this.isComplete() && super.size() < index2) {
            this.waitUntilAdd();
        }
        super.setElementAt(element, index2);
    }

    @Override
    public int size() {
        this.waitUntilComplete();
        return super.size();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        while (!this.isComplete() && super.size() < toIndex) {
            this.waitUntilAdd();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized Object[] toArray() {
        this.waitUntilComplete();
        return super.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] array) {
        this.waitUntilComplete();
        return super.toArray(array);
    }

    @Override
    public synchronized String toString() {
        this.waitUntilComplete();
        return super.toString();
    }

    @Override
    public synchronized void trimToSize() {
        this.waitUntilComplete();
        super.trimToSize();
    }
}

