/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator allocator, ByteBuffer buffer) {
        super(buffer.remaining());
        if (!buffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName(buffer));
        }
        this.allocator = allocator;
        this.buffer = buffer.slice().order(ByteOrder.BIG_ENDIAN);
        this.writerIndex(this.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public byte getByte(int index2) {
        this.ensureAccessible();
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.buffer.get(index2);
    }

    @Override
    public short getShort(int index2) {
        this.ensureAccessible();
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return (this.getByte(index2) & 0xFF) << 16 | (this.getByte(index2 + 1) & 0xFF) << 8 | this.getByte(index2 + 2) & 0xFF;
    }

    @Override
    public int getInt(int index2) {
        this.ensureAccessible();
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    @Override
    public long getLong(int index2) {
        this.ensureAccessible();
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                this.getBytes(index2, bb);
                index2 += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        if (dstIndex < 0 || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.length));
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + length);
        tmpBuf.get(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex(index2);
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        int bytesToCopy = Math.min(this.capacity() - index2, dst.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + bytesToCopy);
        dst.put(tmpBuf);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int index2, int value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int index2, long value2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index2 + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            ByteBuffer tmpBuf = this.internalNioBuffer();
            tmpBuf.clear().position(index2);
            tmpBuf.get(tmp);
            out.write(tmp);
        }
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index2).limit(index2 + length);
        return out.write(tmpBuf);
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.buffer.duplicate();
        }
        return tmpNioBuf;
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        ByteBuffer src;
        this.ensureAccessible();
        try {
            src = (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length);
        }
        catch (IllegalArgumentException ignored) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + length));
        }
        ByteBuffer dst = ByteBuffer.allocateDirect(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new UnpooledDirectByteBuf(this.alloc(), dst, this.maxCapacity());
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return new ByteBuffer[]{this.nioBuffer(index2, length)};
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        return (ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length);
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

