/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.persistent;

import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import eu.europeana.cloud.service.uis.persistent.dao.CassandraDataProviderDAO;
import eu.europeana.cloud.service.uis.status.IdentifierErrorTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CassandraDataProviderService
implements DataProviderService {
    @Autowired
    private CassandraDataProviderDAO dataProviderDao;
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataProviderService.class);

    @Override
    public ResultSlice<DataProvider> getProviders(String thresholdProviderId, int limit) {
        LOGGER.info("getProviders() thresholdProviderId='{}', limit='{}'", (Object)thresholdProviderId, (Object)limit);
        String nextProvider = null;
        List<DataProvider> providers = this.dataProviderDao.getProviders(thresholdProviderId, limit + 1);
        int providerSize = providers.size();
        if (providerSize == limit + 1) {
            nextProvider = providers.get(limit).getId();
            providers.remove(limit);
        }
        LOGGER.info("getProviders() returning providers={} and nextProvider={} for thresholdProviderId='{}', limit='{}'", providerSize, nextProvider, thresholdProviderId, limit);
        return new ResultSlice<DataProvider>(nextProvider, providers);
    }

    @Override
    public DataProvider getProvider(String providerId) throws ProviderDoesNotExistException {
        LOGGER.info("getProvider() providerId='{}'", (Object)providerId);
        DataProvider dp = this.dataProviderDao.getProvider(providerId);
        if (dp == null) {
            LOGGER.warn("ProviderDoesNotExistException providerId='{}''", (Object)providerId);
            throw new ProviderDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getErrorInfo(providerId)));
        }
        return dp;
    }

    @Override
    public DataProvider createProvider(String providerId, DataProviderProperties properties) throws ProviderAlreadyExistsException {
        LOGGER.info("createProvider() providerId='{}', properties='{}'", (Object)providerId, (Object)properties);
        DataProvider dp = this.dataProviderDao.getProvider(providerId);
        if (dp != null) {
            LOGGER.warn("ProviderAlreadyExistsException providerId='{}', properties='{}'", (Object)providerId, (Object)properties);
            throw new ProviderAlreadyExistsException(new IdentifierErrorInfo(IdentifierErrorTemplate.PROVIDER_ALREADY_EXISTS.getHttpCode(), IdentifierErrorTemplate.PROVIDER_ALREADY_EXISTS.getErrorInfo(providerId)));
        }
        return this.dataProviderDao.createDataProvider(providerId, properties);
    }

    @Override
    public DataProvider updateProvider(String providerId, DataProviderProperties properties) throws ProviderDoesNotExistException {
        LOGGER.info("updateProvider() providerId='{}', properties='{}'", (Object)providerId, (Object)properties);
        DataProvider dp = this.dataProviderDao.getProvider(providerId);
        if (dp == null) {
            LOGGER.warn("ProviderDoesNotExistException providerId='{}', properties='{}'", (Object)providerId, (Object)properties);
            throw new ProviderDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getErrorInfo(providerId)));
        }
        dp.setProperties(properties);
        return this.dataProviderDao.updateDataProvider(dp);
    }

    @Override
    public DataProvider updateProvider(DataProvider dataProvider) throws ProviderDoesNotExistException {
        LOGGER.info("updating data provider providerId='{}', properties='{}'", (Object)dataProvider.getId(), (Object)dataProvider.getProperties());
        DataProvider dp = this.dataProviderDao.getProvider(dataProvider.getId());
        if (dp == null) {
            LOGGER.warn("ProviderDoesNotExistException providerId='{}', properties='{}'", (Object)dataProvider.getId(), (Object)dataProvider.getProperties());
            throw new ProviderDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getErrorInfo(dataProvider.getId())));
        }
        return this.dataProviderDao.updateDataProvider(dataProvider);
    }

    @Override
    public void deleteProvider(String providerId) throws ProviderDoesNotExistException {
        LOGGER.info("Deleting provider {}", (Object)providerId);
        DataProvider dp = this.dataProviderDao.getProvider(providerId);
        if (dp == null) {
            LOGGER.warn("ProviderDoesNotExistException providerId='{}'", (Object)providerId);
            throw new ProviderDoesNotExistException(new IdentifierErrorInfo(IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getHttpCode(), IdentifierErrorTemplate.PROVIDER_DOES_NOT_EXIST.getErrorInfo(providerId)));
        }
        this.dataProviderDao.deleteProvider(providerId);
    }
}

