/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Clause;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    Utils() {
    }

    static StringBuilder joinAndAppend(StringBuilder sb, String separator, List<? extends Appendeable> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            values.get(i).appendTo(sb, variables);
        }
        return sb;
    }

    static StringBuilder joinAndAppendNames(StringBuilder sb, String separator, List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendName(values.get(i), sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendValues(StringBuilder sb, String separator, List<?> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendValue(values.get(i), sb, variables);
        }
        return sb;
    }

    static ByteBuffer[] convert(List<Object> values, ProtocolVersion protocolVersion) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            try {
                serializedValues[i] = DataType.serializeValue(values.get(i), protocolVersion);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, values.get(i).getClass()), e);
            }
        }
        return serializedValues;
    }

    static StringBuilder appendValue(Object value2, StringBuilder sb, List<Object> variables) {
        if (variables == null || !Utils.isSerializable(value2)) {
            return Utils.appendValue(value2, sb);
        }
        sb.append('?');
        variables.add(value2);
        return sb;
    }

    static StringBuilder appendValue(Object value2, StringBuilder sb) {
        if (Utils.appendValueIfLiteral(value2, sb)) {
            return sb;
        }
        if (Utils.appendValueIfCollection(value2, sb)) {
            return sb;
        }
        if (Utils.appendValueIfUdt(value2, sb)) {
            return sb;
        }
        if (Utils.appendValueIfTuple(value2, sb)) {
            return sb;
        }
        Utils.appendStringIfValid(value2, sb);
        return sb;
    }

    private static void appendStringIfValid(Object value2, StringBuilder sb) {
        if (value2 instanceof RawString) {
            sb.append(value2.toString());
        } else {
            if (!(value2 instanceof String)) {
                String msg = String.format("Invalid value %s of type unknown to the query builder", value2);
                if (value2 instanceof byte[]) {
                    msg = msg + " (for blob values, make sure to use a ByteBuffer)";
                }
                throw new IllegalArgumentException(msg);
            }
            Utils.appendValueString((String)value2, sb);
        }
    }

    private static boolean appendValueIfLiteral(Object value2, StringBuilder sb) {
        if (value2 instanceof Number || value2 instanceof UUID || value2 instanceof Boolean) {
            sb.append(value2);
            return true;
        }
        if (value2 instanceof InetAddress) {
            sb.append(DataType.inet().format(value2));
            return true;
        }
        if (value2 instanceof Date) {
            sb.append(DataType.timestamp().format(value2));
            return true;
        }
        if (value2 instanceof ByteBuffer) {
            sb.append(DataType.blob().format(value2));
            return true;
        }
        if (value2 instanceof BindMarker) {
            sb.append(value2);
            return true;
        }
        if (value2 instanceof FCall) {
            FCall fcall = (FCall)value2;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], sb, null);
            }
            sb.append(')');
            return true;
        }
        if (value2 instanceof CName) {
            Utils.appendName(((CName)value2).name, sb);
            return true;
        }
        if (value2 == null) {
            sb.append("null");
            return true;
        }
        return false;
    }

    private static boolean appendValueIfCollection(Object value2, StringBuilder sb) {
        if (value2 instanceof List) {
            Utils.appendList((List)value2, sb);
            return true;
        }
        if (value2 instanceof Set) {
            Utils.appendSet((Set)value2, sb);
            return true;
        }
        if (value2 instanceof Map) {
            Utils.appendMap((Map)value2, sb);
            return true;
        }
        return false;
    }

    static StringBuilder appendList(List<?> l, StringBuilder sb) {
        sb.append('[');
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Utils.appendValue(l.get(i), sb);
        }
        sb.append(']');
        return sb;
    }

    static StringBuilder appendSet(Set<?> s2, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Object elt : s2) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(elt, sb);
        }
        sb.append('}');
        return sb;
    }

    static StringBuilder appendMap(Map<?, ?> m, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry2 : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(entry2.getKey(), sb);
            sb.append(':');
            Utils.appendValue(entry2.getValue(), sb);
        }
        sb.append('}');
        return sb;
    }

    private static boolean appendValueIfUdt(Object value2, StringBuilder sb) {
        if (value2 instanceof UDTValue) {
            sb.append(((UDTValue)value2).toString());
            return true;
        }
        return false;
    }

    private static boolean appendValueIfTuple(Object value2, StringBuilder sb) {
        if (value2 instanceof TupleValue) {
            sb.append(((TupleValue)value2).toString());
            return true;
        }
        return false;
    }

    static boolean containsBindMarker(Object value2) {
        if (value2 instanceof BindMarker) {
            return true;
        }
        if (value2 instanceof FCall) {
            for (Object param2 : ((FCall)value2).parameters) {
                if (!Utils.containsBindMarker(param2)) continue;
                return true;
            }
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (!Utils.containsBindMarker(e)) continue;
                return true;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry2 : ((Map)value2).entrySet()) {
                if (!Utils.containsBindMarker(entry2.getKey()) && !Utils.containsBindMarker(entry2.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsSpecialValue(Object value2) {
        if (value2 instanceof BindMarker || value2 instanceof FCall || value2 instanceof CName || value2 instanceof RawString) {
            return true;
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (!Utils.containsSpecialValue(e)) continue;
                return true;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry2 : ((Map)value2).entrySet()) {
                if (!Utils.containsSpecialValue(entry2.getKey()) && !Utils.containsSpecialValue(entry2.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isSerializable(Object value2) {
        if (Utils.containsSpecialValue(value2)) {
            return false;
        }
        if (value2 instanceof Number && !(value2 instanceof BigInteger) && !(value2 instanceof BigDecimal)) {
            return false;
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (Utils.isSerializable(e)) continue;
                return false;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry2 : ((Map)value2).entrySet()) {
                if (Utils.isSerializable(entry2.getKey()) && Utils.isSerializable(entry2.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isIdempotent(Object value2) {
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof Assignment) {
            Assignment assignment = (Assignment)value2;
            return assignment.isIdempotent();
        }
        if (value2 instanceof FCall) {
            return false;
        }
        if (value2 instanceof RawString) {
            return false;
        }
        if (value2 instanceof Collection) {
            for (Object elt : (Collection)value2) {
                if (Utils.isIdempotent(elt)) continue;
                return false;
            }
            return true;
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry2 : ((Map)value2).entrySet()) {
                if (Utils.isIdempotent(entry2.getKey()) && Utils.isIdempotent(entry2.getValue())) continue;
                return false;
            }
        } else if (value2 instanceof Clause) {
            Object clauseValue = ((Clause)value2).firstValue();
            return Utils.isIdempotent(clauseValue);
        }
        return true;
    }

    private static StringBuilder appendValueString(String value2, StringBuilder sb) {
        return sb.append(DataType.text().format(value2));
    }

    static String toRawString(Object value2) {
        return Utils.appendValue(value2, new StringBuilder()).toString();
    }

    static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() || name.startsWith("\"") || name.startsWith("token(")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(Object name, StringBuilder sb) {
        if (name instanceof String) {
            Utils.appendName((String)name, sb);
        } else if (name instanceof CName) {
            Utils.appendName(((CName)name).name, sb);
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], sb, null);
            }
            sb.append(')');
        } else if (name instanceof Alias) {
            Alias alias = (Alias)name;
            Utils.appendName(alias.column, sb);
            sb.append(" AS ").append(alias.alias);
        } else if (name instanceof RawString) {
            sb.append(((RawString)name).str);
        } else {
            throw new IllegalArgumentException(String.format("Invalid column %s of type unknown of the query builder", name));
        }
        return sb;
    }

    static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    static class CName {
        private final String name;

        CName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FCall {
        private final String name;
        private final Object[] parameters;

        FCall(String name, Object ... parameters) {
            Preconditions.checkNotNull(name);
            this.name = name;
            this.parameters = parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class RawString {
        private final String str;

        RawString(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(StringBuilder var1, List<Object> var2);

        abstract boolean containsBindMarker();
    }
}

