/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.exceptions.DriverInternalError;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    private volatile int streamId = -1;

    protected Message() {
    }

    public Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return this.streamId;
    }

    @ChannelHandler.Sharable
    public static class ProtocolEncoder
    extends MessageToMessageEncoder<Request> {
        private final ProtocolVersion protocolVersion;

        public ProtocolEncoder(ProtocolVersion version) {
            this.protocolVersion = version;
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, Request request, List<Object> out) throws Exception {
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            if (request.isTracingRequested()) {
                flags.add(Frame.Header.Flag.TRACING);
            }
            Coder<?> coder = request.type.coder;
            ByteBuf body = ctx.alloc().buffer(coder.encodedSize(request, this.protocolVersion));
            coder.encode(request, body, this.protocolVersion);
            out.add(Frame.create(this.protocolVersion, request.type.opcode, request.getStreamId(), flags, body));
        }
    }

    @ChannelHandler.Sharable
    public static class ProtocolDecoder
    extends MessageToMessageDecoder<Frame> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            UUID tracingId = isTracing ? CBUtil.readUUID(frame.body) : null;
            try {
                Object response = Response.Type.fromOpcode((int)frame.header.opcode).decoder.decode(frame.body, frame.header.version);
                ((Response)response).setTracingId(tracingId).setStreamId(frame.header.streamId);
                out.add(response);
            }
            finally {
                frame.body.release();
            }
        }
    }

    public static abstract class Response
    extends Message {
        public final Type type;
        protected UUID tracingId;

        protected Response(Type type) {
            this.type = type;
        }

        public Response setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        public UUID getTracingId() {
            return this.tracingId;
        }

        public static enum Type {
            ERROR(0, Responses.Error.decoder),
            READY(2, Responses.Ready.decoder),
            AUTHENTICATE(3, Responses.Authenticate.decoder),
            SUPPORTED(6, Responses.Supported.decoder),
            RESULT(8, Responses.Result.decoder),
            EVENT(12, Responses.Event.decoder),
            AUTH_CHALLENGE(14, Responses.AuthChallenge.decoder),
            AUTH_SUCCESS(16, Responses.AuthSuccess.decoder);

            public final int opcode;
            public final Decoder<?> decoder;
            private static final Type[] opcodeIdx;

            private Type(int opcode, Decoder<?> decoder2) {
                this.opcode = opcode;
                this.decoder = decoder2;
            }

            public static Type fromOpcode(int opcode) {
                if (opcode < 0 || opcode >= opcodeIdx.length) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                Type t = opcodeIdx[opcode];
                if (t == null) {
                    throw new DriverInternalError(String.format("Unknown response opcode %d", opcode));
                }
                return t;
            }

            static {
                int maxOpcode = -1;
                for (Type type : Type.values()) {
                    maxOpcode = Math.max(maxOpcode, type.opcode);
                }
                opcodeIdx = new Type[maxOpcode + 1];
                for (Type type : Type.values()) {
                    if (opcodeIdx[type.opcode] != null) {
                        throw new IllegalStateException("Duplicate opcode");
                    }
                    Type.opcodeIdx[type.opcode] = type;
                }
            }
        }
    }

    public static abstract class Request
    extends Message {
        public final Type type;
        private final boolean tracingRequested;

        protected Request(Type type) {
            this(type, false);
        }

        protected Request(Type type, boolean tracingRequested) {
            this.type = type;
            this.tracingRequested = tracingRequested;
        }

        @Override
        public Request setStreamId(int streamId) {
            if (this.getStreamId() < 0) {
                return (Request)super.setStreamId(streamId);
            }
            Request copy = this.copy();
            copy.setStreamId(streamId);
            return copy;
        }

        public boolean isTracingRequested() {
            return this.tracingRequested;
        }

        ConsistencyLevel consistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.consistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.consistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.consistency;
                }
            }
            return null;
        }

        ConsistencyLevel serialConsistency() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.serialConsistency;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.serialConsistency;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.serialConsistency;
                }
            }
            return null;
        }

        long defaultTimestamp() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.defaultTimestamp;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.defaultTimestamp;
                }
                case BATCH: {
                    return ((Requests.Batch)this).options.defaultTimestamp;
                }
            }
            return 0L;
        }

        ByteBuffer pagingState() {
            switch (this.type) {
                case QUERY: {
                    return ((Requests.Query)this).options.pagingState;
                }
                case EXECUTE: {
                    return ((Requests.Execute)this).options.pagingState;
                }
            }
            return null;
        }

        abstract Request copy();

        Request copy(ConsistencyLevel newConsistencyLevel) {
            throw new UnsupportedOperationException();
        }

        public static enum Type {
            STARTUP(1, Requests.Startup.coder),
            CREDENTIALS(4, Requests.Credentials.coder),
            OPTIONS(5, Requests.Options.coder),
            QUERY(7, Requests.Query.coder),
            PREPARE(9, Requests.Prepare.coder),
            EXECUTE(10, Requests.Execute.coder),
            REGISTER(11, Requests.Register.coder),
            BATCH(13, Requests.Batch.coder),
            AUTH_RESPONSE(15, Requests.AuthResponse.coder);

            public final int opcode;
            public final Coder<?> coder;

            private Type(int opcode, Coder<?> coder) {
                this.opcode = opcode;
                this.coder = coder;
            }
        }
    }

    public static interface Decoder<R extends Response> {
        public R decode(ByteBuf var1, ProtocolVersion var2);
    }

    public static interface Coder<R extends Request> {
        public void encode(R var1, ByteBuf var2, ProtocolVersion var3);

        public int encodedSize(R var1, ProtocolVersion var2);
    }
}

