/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.IOException;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.web.multipart.MultipartFile;

public class ByteArrayMultipartFileEditor
extends ByteArrayPropertyEditor {
    public void setValue(Object value2) {
        if (value2 instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value2;
            try {
                super.setValue(multipartFile.getBytes());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot read contents of multipart file", ex);
            }
        } else if (value2 instanceof byte[]) {
            super.setValue(value2);
        } else {
            super.setValue(value2 != null ? value2.toString().getBytes() : null);
        }
    }

    public String getAsText() {
        byte[] value2 = (byte[])this.getValue();
        return value2 != null ? new String(value2) : "";
    }
}

