/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesRequestAttributes
implements RequestAttributes {
    private static final boolean portletApiPresent = ClassUtils.isPresent("javax.portlet.PortletSession", FacesRequestAttributes.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(FacesRequestAttributes.class);
    private final FacesContext facesContext;

    public FacesRequestAttributes(FacesContext facesContext) {
        Assert.notNull(facesContext, "FacesContext must not be null");
        this.facesContext = facesContext;
    }

    protected final FacesContext getFacesContext() {
        return this.facesContext;
    }

    protected final ExternalContext getExternalContext() {
        return this.getFacesContext().getExternalContext();
    }

    protected Map<String, Object> getAttributeMap(int scope) {
        if (scope == 0) {
            return this.getExternalContext().getRequestMap();
        }
        return this.getExternalContext().getSessionMap();
    }

    @Override
    public Object getAttribute(String name, int scope) {
        if (scope == 2 && portletApiPresent) {
            return PortletSessionAccessor.getAttribute(name, this.getExternalContext());
        }
        return this.getAttributeMap(scope).get(name);
    }

    @Override
    public void setAttribute(String name, Object value2, int scope) {
        if (scope == 2 && portletApiPresent) {
            PortletSessionAccessor.setAttribute(name, value2, this.getExternalContext());
        } else {
            this.getAttributeMap(scope).put(name, value2);
        }
    }

    @Override
    public void removeAttribute(String name, int scope) {
        if (scope == 2 && portletApiPresent) {
            PortletSessionAccessor.removeAttribute(name, this.getExternalContext());
        } else {
            this.getAttributeMap(scope).remove(name);
        }
    }

    @Override
    public String[] getAttributeNames(int scope) {
        if (scope == 2 && portletApiPresent) {
            return PortletSessionAccessor.getAttributeNames(this.getExternalContext());
        }
        return StringUtils.toStringArray(this.getAttributeMap(scope).keySet());
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (logger.isWarnEnabled()) {
            logger.warn("Could not register destruction callback [" + callback + "] for attribute '" + name + "' because FacesRequestAttributes does not support such callbacks");
        }
    }

    @Override
    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.getExternalContext().getRequest();
        }
        if ("session".equals(key)) {
            return this.getExternalContext().getSession(true);
        }
        if ("application".equals(key)) {
            return this.getExternalContext().getContext();
        }
        if ("requestScope".equals(key)) {
            return this.getExternalContext().getRequestMap();
        }
        if ("sessionScope".equals(key)) {
            return this.getExternalContext().getSessionMap();
        }
        if ("applicationScope".equals(key)) {
            return this.getExternalContext().getApplicationMap();
        }
        if ("facesContext".equals(key)) {
            return this.getFacesContext();
        }
        if ("cookie".equals(key)) {
            return this.getExternalContext().getRequestCookieMap();
        }
        if ("header".equals(key)) {
            return this.getExternalContext().getRequestHeaderMap();
        }
        if ("headerValues".equals(key)) {
            return this.getExternalContext().getRequestHeaderValuesMap();
        }
        if ("param".equals(key)) {
            return this.getExternalContext().getRequestParameterMap();
        }
        if ("paramValues".equals(key)) {
            return this.getExternalContext().getRequestParameterValuesMap();
        }
        if ("initParam".equals(key)) {
            return this.getExternalContext().getInitParameterMap();
        }
        if ("view".equals(key)) {
            return this.getFacesContext().getViewRoot();
        }
        if ("viewScope".equals(key)) {
            try {
                return ReflectionUtils.invokeMethod(UIViewRoot.class.getMethod("getViewMap", new Class[0]), this.getFacesContext().getViewRoot());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("JSF 2.0 API not available", ex);
            }
        }
        if ("flash".equals(key)) {
            try {
                return ReflectionUtils.invokeMethod(ExternalContext.class.getMethod("getFlash", new Class[0]), this.getExternalContext());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("JSF 2.0 API not available", ex);
            }
        }
        if ("resource".equals(key)) {
            try {
                return ReflectionUtils.invokeMethod(Application.class.getMethod("getResourceHandler", new Class[0]), this.getFacesContext().getApplication());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("JSF 2.0 API not available", ex);
            }
        }
        return null;
    }

    @Override
    public String getSessionId() {
        Object session = this.getExternalContext().getSession(true);
        try {
            Method getIdMethod = session.getClass().getMethod("getId", new Class[0]);
            return ReflectionUtils.invokeMethod(getIdMethod, session).toString();
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Session object [" + session + "] does not have a getId() method");
        }
    }

    @Override
    public Object getSessionMutex() {
        Object session = this.getExternalContext().getSession(true);
        Object mutex = this.getExternalContext().getSessionMap().get(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    private static class PortletSessionAccessor {
        private PortletSessionAccessor() {
        }

        public static Object getAttribute(String name, ExternalContext externalContext) {
            Object session = externalContext.getSession(false);
            if (session instanceof PortletSession) {
                return ((PortletSession)session).getAttribute(name, 1);
            }
            if (session != null) {
                return externalContext.getSessionMap().get(name);
            }
            return null;
        }

        public static void setAttribute(String name, Object value2, ExternalContext externalContext) {
            Object session = externalContext.getSession(true);
            if (session instanceof PortletSession) {
                ((PortletSession)session).setAttribute(name, value2, 1);
            } else {
                externalContext.getSessionMap().put(name, value2);
            }
        }

        public static void removeAttribute(String name, ExternalContext externalContext) {
            Object session = externalContext.getSession(false);
            if (session instanceof PortletSession) {
                ((PortletSession)session).removeAttribute(name, 1);
            } else if (session != null) {
                externalContext.getSessionMap().remove(name);
            }
        }

        public static String[] getAttributeNames(ExternalContext externalContext) {
            Object session = externalContext.getSession(false);
            if (session instanceof PortletSession) {
                return StringUtils.toStringArray(((PortletSession)session).getAttributeNames(1));
            }
            if (session != null) {
                return StringUtils.toStringArray(externalContext.getSessionMap().keySet());
            }
            return new String[0];
        }
    }
}

