/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.debug;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.debug.DebugRequestWrapper;
import org.springframework.security.web.debug.Logger;
import org.springframework.security.web.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugFilter
implements Filter {
    private static final String ALREADY_FILTERED_ATTR_NAME = DebugFilter.class.getName().concat(".FILTERED");
    private final FilterChainProxy fcp;
    private final Logger logger = new Logger();

    public DebugFilter(FilterChainProxy fcp) {
        this.fcp = fcp;
    }

    public final void doFilter(ServletRequest srvltRequest, ServletResponse srvltResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!(srvltRequest instanceof HttpServletRequest) || !(srvltResponse instanceof HttpServletResponse)) {
            throw new ServletException("DebugFilter just supports HTTP requests");
        }
        HttpServletRequest request = (HttpServletRequest)srvltRequest;
        HttpServletResponse response = (HttpServletResponse)srvltResponse;
        List<Filter> filters = this.getFilters(request);
        this.logger.info("Request received for " + request.getMethod() + " '" + UrlUtils.buildRequestUrl(request) + "':\n\n" + request + "\n\n" + "servletPath:" + request.getServletPath() + "\n" + "pathInfo:" + request.getPathInfo() + "\n" + "headers: \n" + this.formatHeaders(request) + "\n\n" + this.formatFilters(filters));
        if (request.getAttribute(ALREADY_FILTERED_ATTR_NAME) == null) {
            this.invokeWithWrappedRequest(request, response, filterChain);
        } else {
            this.fcp.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeWithWrappedRequest(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request.setAttribute(ALREADY_FILTERED_ATTR_NAME, (Object)Boolean.TRUE);
        request = new DebugRequestWrapper((HttpServletRequest)request);
        try {
            this.fcp.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
        finally {
            request.removeAttribute(ALREADY_FILTERED_ATTR_NAME);
        }
    }

    String formatHeaders(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        Enumeration eHeaderNames = request.getHeaderNames();
        while (eHeaderNames.hasMoreElements()) {
            String headerName = (String)eHeaderNames.nextElement();
            sb.append(headerName);
            sb.append(": ");
            Enumeration eHeaderValues = request.getHeaders(headerName);
            while (eHeaderValues.hasMoreElements()) {
                sb.append((String)eHeaderValues.nextElement());
                if (!eHeaderValues.hasMoreElements()) continue;
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    String formatFilters(List<Filter> filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("Security filter chain: ");
        if (filters == null) {
            sb.append("no match");
        } else if (filters.isEmpty()) {
            sb.append("[] empty (bypassed by security='none') ");
        } else {
            sb.append("[\n");
            for (Filter f : filters) {
                sb.append("  ").append(f.getClass().getSimpleName()).append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private List<Filter> getFilters(HttpServletRequest request) {
        for (SecurityFilterChain chain2 : this.fcp.getFilterChains()) {
            if (!chain2.matches(request)) continue;
            return chain2.getFilters();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

