/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Property {
    private static Map<Property, Annotation[]> annotationCache = new ConcurrentReferenceHashMap<Property, Annotation[]>();
    private final Class<?> objectType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final MethodParameter methodParameter;
    private Annotation[] annotations;

    public Property(Class<?> objectType, Method readMethod, Method writeMethod) {
        this(objectType, readMethod, writeMethod, null);
    }

    public Property(Class<?> objectType, Method readMethod, Method writeMethod, String name) {
        this.objectType = objectType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.methodParameter = this.resolveMethodParameter();
        this.name = name == null ? this.resolveName() : name;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int index2 = this.readMethod.getName().indexOf("get");
            if (index2 != -1) {
                index2 += 3;
            } else {
                index2 = this.readMethod.getName().indexOf("is");
                if (index2 == -1) {
                    throw new IllegalArgumentException("Not a getter method");
                }
                index2 += 2;
            }
            return StringUtils.uncapitalize(this.readMethod.getName().substring(index2));
        }
        int index3 = this.writeMethod.getName().indexOf("set") + 3;
        if (index3 == -1) {
            throw new IllegalArgumentException("Not a setter method");
        }
        return StringUtils.uncapitalize(this.writeMethod.getName().substring(index3));
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter read2 = this.resolveReadMethodParameter();
        MethodParameter write2 = this.resolveWriteMethodParameter();
        if (write2 == null) {
            if (read2 == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return read2;
        }
        if (read2 != null) {
            Class<?> readType = read2.getParameterType();
            Class<?> writeType = write2.getParameterType();
            if (!writeType.equals(readType) && writeType.isAssignableFrom(readType)) {
                return read2;
            }
        }
        return write2;
    }

    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getReadMethod(), -1));
    }

    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getWriteMethod(), 0));
    }

    private MethodParameter resolveParameterType(MethodParameter parameter) {
        GenericTypeResolver.resolveParameterType(parameter, this.getObjectType());
        return parameter;
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotations = annotationCache.get(this);
        if (annotations == null) {
            LinkedHashMap<Class<? extends Annotation>, Annotation> annotationMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(annotationMap, this.getReadMethod());
            this.addAnnotationsToMap(annotationMap, this.getWriteMethod());
            this.addAnnotationsToMap(annotationMap, this.getField());
            annotations = annotationMap.values().toArray(new Annotation[annotationMap.size()]);
            annotationCache.put(this, annotations);
        }
        return annotations;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> annotationMap, AnnotatedElement object) {
        if (object != null) {
            for (Annotation annotation : object.getAnnotations()) {
                annotationMap.put(annotation.annotationType(), annotation);
            }
        }
    }

    private Field getField() {
        String name = this.getName();
        if (!StringUtils.hasLength(name)) {
            return null;
        }
        Class<?> declaringClass = this.declaringClass();
        Field field2 = ReflectionUtils.findField(declaringClass, name);
        if (field2 == null && (field2 = ReflectionUtils.findField(declaringClass, name.substring(0, 1).toLowerCase() + name.substring(1))) == null) {
            field2 = ReflectionUtils.findField(declaringClass, name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        return field2;
    }

    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        return this.getWriteMethod().getDeclaringClass();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.objectType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.readMethod);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.writeMethod);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.name);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        boolean equals = true;
        equals &= ObjectUtils.nullSafeEquals(this.objectType, other.objectType);
        equals &= ObjectUtils.nullSafeEquals(this.readMethod, other.readMethod);
        equals &= ObjectUtils.nullSafeEquals(this.writeMethod, other.writeMethod);
        return equals &= ObjectUtils.nullSafeEquals(this.name, other.name);
    }
}

