/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.cglib.core.Signature;

class BridgeMethodResolver {
    private final Map declToBridge;

    public BridgeMethodResolver(Map declToBridge) {
        this.declToBridge = declToBridge;
    }

    public Map resolveAll() {
        HashMap resolved = new HashMap();
        Iterator entryIter = this.declToBridge.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry2 = entryIter.next();
            Class owner = (Class)entry2.getKey();
            Set bridges = (Set)entry2.getValue();
            try {
                new ClassReader(owner.getName()).accept(new BridgedFinder(bridges, resolved), 6);
            }
            catch (IOException ignored) {}
        }
        return resolved;
    }

    private static class BridgedFinder
    extends ClassVisitor {
        private Map resolved;
        private Set eligableMethods;
        private Signature currentMethod = null;

        BridgedFinder(Set eligableMethods, Map resolved) {
            super(262144);
            this.resolved = resolved;
            this.eligableMethods = eligableMethods;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Signature sig = new Signature(name, desc);
            if (this.eligableMethods.remove(sig)) {
                this.currentMethod = sig;
                return new MethodVisitor(this, 262144){
                    private final /* synthetic */ BridgedFinder this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        if (opcode == 183 && BridgedFinder.access$000(this.this$0) != null) {
                            Signature target = new Signature(name, desc);
                            if (!target.equals(BridgedFinder.access$000(this.this$0))) {
                                BridgedFinder.access$100(this.this$0).put(BridgedFinder.access$000(this.this$0), target);
                            }
                            BridgedFinder.access$002(this.this$0, null);
                        }
                    }
                };
            }
            return null;
        }

        static /* synthetic */ Signature access$000(BridgedFinder x0) {
            return x0.currentMethod;
        }

        static /* synthetic */ Map access$100(BridgedFinder x0) {
            return x0.resolved;
        }

        static /* synthetic */ Signature access$002(BridgedFinder x0, Signature x1) {
            x0.currentMethod = x1;
            return x0.currentMethod;
        }
    }
}

