/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.provider.internal.ConfigThreadContext;

public class WorkManager
implements Executor {
    private final Executor exec;
    private int tasksToDo;
    private volatile int count;
    private final AtomicInteger workInProgressCount;
    private volatile ArrayList<Exception> errors;

    public WorkManager(Executor exec) {
        this.exec = exec;
        this.workInProgressCount = new AtomicInteger();
    }

    public WorkManager(Executor exec, int tasksToDo) {
        this.exec = exec;
        this.workInProgressCount = new AtomicInteger();
        this.tasksToDo = tasksToDo;
    }

    public int getWorkInProgressCount() {
        return this.workInProgressCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() {
        AtomicInteger atomicInteger = this.workInProgressCount;
        synchronized (atomicInteger) {
            if (this.workInProgressCount.get() > 0) {
                try {
                    this.workInProgressCount.wait();
                }
                catch (InterruptedException e) {
                    throw new ExecutionException(e);
                }
            }
            this.awaitCompletionResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion(long timeout, TimeUnit unit) throws TimeoutException {
        AtomicInteger atomicInteger = this.workInProgressCount;
        synchronized (atomicInteger) {
            if (this.workInProgressCount.get() > 0) {
                try {
                    this.workInProgressCount.wait(unit.convert(timeout, TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException e) {
                    throw new ExecutionException(e);
                }
                if (this.workInProgressCount.get() > 0) {
                    throw new TimeoutException();
                }
            }
            this.awaitCompletionResults();
        }
    }

    private void awaitCompletionResults() {
        assert (0 == this.workInProgressCount.get());
        if (null != this.errors && !this.errors.isEmpty()) {
            ArrayList<Exception> errors = new ArrayList<Exception>(this.errors);
            this.errors.clear();
            throw 1 == errors.size() && ConfigurationException.class.isInstance(errors.get(0)) ? (ConfigurationException)errors.get(0) : new ExecutionException(errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed(Watcher<?> watcher, Exception e) {
        assert (null != watcher);
        AtomicInteger atomicInteger = this.workInProgressCount;
        synchronized (atomicInteger) {
            int val;
            if (null != e) {
                if (null == this.errors) {
                    this.errors = new ArrayList();
                }
                this.errors.add(e);
            }
            if ((val = this.workInProgressCount.decrementAndGet()) <= 0) {
                this.workInProgressCount.notifyAll();
            }
        }
    }

    public <V> Collection<Future<V>> submitAll(Collection<Callable<V>> tasks) {
        this.workInProgressCount.addAndGet(tasks.size());
        ArrayList<Future<V>> futures = new ArrayList<Future<V>>();
        for (Callable<V> task : tasks) {
            assert (null != task);
            Watcher<V> watcherTask = new Watcher<V>(task);
            futures.add(watcherTask);
            if (++this.count == this.tasksToDo) {
                ((Watcher)watcherTask).runNow();
                continue;
            }
            this.exec.execute(watcherTask);
        }
        return futures;
    }

    public void executeAll(Collection<Runnable> tasks) {
        this.workInProgressCount.addAndGet(tasks.size());
        for (Runnable task : tasks) {
            assert (null != task);
            Watcher<Object> watcherTask = new Watcher<Object>(task, null);
            if (++this.count == this.tasksToDo) {
                ((Watcher)watcherTask).runNow();
                continue;
            }
            this.exec.execute(watcherTask);
        }
    }

    public <V> Future<V> submit(Callable<V> task) {
        assert (null != task);
        int work = this.workInProgressCount.incrementAndGet();
        Watcher<V> watcherTask = new Watcher<V>(task);
        if (++this.count == this.tasksToDo) {
            ((Watcher)watcherTask).runNow();
        } else {
            this.exec.execute(watcherTask);
        }
        return watcherTask;
    }

    @Override
    public void execute(Runnable task) {
        assert (null != task);
        this.workInProgressCount.incrementAndGet();
        Watcher<Object> watcherTask = new Watcher<Object>(task, null);
        if (++this.count == this.tasksToDo) {
            ((Watcher)watcherTask).runNow();
        } else {
            this.exec.execute(watcherTask);
        }
    }

    public static final class ExecutionException
    extends ConfigurationException {
        protected List<? extends Throwable> cause;

        public ExecutionException(Throwable t) {
            super(t.getMessage(), t);
            this.cause = Collections.singletonList(t);
        }

        public ExecutionException(ExecutionException e) {
            super(e.getMessage(), e.getCause());
            this.cause = Collections.singletonList(e);
        }

        public ExecutionException(List<Exception> errors) {
            super(errors.get(0).getMessage(), errors.get(0));
            this.cause = errors;
        }

        public <T> T getCause(Class<T> eClass) {
            for (Throwable throwable : this.cause) {
                if (null == throwable.getCause() || eClass != throwable.getCause().getClass()) continue;
                return eClass.cast(throwable.getCause());
            }
            return null;
        }
    }

    private final class Watcher<V>
    extends FutureTask<V> {
        public Watcher(Callable<V> task) {
            super(task);
        }

        public Watcher(Runnable runnable, V result2) {
            super(runnable, result2);
        }

        @Override
        public void run() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Watcher.this.runNow();
                }
            };
            ConfigThreadContext.captureACCandRun(runnable);
        }

        private void runNow() {
            try {
                super.run();
                WorkManager.this.completed(this, null);
            }
            catch (Exception e) {
                this.setException(e);
                WorkManager.this.completed(this, e);
            }
        }
    }
}

