/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDecorator;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.PrimitiveDataType;
import org.jvnet.hk2.config.Translator;

public class DomDocument<T extends Dom> {
    private volatile Translator translator = Translator.NOOP;
    protected final Map<ActiveDescriptor<? extends ConfigInjector>, ConfigModel> models = new HashMap<ActiveDescriptor<? extends ConfigInjector>, ConfigModel>();
    private final MultiMap<Class, List<ConfigModel>> implementorsOf = new MultiMap();
    final ServiceLocator habitat;
    T root;
    private DomDecorator decorator;
    private final Map<String, DataType> validators = new HashMap<String, DataType>();
    static final List<String> PRIMS = Collections.unmodifiableList(Arrays.asList("boolean", "char", "long", "int", "java.lang.Boolean", "java.lang.Character", "java.lang.Long", "java.lang.Integer"));
    private final Map<String, ActiveDescriptor<? extends ConfigInjector<?>>> cache = new HashMap();

    public DomDocument(ServiceLocator habitat) {
        this.habitat = habitat;
        for (String prim : PRIMS) {
            this.validators.put(prim, new PrimitiveDataType(prim));
        }
        this.decorator = habitat.getService(DomDecorator.class, new Annotation[0]);
    }

    public Dom getRoot() {
        return this.root;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    ConfigModel buildModel(ActiveDescriptor<? extends ConfigInjector> i) {
        ConfigModel m = this.models.get(i);
        if (m == null) {
            m = new ConfigModel(this, i, i.getMetadata(), this.habitat);
        }
        return m;
    }

    public ConfigModel buildModel(Class<?> clazz) {
        return this.buildModel(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigModel buildModel(String fullyQualifiedClassName) {
        ActiveDescriptor<ConfigInjector<?>> desc;
        Map<String, ActiveDescriptor<? extends ConfigInjector<?>>> map2 = this.cache;
        synchronized (map2) {
            desc = this.cache.get(fullyQualifiedClassName);
            if (desc == null) {
                desc = this.habitat.getBestDescriptor(new InjectionTargetFilter(fullyQualifiedClassName));
                if (desc == null) {
                    throw new ConfigurationException("ConfigInjector for %s is not found, is it annotated with @Configured", fullyQualifiedClassName);
                }
                this.cache.put(fullyQualifiedClassName, desc);
            }
        }
        return this.buildModel(desc);
    }

    public ConfigModel getModelByElementName(String elementName) {
        ActiveDescriptor<?> i = this.habitat.getBestDescriptor(BuilderHelper.createNameAndContractFilter(ConfigInjector.class.getName(), elementName));
        if (i == null) {
            return null;
        }
        return this.buildModel(i);
    }

    public synchronized List<ConfigModel> getAllModelsImplementing(Class intf) throws ClassNotFoundException {
        if (this.implementorsOf.size() == 0) {
            this.initXRef();
        }
        return this.implementorsOf.getOne(intf);
    }

    private void initXRef() throws ClassNotFoundException {
        for (ServiceHandle<ConfigInjector> i : this.habitat.getAllServiceHandles(ConfigInjector.class, new Annotation[0])) {
            this.buildModel(i.getActiveDescriptor());
        }
        for (ConfigModel cm : this.models.values()) {
            Class<?> targetType = cm.classLoaderHolder.loadClass(cm.targetTypeName);
            do {
                Class<?>[] intfs;
                for (Class<?> intf : intfs = targetType.getInterfaces()) {
                    if (!intf.isAnnotationPresent(Configured.class)) continue;
                    this.addXRef(intf, cm);
                }
            } while ((targetType = targetType.getSuperclass()) != null);
        }
    }

    private void addXRef(Class type, ConfigModel cm) {
        List<ConfigModel> models = this.implementorsOf.getOne(type);
        if (models == null) {
            models = new ArrayList<ConfigModel>();
            this.implementorsOf.add(type, models);
        }
        models.add(cm);
    }

    @Deprecated
    public ConfigModel getModel(Class c) {
        return this.buildModel(c);
    }

    public Dom make(ServiceLocator habitat, XMLStreamReader in, T parent, ConfigModel model) {
        return this.decorator != null ? this.decorator.decorate(habitat, this, parent, model, in) : new Dom(habitat, this, (Dom)parent, model, in);
    }

    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        ((Dom)this.root).writeTo(null, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataType getValidator(String dataType) {
        Map<String, DataType> map2 = this.validators;
        synchronized (map2) {
            DataType validator = this.validators.get(dataType);
            if (validator != null) {
                return validator;
            }
        }
        List<DataType> dtfh = this.habitat.getAllServices(DataType.class, new Annotation[0]);
        Map<String, DataType> map3 = this.validators;
        synchronized (map3) {
            for (DataType dt : dtfh) {
                this.validators.put(dt.getClass().getName(), dt);
            }
            return this.validators.get(dataType);
        }
    }

    private class InjectionTargetFilter
    implements IndexedFilter {
        String targetName;

        private InjectionTargetFilter(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public boolean matches(Descriptor d) {
            if (d.getQualifiers().contains(InjectionTarget.class.getName())) {
                List<String> list2 = d.getMetadata().get("target");
                if (list2 == null) {
                    return false;
                }
                String value2 = list2.get(0);
                DomDocument.this.cache.put(value2, (ActiveDescriptor)d);
                if (value2.equals(this.targetName)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getAdvertisedContract() {
            return ConfigInjector.class.getName();
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

