/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBElement;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.xml.AnnotationType;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.ElementType;
import org.hibernate.validator.internal.xml.GroupsType;
import org.hibernate.validator.internal.xml.PayloadType;

class MetaConstraintBuilder {
    private static final Log log = LoggerFactory.make();
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";

    private MetaConstraintBuilder() {
    }

    static <A extends Annotation> MetaConstraint<A> buildMetaConstraint(ConstraintLocation constraintLocation, ConstraintType constraint, java.lang.annotation.ElementType type, String defaultPackage, ConstraintHelper constraintHelper, ConstraintDescriptorImpl.ConstraintType constraintType) {
        Object annotation;
        Class<?> annotationClass;
        try {
            annotationClass = ClassLoadingHelper.loadClass(constraint.getAnnotation(), defaultPackage);
        }
        catch (ValidationException e) {
            throw log.getUnableToLoadConstraintAnnotationClassException(constraint.getAnnotation(), e);
        }
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, MetaConstraintBuilder.getGroups(constraint.getGroups(), defaultPackage));
        annotationDescriptor.setValue(PAYLOAD_PARAM, MetaConstraintBuilder.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            MetaConstraintBuilder.checkNameIsValid(name);
            Class<?> returnType = MetaConstraintBuilder.getAnnotationParameterType(annotationClass, name);
            Object elementValue = MetaConstraintBuilder.getElementValue(elementType, returnType, defaultPackage);
            annotationDescriptor.setValue(name, elementValue);
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(constraintHelper, constraintLocation.getMember(), annotation, type, constraintType);
        return new MetaConstraint(constraintDescriptor, constraintLocation);
    }

    private static <A extends Annotation> Annotation buildAnnotation(AnnotationType annotationType, Class<A> returnType, String defaultPackage) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = MetaConstraintBuilder.getAnnotationParameterType(returnType, name);
            Object elementValue = MetaConstraintBuilder.getElementValue(elementType, parameterType, defaultPackage);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private static void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw log.getReservedParameterNamesException(MESSAGE_PARAM, GROUPS_PARAM, PAYLOAD_PARAM);
        }
    }

    private static <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = MetaConstraintBuilder.run(GetMethod.action(annotationClass, name));
        if (m == null) {
            throw log.getAnnotationDoesNotContainAParameterException(annotationClass.getName(), name);
        }
        return m.getReturnType();
    }

    private static Object getElementValue(ElementType elementType, Class<?> returnType, String defaultPackage) {
        MetaConstraintBuilder.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw log.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();
            }
            return MetaConstraintBuilder.getSingleValue(elementType.getContent().get(0), returnType, defaultPackage);
        }
        ArrayList<Object> values = CollectionHelper.newArrayList();
        for (Serializable s2 : elementType.getContent()) {
            values.add(MetaConstraintBuilder.getSingleValue(s2, returnType.getComponentType(), defaultPackage));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private static void removeEmptyContentElements(ElementType elementType) {
        ArrayList contentToDelete = CollectionHelper.newArrayList();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private static Object getSingleValue(Serializable serializable2, Class<?> returnType, String defaultPackage) {
        Object returnValue;
        if (serializable2 instanceof String) {
            String value2 = (String)((Object)serializable2);
            returnValue = MetaConstraintBuilder.convertStringToReturnType(returnType, value2, defaultPackage);
        } else if (serializable2 instanceof JAXBElement && ((JAXBElement)serializable2).getDeclaredType().equals(String.class)) {
            JAXBElement elem2 = (JAXBElement)serializable2;
            String value3 = (String)elem2.getValue();
            returnValue = MetaConstraintBuilder.convertStringToReturnType(returnType, value3, defaultPackage);
        } else if (serializable2 instanceof JAXBElement && ((JAXBElement)serializable2).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem3 = (JAXBElement)serializable2;
            AnnotationType annotationType = (AnnotationType)elem3.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = MetaConstraintBuilder.buildAnnotation(annotationType, annotationClass, defaultPackage);
            }
            catch (ClassCastException e) {
                throw log.getUnexpectedParameterValueException(e);
            }
        } else {
            throw log.getUnexpectedParameterValueException();
        }
        return returnValue;
    }

    private static Object convertStringToReturnType(Class<?> returnType, String value2, String defaultPackage) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value2);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("byte", e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value2);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("short", e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value2);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("int", e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value2);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("long", e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value2));
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("float", e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value2);
            }
            catch (NumberFormatException e) {
                throw log.getInvalidNumberFormatException("double", e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value2);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value2.length() != 1) {
                throw log.getInvalidCharValueException(value2);
            }
            returnValue = Character.valueOf(value2.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value2;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = ClassLoadingHelper.loadClass(value2, defaultPackage, MetaConstraintBuilder.class);
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value2);
            }
            catch (ClassCastException e) {
                throw log.getInvalidReturnTypeException(returnType, e);
            }
        }
        return returnValue;
    }

    private static Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList<Class> groupList = CollectionHelper.newArrayList();
        for (String groupClass : groupsType.getValue()) {
            groupList.add(ClassLoadingHelper.loadClass(groupClass, defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private static Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList<Class> payloadList = CollectionHelper.newArrayList();
        for (String groupClass : payloadType.getValue()) {
            Class<?> payload = ClassLoadingHelper.loadClass(groupClass, defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw log.getWrongPayloadClassException(payload.getName());
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

