/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size2) {
        return new HashMap(size2);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<K, V> map2) {
        return new HashMap<K, V>(map2);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(int size2) {
        return new HashSet(size2);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> c) {
        return new HashSet<T>(c);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> s1, Collection<? extends T> s2) {
        HashSet<T> set = CollectionHelper.newHashSet(s1);
        set.addAll(s2);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> iterable) {
        HashSet<T> set = CollectionHelper.newHashSet();
        for (T t : iterable) {
            set.add(t);
        }
        return set;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size2) {
        return new ArrayList(size2);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> ... iterables) {
        ArrayList<T> resultList = CollectionHelper.newArrayList();
        for (Iterable<T> oneIterable : iterables) {
            for (T oneElement : oneIterable) {
                resultList.add(oneElement);
            }
        }
        return resultList;
    }

    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static <K, V> Map<K, List<V>> partition(List<V> list2, Partitioner<K, V> partitioner) {
        if (list2 == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : list2) {
            K key = partitioner.getPartition(v);
            ArrayList partition2 = (ArrayList)theValue.get(key);
            if (partition2 == null) {
                partition2 = CollectionHelper.newArrayList();
                theValue.put(key, partition2);
            }
            partition2.add(v);
        }
        return theValue;
    }

    public static <K, V> Map<K, Set<V>> partition(Set<V> set, Partitioner<K, V> partitioner) {
        if (set == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : set) {
            K key = partitioner.getPartition(v);
            HashSet partition2 = (HashSet)theValue.get(key);
            if (partition2 == null) {
                partition2 = CollectionHelper.newHashSet();
                theValue.put(key, partition2);
            }
            partition2.add(v);
        }
        return theValue;
    }

    public static interface Partitioner<K, V> {
        public K getPartition(V var1);
    }
}

