/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ConstrainedParameter
extends AbstractConstrainedElement {
    private final Type type;
    private final String name;
    private final int index;

    public ConstrainedParameter(ConfigurationSource source, ConstraintLocation location, Type type, int index2, String name) {
        this(source, location, type, index2, name, Collections.emptySet(), Collections.emptyMap(), false, false);
    }

    public ConstrainedParameter(ConfigurationSource source, ConstraintLocation location, Type type, int index2, String name, Set<MetaConstraint<?>> constraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading, boolean requiresUnwrapping) {
        super(source, ConstrainedElement.ConstrainedElementKind.PARAMETER, location, constraints, groupConversions, isCascading, requiresUnwrapping);
        this.type = type;
        this.name = name;
        this.index = index2;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public ConstrainedParameter merge(ConstrainedParameter other) {
        ConfigurationSource mergedSource = ConfigurationSource.max(this.source, other.source);
        String mergedName = this.source.getPriority() > other.source.getPriority() ? this.name : other.name;
        HashSet<MetaConstraint<?>> mergedConstraints = CollectionHelper.newHashSet(this.constraints);
        mergedConstraints.addAll(other.constraints);
        HashMap<Class<?>, Class<?>> mergedGroupConversions = CollectionHelper.newHashMap(this.groupConversions);
        mergedGroupConversions.putAll(other.groupConversions);
        return new ConstrainedParameter(mergedSource, this.getLocation(), this.type, this.index, mergedName, mergedConstraints, mergedGroupConversions, this.isCascading || other.isCascading, this.requiresUnwrapping || other.requiresUnwrapping);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MetaConstraint<?> oneConstraint : this.getConstraints()) {
            sb.append(oneConstraint.getDescriptor().getAnnotation().annotationType().getSimpleName());
            sb.append(", ");
        }
        String constraintsAsString = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "ParameterMetaData [location=" + this.getLocation() + "], name=" + this.name + "], constraints=[" + constraintsAsString + "], isCascading=" + this.isCascading() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.index;
        result2 = 31 * result2 + (this.getLocation().getMember() == null ? 0 : this.getLocation().getMember().hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstrainedParameter other = (ConstrainedParameter)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.getLocation().getMember() == null ? other.getLocation().getMember() != null : !this.getLocation().getMember().equals(other.getLocation().getMember()));
    }
}

