/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodType;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.PropertyMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.BeanDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filters;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public final class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Log log = LoggerFactory.make();
    private final Class<T> beanClass;
    private final Set<MetaConstraint<?>> allMetaConstraints;
    private final Set<MetaConstraint<?>> directMetaConstraints;
    private final Map<String, ExecutableMetaData> executableMetaDataMap;
    private final Map<String, PropertyMetaData> propertyMetaDataMap;
    private final Set<Cascadable> cascadedProperties;
    private final BeanDescriptor beanDescriptor;
    private List<Class<?>> defaultGroupSequence = CollectionHelper.newArrayList();
    private DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider;
    private final List<Class<? super T>> classHierarchyWithoutInterfaces;

    public BeanMetaDataImpl(Class<T> beanClass, List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider, Set<ConstraintMetaData> constraintMetaDataSet) {
        this.beanClass = beanClass;
        this.propertyMetaDataMap = CollectionHelper.newHashMap();
        HashSet<PropertyMetaData> propertyMetaDataSet = CollectionHelper.newHashSet();
        HashSet<ExecutableMetaData> executableMetaDataSet = CollectionHelper.newHashSet();
        for (ConstraintMetaData constraintMetaData : constraintMetaDataSet) {
            if (constraintMetaData.getKind() == ElementKind.PROPERTY) {
                propertyMetaDataSet.add((PropertyMetaData)constraintMetaData);
                continue;
            }
            executableMetaDataSet.add((ExecutableMetaData)constraintMetaData);
        }
        HashSet cascadedProperties = CollectionHelper.newHashSet();
        HashSet allMetaConstraints = CollectionHelper.newHashSet();
        for (PropertyMetaData propertyMetaData : propertyMetaDataSet) {
            this.propertyMetaDataMap.put(propertyMetaData.getName(), propertyMetaData);
            if (propertyMetaData.isCascading()) {
                cascadedProperties.add(propertyMetaData);
            }
            allMetaConstraints.addAll(propertyMetaData.getConstraints());
        }
        this.cascadedProperties = Collections.unmodifiableSet(cascadedProperties);
        this.allMetaConstraints = Collections.unmodifiableSet(allMetaConstraints);
        this.classHierarchyWithoutInterfaces = ClassHierarchyHelper.getHierarchy(beanClass, Filters.excludeInterfaces());
        this.setDefaultGroupSequenceOrProvider(defaultGroupSequence, defaultGroupSequenceProvider);
        this.directMetaConstraints = this.getDirectConstraints();
        this.executableMetaDataMap = Collections.unmodifiableMap(this.byIdentifier(executableMetaDataSet));
        this.beanDescriptor = new BeanDescriptorImpl(beanClass, this.getClassLevelConstraintsAsDescriptors(), this.getConstrainedPropertiesAsDescriptors(), this.getConstrainedMethodsAsDescriptors(), this.getConstrainedConstructorsAsDescriptors(), this.defaultGroupSequenceIsRedefined(), this.getDefaultGroupSequence(null));
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public boolean hasConstraints() {
        return this.beanDescriptor.isBeanConstrained() || !this.beanDescriptor.getConstrainedConstructors().isEmpty() || !this.beanDescriptor.getConstrainedMethods(MethodType.NON_GETTER, MethodType.GETTER).isEmpty();
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public Set<Cascadable> getCascadables() {
        return this.cascadedProperties;
    }

    @Override
    public PropertyMetaData getMetaDataFor(String propertyName) {
        return this.propertyMetaDataMap.get(propertyName);
    }

    @Override
    public Set<MetaConstraint<?>> getMetaConstraints() {
        return this.allMetaConstraints;
    }

    @Override
    public Set<MetaConstraint<?>> getDirectMetaConstraints() {
        return this.directMetaConstraints;
    }

    @Override
    public ExecutableMetaData getMetaDataFor(ExecutableElement executable) {
        return this.executableMetaDataMap.get(executable.getIdentifier());
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence(T beanState) {
        if (this.hasDefaultGroupSequenceProvider()) {
            List<Class<?>> providerDefaultGroupSequence = this.defaultGroupSequenceProvider.getValidationGroups(beanState);
            return this.getValidDefaultGroupSequence(providerDefaultGroupSequence);
        }
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1 || this.hasDefaultGroupSequenceProvider();
    }

    @Override
    public List<Class<? super T>> getClassHierarchy() {
        return this.classHierarchyWithoutInterfaces;
    }

    private Set<ConstraintDescriptorImpl<?>> getClassLevelConstraintsAsDescriptors() {
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(this.allMetaConstraints);
        HashSet<ConstraintDescriptorImpl<?>> theValue = CollectionHelper.newHashSet();
        for (MetaConstraint<?> metaConstraint : classLevelConstraints) {
            theValue.add(metaConstraint.getDescriptor());
        }
        return theValue;
    }

    private Map<String, PropertyDescriptor> getConstrainedPropertiesAsDescriptors() {
        HashMap<String, PropertyDescriptor> theValue = CollectionHelper.newHashMap();
        for (Map.Entry<String, PropertyMetaData> entry2 : this.propertyMetaDataMap.entrySet()) {
            if (!entry2.getValue().isConstrained() || entry2.getValue().getName() == null) continue;
            theValue.put(entry2.getKey(), (PropertyDescriptor)entry2.getValue().asDescriptor(this.defaultGroupSequenceIsRedefined(), (List)this.getDefaultGroupSequence(null)));
        }
        return theValue;
    }

    private Map<String, ExecutableDescriptorImpl> getConstrainedMethodsAsDescriptors() {
        HashMap<String, ExecutableDescriptorImpl> constrainedMethodDescriptors = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : this.executableMetaDataMap.values()) {
            if (executableMetaData.getKind() != ElementKind.METHOD || !executableMetaData.isConstrained()) continue;
            constrainedMethodDescriptors.put(executableMetaData.getIdentifier(), (ExecutableDescriptorImpl)executableMetaData.asDescriptor(this.defaultGroupSequenceIsRedefined(), (List)this.getDefaultGroupSequence(null)));
        }
        return constrainedMethodDescriptors;
    }

    private Map<String, ConstructorDescriptor> getConstrainedConstructorsAsDescriptors() {
        HashMap<String, ConstructorDescriptor> constrainedMethodDescriptors = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : this.executableMetaDataMap.values()) {
            if (executableMetaData.getKind() != ElementKind.CONSTRUCTOR || !executableMetaData.isConstrained()) continue;
            constrainedMethodDescriptors.put(executableMetaData.getIdentifier(), (ConstructorDescriptor)executableMetaData.asDescriptor(this.defaultGroupSequenceIsRedefined(), (List)this.getDefaultGroupSequence(null)));
        }
        return constrainedMethodDescriptors;
    }

    private void setDefaultGroupSequenceOrProvider(List<Class<?>> defaultGroupSequence, DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider) {
        if (defaultGroupSequence != null && defaultGroupSequenceProvider != null) {
            throw log.getInvalidDefaultGroupSequenceDefinitionException();
        }
        if (defaultGroupSequenceProvider != null) {
            this.defaultGroupSequenceProvider = defaultGroupSequenceProvider;
        } else if (defaultGroupSequence != null && !defaultGroupSequence.isEmpty()) {
            this.setDefaultGroupSequence(defaultGroupSequence);
        } else {
            this.setDefaultGroupSequence(Arrays.asList(this.beanClass));
        }
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Set<MetaConstraint<?>> constraints) {
        Set<MetaConstraint<?>> classLevelConstraints = CollectionHelper.partition(constraints, this.byElementType()).get((Object)ElementType.TYPE);
        return classLevelConstraints != null ? classLevelConstraints : Collections.emptySet();
    }

    private Set<MetaConstraint<?>> getDirectConstraints() {
        HashSet constraints = CollectionHelper.newHashSet();
        HashSet<Class> classAndInterfaces = CollectionHelper.newHashSet();
        classAndInterfaces.add(this.beanClass);
        classAndInterfaces.addAll(ClassHierarchyHelper.getDirectlyImplementedInterfaces(this.beanClass));
        for (Class clazz : classAndInterfaces) {
            for (MetaConstraint<?> metaConstraint : this.allMetaConstraints) {
                if (!metaConstraint.getLocation().getDeclaringClass().equals(clazz)) continue;
                constraints.add(metaConstraint);
            }
        }
        return Collections.unmodifiableSet(constraints);
    }

    private Map<String, ExecutableMetaData> byIdentifier(Set<ExecutableMetaData> executables) {
        HashMap<String, ExecutableMetaData> theValue = CollectionHelper.newHashMap();
        for (ExecutableMetaData executableMetaData : executables) {
            theValue.put(executableMetaData.getIdentifier(), executableMetaData);
        }
        return theValue;
    }

    private void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = this.getValidDefaultGroupSequence(groupSequence);
    }

    private List<Class<?>> getValidDefaultGroupSequence(List<Class<?>> groupSequence) {
        ArrayList validDefaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        if (groupSequence != null) {
            for (Class<?> group : groupSequence) {
                if (group.getName().equals(this.beanClass.getName())) {
                    validDefaultGroupSequence.add(Default.class);
                    groupSequenceContainsDefault = true;
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw log.getNoDefaultGroupInGroupSequenceException();
                }
                validDefaultGroupSequence.add(group);
            }
        }
        if (!groupSequenceContainsDefault) {
            throw log.getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(this.beanClass.getName());
        }
        if (log.isTraceEnabled()) {
            log.tracef("Members of the default group sequence for bean %s are: %s.", (Object)this.beanClass.getName(), (Object)validDefaultGroupSequence);
        }
        return validDefaultGroupSequence;
    }

    private boolean hasDefaultGroupSequenceProvider() {
        return this.defaultGroupSequenceProvider != null;
    }

    private CollectionHelper.Partitioner<ElementType, MetaConstraint<?>> byElementType() {
        return new CollectionHelper.Partitioner<ElementType, MetaConstraint<?>>(){

            @Override
            public ElementType getPartition(MetaConstraint<?> constraint) {
                return constraint.getElementType();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass.getSimpleName());
        sb.append(", constraintCount=").append(this.getMetaConstraints().size());
        sb.append(", cascadedPropertiesCount=").append(this.cascadedProperties.size());
        sb.append(", defaultGroupSequence=").append(this.getDefaultGroupSequence(null));
        sb.append('}');
        return sb.toString();
    }

    private static class BuilderDelegate {
        private final Class<?> beanClass;
        private final ConstraintHelper constraintHelper;
        private final ExecutableHelper executableHelper;
        private MetaDataBuilder propertyBuilder;
        private ExecutableMetaData.Builder methodBuilder;

        public BuilderDelegate(Class<?> beanClass, ConstrainedElement constrainedElement, ConstraintHelper constraintHelper, ExecutableHelper executableHelper) {
            this.beanClass = beanClass;
            this.constraintHelper = constraintHelper;
            this.executableHelper = executableHelper;
            switch (constrainedElement.getKind()) {
                case FIELD: {
                    ConstrainedField constrainedField = (ConstrainedField)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedField, constraintHelper);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
                    this.methodBuilder = new ExecutableMetaData.Builder(beanClass, constrainedExecutable, constraintHelper, executableHelper);
                    if (!constrainedExecutable.isGetterMethod()) break;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedExecutable, constraintHelper);
                    break;
                }
                case TYPE: {
                    ConstrainedType constrainedType = (ConstrainedType)constrainedElement;
                    this.propertyBuilder = new PropertyMetaData.Builder(beanClass, constrainedType, constraintHelper);
                }
            }
        }

        public boolean add(ConstrainedElement constrainedElement) {
            boolean added = false;
            if (this.methodBuilder != null && this.methodBuilder.accepts(constrainedElement)) {
                this.methodBuilder.add(constrainedElement);
                added = true;
            }
            if (this.propertyBuilder != null && this.propertyBuilder.accepts(constrainedElement)) {
                this.propertyBuilder.add(constrainedElement);
                if (!added && constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && this.methodBuilder == null) {
                    ConstrainedExecutable constrainedMethod = (ConstrainedExecutable)constrainedElement;
                    this.methodBuilder = new ExecutableMetaData.Builder(this.beanClass, constrainedMethod, this.constraintHelper, this.executableHelper);
                }
                added = true;
            }
            return added;
        }

        public Set<ConstraintMetaData> build() {
            HashSet<ConstraintMetaData> metaDataSet = CollectionHelper.newHashSet();
            if (this.propertyBuilder != null) {
                metaDataSet.add(this.propertyBuilder.build());
            }
            if (this.methodBuilder != null) {
                metaDataSet.add(this.methodBuilder.build());
            }
            return metaDataSet;
        }
    }

    public static class BeanMetaDataBuilder<T> {
        private final ConstraintHelper constraintHelper;
        private final Class<T> beanClass;
        private final Set<BuilderDelegate> builders = CollectionHelper.newHashSet();
        private final ExecutableHelper executableHelper;
        private ConfigurationSource sequenceSource;
        private ConfigurationSource providerSource;
        private List<Class<?>> defaultGroupSequence;
        private DefaultGroupSequenceProvider<? super T> defaultGroupSequenceProvider;

        private BeanMetaDataBuilder(ConstraintHelper constraintHelper, ExecutableHelper executableHelper, Class<T> beanClass) {
            this.beanClass = beanClass;
            this.constraintHelper = constraintHelper;
            this.executableHelper = executableHelper;
        }

        public static <T> BeanMetaDataBuilder<T> getInstance(ConstraintHelper constraintHelper, ExecutableHelper executableHelper, Class<T> beanClass) {
            return new BeanMetaDataBuilder<T>(constraintHelper, executableHelper, beanClass);
        }

        public void add(BeanConfiguration<? super T> configuration) {
            if (configuration.getBeanClass().equals(this.beanClass)) {
                if (configuration.getDefaultGroupSequence() != null && (this.sequenceSource == null || configuration.getSource().getPriority() >= this.sequenceSource.getPriority())) {
                    this.sequenceSource = configuration.getSource();
                    this.defaultGroupSequence = configuration.getDefaultGroupSequence();
                }
                if (configuration.getDefaultGroupSequenceProvider() != null && (this.providerSource == null || configuration.getSource().getPriority() >= this.providerSource.getPriority())) {
                    this.providerSource = configuration.getSource();
                    this.defaultGroupSequenceProvider = configuration.getDefaultGroupSequenceProvider();
                }
            }
            for (ConstrainedElement constrainedElement : configuration.getConstrainedElements()) {
                this.addMetaDataToBuilder(constrainedElement, this.builders);
            }
        }

        private void addMetaDataToBuilder(ConstrainedElement constrainableElement, Set<BuilderDelegate> builders) {
            for (BuilderDelegate builder : builders) {
                boolean foundBuilder = builder.add(constrainableElement);
                if (!foundBuilder) continue;
                return;
            }
            builders.add(new BuilderDelegate(this.beanClass, constrainableElement, this.constraintHelper, this.executableHelper));
        }

        public BeanMetaDataImpl<T> build() {
            HashSet<ConstraintMetaData> aggregatedElements = CollectionHelper.newHashSet();
            for (BuilderDelegate builder : this.builders) {
                aggregatedElements.addAll(builder.build());
            }
            return new BeanMetaDataImpl<T>(this.beanClass, this.defaultGroupSequence, this.defaultGroupSequenceProvider, aggregatedElements);
        }
    }
}

