/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.resolver;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Path;
import javax.validation.TraversableResolver;

public class CachingTraversableResolverForSingleValidation
implements TraversableResolver {
    private TraversableResolver delegate;
    private Map<TraversableHolder, TraversableHolder> traversables = new HashMap<TraversableHolder, TraversableHolder>();

    public CachingTraversableResolverForSingleValidation(TraversableResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        TraversableHolder currentLH = new TraversableHolder(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        TraversableHolder cachedLH = this.traversables.get(currentLH);
        if (cachedLH == null) {
            currentLH.isReachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.traversables.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.isReachable == null) {
            cachedLH.isReachable = this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.isReachable;
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        TraversableHolder currentLH = new TraversableHolder(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        TraversableHolder cachedLH = this.traversables.get(currentLH);
        if (cachedLH == null) {
            currentLH.isCascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
            this.traversables.put(currentLH, currentLH);
            cachedLH = currentLH;
        } else if (cachedLH.isCascadable == null) {
            cachedLH.isCascadable = this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
        }
        return cachedLH.isCascadable;
    }

    private static final class TraversableHolder {
        private final Object traversableObject;
        private final Path.Node traversableProperty;
        private final Class<?> rootBeanType;
        private final Path pathToTraversableObject;
        private final ElementType elementType;
        private final int hashCode;
        private Boolean isReachable;
        private Boolean isCascadable;

        private TraversableHolder(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            this.traversableObject = traversableObject;
            this.traversableProperty = traversableProperty;
            this.rootBeanType = rootBeanType;
            this.pathToTraversableObject = pathToTraversableObject;
            this.elementType = elementType;
            this.hashCode = this.buildHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraversableHolder that = (TraversableHolder)o;
            if (this.elementType != that.elementType) {
                return false;
            }
            if (!this.pathToTraversableObject.equals(that.pathToTraversableObject)) {
                return false;
            }
            if (!this.rootBeanType.equals(that.rootBeanType)) {
                return false;
            }
            if (this.traversableObject != null ? !this.traversableObject.equals(that.traversableObject) : that.traversableObject != null) {
                return false;
            }
            return this.traversableProperty.equals(that.traversableProperty);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int buildHashCode() {
            int result2 = this.traversableObject != null ? this.traversableObject.hashCode() : 0;
            result2 = 31 * result2 + this.traversableProperty.hashCode();
            result2 = 31 * result2 + this.rootBeanType.hashCode();
            result2 = 31 * result2 + this.pathToTraversableObject.hashCode();
            result2 = 31 * result2 + this.elementType.hashCode();
            return result2;
        }
    }
}

