/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Size;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class SizeValidatorForMap
implements ConstraintValidator<Size, Map<?, ?>> {
    private static final Log log = LoggerFactory.make();
    private int min;
    private int max;

    @Override
    public void initialize(Size parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.validateParameters();
    }

    @Override
    public boolean isValid(Map<?, ?> map2, ConstraintValidatorContext constraintValidatorContext) {
        if (map2 == null) {
            return true;
        }
        int size2 = map2.size();
        return size2 >= this.min && size2 <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw log.getMaxCannotBeNegativeException();
        }
        if (this.max < 0) {
            throw log.getMaxCannotBeNegativeException();
        }
        if (this.max < this.min) {
            throw log.getLengthCannotBeNegativeException();
        }
    }
}

