/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Max;

public class MaxValidatorForNumber
implements ConstraintValidator<Max, Number> {
    private long maxValue;

    @Override
    public void initialize(Max maxValue) {
        this.maxValue = maxValue.value();
    }

    @Override
    public boolean isValid(Number value2, ConstraintValidatorContext constraintValidatorContext) {
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).compareTo(BigDecimal.valueOf(this.maxValue)) != 1;
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).compareTo(BigInteger.valueOf(this.maxValue)) != 1;
        }
        long longValue = value2.longValue();
        return longValue <= this.maxValue;
    }
}

