/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;

public class InputStreamArchiveAdapter
extends AbstractAdapter {
    private final InputStream is;
    private final URI uri;

    public InputStreamArchiveAdapter(JarArchive parent, URI uri, InputStream is) {
        this.uri = uri;
        this.is = is;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Manifest getManifest() throws IOException {
        throw new IOException("Not Implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger2) throws IOException {
        byte[] bytes = new byte[52000];
        JarInputStream jis = new JarInputStream(new BufferedInputStream(this.is));
        try {
            JarEntry ja;
            while ((ja = jis.getNextJarEntry()) != null) {
                try {
                    ArchiveAdapter.Entry je = new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory());
                    if (!selector.isSelected(je)) continue;
                    try {
                        if (ja.getSize() > (long)bytes.length) {
                            bytes = new byte[(int)ja.getSize()];
                        }
                        if (ja.getSize() != 0L) {
                            int read2 = 0;
                            int allRead = 0;
                            do {
                                if ((allRead += (read2 = jis.read(bytes, allRead, bytes.length - allRead))) != bytes.length) continue;
                                bytes = Arrays.copyOf(bytes, bytes.length * 2);
                            } while (read2 != -1);
                            if (ja.getSize() != -1L && ja.getSize() != (long)(allRead + 1)) {
                                logger2.severe("Incorrect file length while processing " + ja.getName() + " of size " + ja.getSize() + " got " + allRead);
                            }
                            if (je.size == -1L) {
                                je = new ArchiveAdapter.Entry(ja.getName(), allRead + 1);
                            }
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                        try {
                            task.on(je, bais);
                        }
                        finally {
                            bais.close();
                        }
                    }
                    catch (Exception e) {
                        logger2.log(Level.SEVERE, "Exception while processing " + ja.getName() + " of size " + ja.getSize(), e);
                    }
                }
                finally {
                    try {
                        jis.closeEntry();
                    }
                    catch (Exception e) {
                        logger2.log(Level.FINE, "swallowing error", e);
                    }
                }
            }
            return;
        }
        finally {
            try {
                jis.close();
            }
            catch (Exception e) {
                logger2.log(Level.FINE, "swallowing error", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

