/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public class DoesExistQuery
extends DatabaseQuery {
    public static final int AssumeNonExistence = 1;
    public static final int AssumeExistence = 2;
    public static final int CheckCache = 3;
    public static final int CheckDatabase = 4;
    protected Object primaryKey;
    protected Object object;
    protected int existencePolicy = 3;
    protected boolean checkDatabaseIfInvalid = true;
    public boolean checkCacheFirst = true;

    public DoesExistQuery() {
    }

    public DoesExistQuery(Object object) {
        this();
        this.object = object;
    }

    public DoesExistQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void assumeExistenceForDoesExist() {
        this.setExistencePolicy(2);
    }

    public void assumeNonExistenceForDoesExist() {
        this.setExistencePolicy(1);
    }

    public void checkCacheForDoesExist() {
        this.setExistencePolicy(3);
    }

    public void checkDatabaseForDoesExist() {
        this.setExistencePolicy(4);
    }

    /*
     * Unable to fully structure code
     */
    public Object checkEarlyReturn(Object object, Object primaryKey, AbstractSession session, AbstractRecord translationRow) {
        block13: {
            block14: {
                this.buildSelectionCriteria(session);
                if (object == null) {
                    return Boolean.FALSE;
                }
                descriptor = session.getDescriptor(object.getClass());
                if (primaryKey == null && (primaryKey = this.getPrimaryKey()) == null) {
                    primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session, true);
                }
                if (primaryKey == null) {
                    return Boolean.FALSE;
                }
                if (!this.shouldCheckCacheForDoesExist() && !this.checkCacheFirst || descriptor.isDescriptorForInterface()) break block13;
                if (this.checkDatabaseIfInvalid && session.isUnitOfWork() && ((UnitOfWorkImpl)session).shouldReadFromDB()) {
                    return null;
                }
                objectClass = object.getClass();
                tempSession = session;
                if (!tempSession.isUnitOfWork()) break block14;
                cacheKey = tempSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, objectClass, descriptor);
                if (cacheKey == null) ** GOTO lbl21
                return Boolean.TRUE;
lbl-1000:
                // 1 sources

                {
                    cacheKey = (tempSession = ((UnitOfWorkImpl)tempSession).getParent()).getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, objectClass, descriptor);
                    if (cacheKey == null) continue;
                    return Boolean.TRUE;
lbl21:
                    // 2 sources

                    ** while (((UnitOfWorkImpl)tempSession).isNestedUnitOfWork())
                }
lbl22:
                // 1 sources

                tempSession = ((UnitOfWorkImpl)tempSession).getParentIdentityMapSession(descriptor, false, true);
            }
            if ((cacheKey = tempSession.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, objectClass, descriptor, false)) == null) ** GOTO lbl35
            if (this.checkDatabaseIfInvalid) {
                this.checkDescriptor(object, session);
                if (this.descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis())) {
                    return null;
                }
            }
            objectFromCache = cacheKey.getObject();
            if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).wasDeleted(objectFromCache)) {
                if (this.shouldCheckCacheForDoesExist()) {
                    return Boolean.FALSE;
                }
            } else {
                return Boolean.TRUE;
lbl35:
                // 1 sources

                if (this.shouldCheckCacheForDoesExist()) {
                    return Boolean.FALSE;
                }
            }
        }
        if (this.shouldAssumeNonExistenceForDoesExist()) {
            return Boolean.FALSE;
        }
        if (this.shouldAssumeExistenceForDoesExist()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        return this.checkEarlyReturn(this.getObject(), this.getPrimaryKey(), session, translationRow);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        DatabaseField field2 = this.getDoesExistField();
        AbstractRecord databaseRow = this.getQueryMechanism().selectRowForDoesExist(field2);
        return databaseRow != null;
    }

    protected DatabaseField getDoesExistField() {
        return this.descriptor.getPrimaryKeyFields().get(0);
    }

    public int getExistencePolicy() {
        return this.existencePolicy;
    }

    public Object getObject() {
        return this.object;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    @Override
    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    @Override
    protected void prepare() throws QueryException {
        if (this.getObject() != null) {
            this.checkDescriptor(this.getObject(), this.getSession());
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        super.prepare();
        this.getQueryMechanism().prepareDoesExist(this.getDoesExistField());
    }

    public void checkDescriptor(Object object, AbstractSession session) throws QueryException {
        if (this.descriptor == null) {
            if (object == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            ClassDescriptor referenceDescriptor = session.getDescriptor(object);
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(object.getClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    @Override
    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.descriptor.getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.descriptor == null) {
            this.setDescriptor(this.getSession().getDescriptor(this.getObject().getClass()));
        }
        if (this.getPrimaryKey() == null) {
            this.setPrimaryKey(this.descriptor.getObjectBuilder().extractPrimaryKeyFromObject(this.getObject(), this.getSession()));
        }
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }

    public void setExistencePolicy(int existencePolicy) {
        this.existencePolicy = existencePolicy;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setPrimaryKey(Object primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean shouldAssumeExistenceForDoesExist() {
        return this.existencePolicy == 2;
    }

    public boolean shouldAssumeNonExistenceForDoesExist() {
        return this.existencePolicy == 1;
    }

    public boolean shouldCheckCacheForDoesExist() {
        return this.existencePolicy == 3;
    }

    public boolean shouldCheckDatabaseForDoesExist() {
        return this.existencePolicy == 4;
    }

    public void setCheckCacheFirst(boolean checkCacheFirst) {
        this.checkCacheFirst = checkCacheFirst;
    }

    public boolean getCheckCacheFirst() {
        return this.checkCacheFirst;
    }

    public void setCheckDatabaseIfInvalid(boolean checkCacheFirst) {
        this.checkCacheFirst = checkCacheFirst;
    }

    public boolean getCheckDatabaseIfInvalid() {
        return this.checkCacheFirst;
    }
}

