/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.InParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected transient DatabaseQuery query;
    protected List parameters;
    protected List<Integer> parameterTypes;
    public static final Integer LITERAL = 1;
    public static final Integer MODIFY = 2;
    public static final Integer TRANSLATION = 3;
    public static final Integer CUSTOM_MODIFY = 4;
    public static final Integer OUT = 5;
    public static final Integer INOUT = 6;
    public static final Integer IN = 7;
    public static final Integer OUT_CURSOR = 8;
    public static final Integer INLINE = 9;
    protected boolean isPrepared = false;
    protected boolean isNativeConnectionRequired;
    protected boolean shouldProcessTokenInQuotes = true;
    protected int returnType;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;
    protected static final int EXECUTE_UPDATE = 5;

    public List getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        return this.parameters;
    }

    public List<Integer> getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = new ArrayList<Integer>();
        }
        return this.parameterTypes;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public void setParameterTypes(List<Integer> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.returnType == 3;
    }

    public boolean isOutputParameterType(Integer parameterType) {
        return parameterType == OUT || parameterType == INOUT || parameterType == OUT_CURSOR;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    @Override
    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new DatasourceCallQueryMechanism(query, this);
    }

    @Override
    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism callMechanism = (DatasourceCallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.returnType == 4;
    }

    public boolean isExecuteUpdate() {
        return this.returnType == 5;
    }

    @Override
    public boolean isFinished() {
        return !this.isCursorReturned() && !this.isExecuteUpdate();
    }

    @Override
    public boolean isNothingReturned() {
        return this.returnType == 1;
    }

    @Override
    public boolean isOneRowReturned() {
        return this.returnType == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredPLSQLFunctionCall() {
        return false;
    }

    public boolean isStoredPLSQLProcedureCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isJPQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(AbstractSession session) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public void setExecuteUpdate() {
        this.setReturnType(5);
    }

    public boolean isReturnSet() {
        return this.returnType != 0;
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String queryString) {
    }

    public void translateCustomQuery() {
        if (this.shouldProcessTokenInQuotes) {
            if (this.getQueryString().indexOf(this.query.getParameterDelimiter()) == -1) {
                if (this.getQuery().shouldBindAllParameters() && this.getQueryString().indexOf("?") == -1) {
                    return;
                }
                this.translatePureSQLCustomQuery();
                return;
            }
        } else if (!(this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '\'') && this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '\"') && this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '`'))) {
            if (this.getQuery().shouldBindAllParameters() && !this.hasArgumentMark(this.getQueryString(), '?', '\'')) {
                return;
            }
            this.translatePureSQLCustomQuery();
            return;
        }
        int lastIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                DatabaseField field2;
                String fieldName;
                String token2;
                int poundIndex = queryString.indexOf(this.query.getParameterDelimiterChar(), lastIndex);
                if (poundIndex == -1) {
                    token2 = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token2 = queryString.substring(lastIndex, poundIndex);
                } else {
                    boolean hasPairedQuoteBeforePound = true;
                    int quotePairIndex = poundIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforePound = !hasPairedQuoteBeforePound;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforePound) {
                        endQuoteIndex = queryString.indexOf(39, poundIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token2 = queryString.substring(lastIndex, endQuoteIndex + 1);
                        poundIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token2 = queryString.substring(lastIndex, poundIndex);
                        lastIndex = poundIndex + 1;
                    }
                }
                writer.write(token2);
                if (poundIndex == -1) continue;
                int wordEndIndex = poundIndex + 1;
                while (wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1) {
                    ++wordEndIndex;
                }
                if (queryString.charAt(poundIndex + 1) == this.query.getParameterDelimiterChar()) {
                    if (queryString.charAt(poundIndex + 2) == this.query.getParameterDelimiterChar()) {
                        if (queryString.charAt(poundIndex + 3) == this.query.getParameterDelimiterChar()) {
                            fieldName = queryString.substring(poundIndex + 4, wordEndIndex);
                            field2 = this.createField(fieldName);
                            this.appendInOut(writer, field2);
                        } else {
                            fieldName = queryString.substring(poundIndex + 3, wordEndIndex);
                            field2 = this.createField(fieldName);
                            this.appendOut(writer, field2);
                        }
                    } else {
                        fieldName = queryString.substring(poundIndex + 2, wordEndIndex);
                        field2 = this.createField(fieldName);
                        this.appendModify(writer, field2);
                    }
                } else {
                    fieldName = queryString.substring(poundIndex + 1, wordEndIndex);
                    field2 = this.createField(fieldName);
                    this.appendIn(writer, field2);
                }
                lastIndex = wordEndIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translatePureSQLCustomQuery() {
        int lastIndex = 0;
        String queryString = this.getQueryString();
        int parameterIndex = 1;
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                String token2;
                int markIndex = queryString.indexOf(63, lastIndex);
                if (markIndex == -1) {
                    token2 = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token2 = queryString.substring(lastIndex, markIndex);
                    lastIndex = markIndex + 1;
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = markIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, markIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token2 = queryString.substring(lastIndex, endQuoteIndex + 1);
                        markIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token2 = queryString.substring(lastIndex, markIndex);
                        lastIndex = markIndex + 1;
                    }
                }
                writer.write(token2);
                if (markIndex == -1) continue;
                int wordEndIndex = markIndex + 1;
                while (wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1) {
                    ++wordEndIndex;
                }
                if (wordEndIndex > markIndex + 1) {
                    String fieldName = queryString.substring(markIndex + 1, wordEndIndex);
                    DatabaseField field2 = this.createField(fieldName);
                    this.appendIn(writer, field2);
                    lastIndex = wordEndIndex;
                    continue;
                }
                DatabaseField field3 = this.createField(String.valueOf(parameterIndex));
                ++parameterIndex;
                this.appendIn(writer, field3);
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.setQueryString(((Object)writer).toString());
    }

    protected DatabaseField createField(String fieldName) {
        return new DatabaseField(fieldName);
    }

    public void appendLiteral(Writer writer, Object literal) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(literal);
        this.getParameterTypes().add(LITERAL);
    }

    public void appendTranslation(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(TRANSLATION);
    }

    public void appendModify(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(MODIFY);
    }

    public void appendIn(Writer writer, DatabaseField field2) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(field2);
        this.getParameterTypes().add(IN);
    }

    public void appendInOut(Writer writer, DatabaseField inoutField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(INOUT);
    }

    public void appendOut(Writer writer, DatabaseField outField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(outField);
        this.getParameterTypes().add(OUT);
    }

    public void appendParameter(Writer writer, Object parameter, AbstractSession session) {
        session.getDatasourcePlatform().appendParameter(this, writer, parameter);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (this.parameters == null || this.getParameters().isEmpty()) {
            return;
        }
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            List parameterFields = this.getParameters();
            List<Integer> parameterTypes = this.getParameterTypes();
            this.setParameters(new ArrayList(parameterFields.size()));
            while (lastIndex != -1) {
                Object value2;
                String token2;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token2 = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token2 = queryString.substring(lastIndex, tokenIndex);
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = tokenIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, tokenIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token2 = queryString.substring(lastIndex, endQuoteIndex + 1);
                        tokenIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token2 = queryString.substring(lastIndex, tokenIndex);
                        lastIndex = tokenIndex + 1;
                    }
                }
                writer.write(token2);
                if (tokenIndex == -1) continue;
                Integer parameterType = parameterTypes.get(parameterIndex);
                Object parameter = parameterFields.get(parameterIndex);
                if (parameterType == MODIFY) {
                    DatabaseField field2 = (DatabaseField)parameter;
                    value2 = modifyRow.get(field2);
                    this.appendParameter(writer, value2, session);
                } else if (parameterType == CUSTOM_MODIFY) {
                    DatabaseField field3 = (DatabaseField)parameter;
                    value2 = modifyRow.get(field3);
                    if (value2 != null && (value2 = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value2, field3, false)) instanceof BindCallCustomParameter && ((BindCallCustomParameter)value2).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    this.appendParameter(writer, value2, session);
                } else if (parameterType == TRANSLATION) {
                    Object value3 = null;
                    if (parameter instanceof ParameterExpression) {
                        value3 = ((ParameterExpression)parameter).getValue(translationRow, this.getQuery(), session);
                    } else {
                        DatabaseField field4 = (DatabaseField)parameter;
                        value3 = translationRow.get(field4);
                        if (value3 == null && modifyRow != null) {
                            value3 = modifyRow.get(field4);
                        }
                    }
                    this.appendParameter(writer, value3, session);
                } else if (parameterType == LITERAL) {
                    if (parameter instanceof DatabaseField) {
                        parameter = null;
                    }
                    this.appendParameter(writer, parameter, session);
                } else if (parameterType == IN) {
                    Object value4 = this.getValueForInParameter(parameter, translationRow, modifyRow, session, false);
                    this.appendParameter(writer, value4, session);
                } else if (parameterType == INOUT) {
                    Object value5 = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                    this.appendParameter(writer, value5, session);
                } else if (parameterType == INLINE) {
                    writer.write((String)parameter);
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected Object getValueForInParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session, boolean shouldBind) {
        Object value2 = parameter;
        DatabaseField field2 = null;
        boolean isNull = false;
        if (parameter instanceof ParameterExpression) {
            value2 = ((ParameterExpression)parameter).getValue(translationRow, this.getQuery(), session);
            field2 = ((ParameterExpression)parameter).getField();
        } else if (parameter instanceof DatabaseField) {
            DatabaseField modifyField;
            field2 = (DatabaseField)parameter;
            value2 = translationRow.get(field2);
            if (modifyRow != null) {
                if (value2 == null) {
                    value2 = modifyRow.get(field2);
                }
                if (value2 != null && (modifyField = modifyRow.getField(field2)) != null && session.getDatasourcePlatform().shouldUseCustomModifyForCall(modifyField)) {
                    value2 = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value2, modifyField, shouldBind);
                }
            }
            if (value2 == null && shouldBind) {
                isNull = true;
                if (field2.getType() != null || field2.getSqlType() != Integer.MIN_VALUE) {
                    value2 = field2;
                } else if (modifyRow != null && (modifyField = modifyRow.getField(field2)) != null && modifyField.getType() != null) {
                    value2 = modifyField;
                }
                if (value2 == null) {
                    DatabaseField translationField = translationRow.getField(field2);
                    if (translationField == null) {
                        session.log(6, "sql", "named_argument_not_found_in_query_parameters", new Object[]{field2});
                    }
                    if (translationField != null && translationField.getType() != null) {
                        value2 = translationField;
                    }
                }
            } else if (parameter instanceof ObjectRelationalDatabaseField) {
                value2 = new InParameterForCallableStatement(value2, (DatabaseField)parameter);
            }
        }
        if ((value2 == null || isNull) && this.query.hasNullableArguments() && this.query.getNullableArguments().contains(field2)) {
            return this;
        }
        return value2;
    }

    protected Object getValueForInOutParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        Object inParameter = ((Object[])parameter)[0];
        Object inValue = this.getValueForInParameter(inParameter, translationRow, modifyRow, session, true);
        Object outParameter = ((Object[])parameter)[1];
        return this.createInOutParameter(inValue, outParameter, session);
    }

    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        Object[] inOut = new Object[]{inValue, outParameter};
        return inOut;
    }

    private boolean hasArgumentMark(String string2, char mark, char quote) {
        int markIndex;
        int quoteIndex = -1;
        int lastEndQuoteIndex = -1;
        do {
            if ((markIndex = string2.indexOf(mark, lastEndQuoteIndex + 1)) == -1) {
                return false;
            }
            quoteIndex = string2.lastIndexOf(quote, markIndex);
            if (quoteIndex == -1) {
                return true;
            }
            boolean hasPairedQuoteBeforeMark = false;
            while (quoteIndex != -1 && quoteIndex >= lastEndQuoteIndex) {
                if ((quoteIndex = string2.lastIndexOf(quote, quoteIndex - 1)) == -1) continue;
                boolean bl = hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
            }
            if (!hasPairedQuoteBeforeMark) continue;
            return true;
        } while ((lastEndQuoteIndex = string2.indexOf(quote, markIndex + 1)) != -1);
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.parameterTypes != null) {
            ArrayList<Integer> newParameterTypes = new ArrayList<Integer>(this.parameterTypes.size());
            for (Integer type : this.parameterTypes) {
                if (LITERAL.equals(type)) {
                    newParameterTypes.add(LITERAL);
                    continue;
                }
                if (MODIFY.equals(type)) {
                    newParameterTypes.add(MODIFY);
                    continue;
                }
                if (TRANSLATION.equals(type)) {
                    newParameterTypes.add(TRANSLATION);
                    continue;
                }
                if (CUSTOM_MODIFY.equals(type)) {
                    newParameterTypes.add(CUSTOM_MODIFY);
                    continue;
                }
                if (OUT.equals(type)) {
                    newParameterTypes.add(OUT);
                    continue;
                }
                if (INOUT.equals(type)) {
                    newParameterTypes.add(INOUT);
                    continue;
                }
                if (IN.equals(type)) {
                    newParameterTypes.add(IN);
                    continue;
                }
                if (!OUT_CURSOR.equals(type)) continue;
                newParameterTypes.add(OUT_CURSOR);
            }
            this.parameterTypes = newParameterTypes;
        }
    }
}

